/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.type;

import java.time.Instant;
import java.util.List;
import org.xipki.ocsp.server.type.ASN1Type;
import org.xipki.ocsp.server.type.Extensions;
import org.xipki.ocsp.server.type.ResponderID;
import org.xipki.ocsp.server.type.SingleResponse;

public class ResponseData
extends ASN1Type {
    private final int version;
    private final ResponderID responderId;
    private final Instant producedAt;
    private final List<SingleResponse> responses;
    private final Extensions extensions;
    private final int bodyLength;
    private final int encodedLength;

    public ResponseData(int version, ResponderID responderId, Instant producedAt, List<SingleResponse> responses, Extensions extensions) {
        if (version < 0 || version > 127) {
            throw new IllegalArgumentException("invalid version: " + version);
        }
        this.version = version;
        this.responderId = responderId;
        this.producedAt = producedAt;
        this.responses = responses;
        this.extensions = extensions;
        int len = 0;
        if (version != 0) {
            len += 5;
        }
        len += responderId.getEncodedLength();
        len += 17;
        int responsesBodyLen = 0;
        for (SingleResponse sr : responses) {
            responsesBodyLen += sr.getEncodedLength();
        }
        len += ResponseData.getLen(responsesBodyLen);
        if (extensions != null) {
            len += ResponseData.getLen(extensions.getEncodedLength());
        }
        this.bodyLength = len;
        this.encodedLength = ResponseData.getLen(this.bodyLength);
    }

    @Override
    public int getEncodedLength() {
        return this.encodedLength;
    }

    @Override
    public int write(byte[] out, int offset) {
        int idx = offset;
        idx += ResponseData.writeHeader((byte)48, this.bodyLength, out, idx);
        if (this.version != 0) {
            idx += ResponseData.writeHeader((byte)-96, 3, out, idx);
            idx += ResponseData.writeHeader((byte)2, 1, out, idx);
            out[idx++] = (byte)this.version;
        }
        idx += this.responderId.write(out, idx);
        idx += ResponseData.writeGeneralizedTime(this.producedAt, out, idx);
        int responsesBodyLen = 0;
        for (SingleResponse sr : this.responses) {
            responsesBodyLen += sr.getEncodedLength();
        }
        idx += ResponseData.writeHeader((byte)48, responsesBodyLen, out, idx);
        for (SingleResponse sr : this.responses) {
            idx += sr.write(out, idx);
        }
        if (this.extensions != null) {
            idx += ResponseData.writeHeader((byte)-95, this.extensions.getEncodedLength(), out, idx);
            idx += this.extensions.write(out, idx);
        }
        return idx - offset;
    }
}

