/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.Closeable;
import java.security.Key;
import java.security.PublicKey;
import java.security.SignatureException;
import org.xipki.security.NoIdleSignerException;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.XiContentSigner;
import org.xipki.security.XiSecurityException;
import org.xipki.util.ConcurrentBag;

public interface ConcurrentContentSigner
extends Closeable {
    public String getName();

    public SignAlgo getAlgorithm();

    public boolean isMac();

    public byte[] getSha1OfMacKey();

    public Key getSigningKey();

    public void setPublicKey(PublicKey var1);

    public PublicKey getPublicKey();

    public X509Cert getCertificate();

    public void setCertificateChain(X509Cert[] var1);

    public X509Cert[] getCertificateChain();

    public void initialize(String var1) throws XiSecurityException;

    public byte[] sign(byte[] var1) throws NoIdleSignerException, SignatureException;

    public byte[][] sign(byte[][] var1) throws NoIdleSignerException, SignatureException;

    public ConcurrentBag.BagEntry<XiContentSigner> borrowSigner() throws NoIdleSignerException;

    public ConcurrentBag.BagEntry<XiContentSigner> borrowSigner(int var1) throws NoIdleSignerException;

    public void requiteSigner(ConcurrentBag.BagEntry<XiContentSigner> var1);

    public boolean isHealthy();
}

