/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Set;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DHSigStaticKeyCertPair;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.util.exception.ObjectCreationException;

public interface SecurityFactory {
    public Set<String> getSupportedSignerTypes();

    public ConcurrentContentSigner createSigner(String var1, SignerConf var2, X509Cert var3) throws ObjectCreationException;

    public ConcurrentContentSigner createSigner(String var1, SignerConf var2, X509Cert[] var3) throws ObjectCreationException;

    public ContentVerifierProvider getContentVerifierProvider(PublicKey var1) throws InvalidKeyException;

    public ContentVerifierProvider getContentVerifierProvider(PublicKey var1, DHSigStaticKeyCertPair var2) throws InvalidKeyException;

    public ContentVerifierProvider getContentVerifierProvider(X509Cert var1) throws InvalidKeyException;

    public boolean verifyPop(PKCS10CertificationRequest var1, AlgorithmValidator var2);

    public boolean verifyPop(PKCS10CertificationRequest var1, AlgorithmValidator var2, DHSigStaticKeyCertPair var3);

    public boolean verifyPop(CertificationRequest var1, AlgorithmValidator var2);

    public boolean verifyPop(CertificationRequest var1, AlgorithmValidator var2, DHSigStaticKeyCertPair var3);

    public PublicKey generatePublicKey(SubjectPublicKeyInfo var1) throws InvalidKeyException;

    public SecureRandom getRandom4Sign();

    public SecureRandom getRandom4Key();

    public int getDfltSignerParallelism();
}

