/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.jce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.xipki.security.SignAlgo;
import org.xipki.security.XiContentSigner;
import org.xipki.security.XiSecurityException;

public class JceSigner
implements XiContentSigner {
    private final PrivateKey signKey;
    private final SignAlgo signAlgo;
    private final Signature signature;
    private final SignerOutputStream stream;
    private final byte[] encodedAlgId;

    public JceSigner(PrivateKey signKey, SignAlgo signAlgo, String providerName, Provider provider) throws XiSecurityException {
        this.signKey = signKey;
        this.signAlgo = signAlgo;
        String jceName = signAlgo.getJceName();
        try {
            this.signature = providerName == null && provider == null ? Signature.getInstance(jceName) : (provider != null ? Signature.getInstance(jceName, provider) : Signature.getInstance(signAlgo.getJceName(), providerName));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException exception) {
            throw new XiSecurityException(exception);
        }
        this.stream = new SignerOutputStream();
        try {
            this.encodedAlgId = signAlgo.getAlgorithmIdentifier().getEncoded();
        }
        catch (IOException e) {
            throw new XiSecurityException(e);
        }
    }

    @Override
    public byte[] getEncodedAlgorithmIdentifier() {
        return (byte[])this.encodedAlgId.clone();
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.signAlgo.getAlgorithmIdentifier();
    }

    public OutputStream getOutputStream() {
        try {
            this.signature.initSign(this.signKey);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        return this.stream;
    }

    public byte[] getSignature() {
        try {
            return this.signature.sign();
        }
        catch (SignatureException ex) {
            throw new RuntimeCryptoException(ex.getMessage());
        }
    }

    private class SignerOutputStream
    extends OutputStream {
        private SignerOutputStream() {
        }

        @Override
        public void write(int oneByte) throws IOException {
            try {
                JceSigner.this.signature.update((byte)oneByte);
            }
            catch (SignatureException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            try {
                JceSigner.this.signature.update(bytes);
            }
            catch (SignatureException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            try {
                JceSigner.this.signature.update(bytes, off, len);
            }
            catch (SignatureException e) {
                throw new IOException(e);
            }
        }
    }
}

