/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.xipki.pkcs11.wrapper.AttributeVector;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11KeyId;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.pkcs11.wrapper.params.ExtraParams;
import org.xipki.security.EdECConstants;
import org.xipki.security.pkcs11.NativeP11Slot;
import org.xipki.security.pkcs11.P11Key;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.Args;

class NativeP11Key
extends P11Key {
    NativeP11Key(NativeP11Slot slot, PKCS11KeyId keyId) {
        super(slot, keyId);
    }

    @Override
    protected byte[] digestSecretKey0(long mechanism) throws TokenException {
        if (!this.isSecretKey()) {
            throw new TokenException("digestSecretKey could not be applied to non-SecretKey");
        }
        return this.slot.digestSecretKey(mechanism, this.keyId.getHandle());
    }

    @Override
    public void destroy() throws TokenException {
        if (this.keyId.getPublicKeyHandle() == null) {
            this.slot.destroyObjectsByHandle(this.keyId.getHandle());
        } else {
            this.slot.destroyObjectsByHandle(this.keyId.getHandle(), this.keyId.getPublicKeyHandle());
        }
    }

    @Override
    protected byte[] sign0(long mechanism, P11Params parameters, byte[] content) throws TokenException {
        Args.notNull((Object)content, (String)"content");
        ExtraParams extraParams = null;
        if (this.ecOrderBitSize != null) {
            extraParams = new ExtraParams().ecOrderBitSize(this.ecOrderBitSize.intValue());
        }
        return this.slot.sign(mechanism, parameters, extraParams, this.keyId.getHandle(), content);
    }

    @Override
    protected PublicKey getPublicKey0() throws TokenException {
        long keyType = this.keyId.getKeyType();
        if (keyType == 0L) {
            try {
                return KeyUtil.generateRSAPublicKey(new RSAPublicKeySpec(this.rsaModulus, this.rsaPublicExponent));
            }
            catch (InvalidKeySpecException ex) {
                throw new TokenException(ex.getMessage(), (Exception)ex);
            }
        }
        Long publicKeyHandle = this.keyId.getPublicKeyHandle();
        if (publicKeyHandle == null) {
            return null;
        }
        if (keyType == 1L) {
            AttributeVector attrs = ((NativeP11Slot)this.slot).getAttrValues(publicKeyHandle, 17L);
            DSAPublicKeySpec keySpec = new DSAPublicKeySpec(new BigInteger(1, attrs.value()), this.dsaP, this.dsaQ, this.dsaG);
            try {
                return KeyUtil.generateDSAPublicKey(keySpec);
            }
            catch (InvalidKeySpecException ex) {
                throw new TokenException(ex.getMessage(), (Exception)ex);
            }
        }
        if (keyType == 3L || keyType == 0xFFFFF001L || keyType == 64L || keyType == 65L) {
            byte[] ecPoint = ((NativeP11Slot)this.slot).getAttrValues(publicKeyHandle, 385L).ecPoint();
            ASN1ObjectIdentifier curveOid = this.ecParams;
            if (keyType == 64L || keyType == 65L) {
                if (keyType == 64L) {
                    if (!EdECConstants.isEdwardsCurve(curveOid)) {
                        throw new TokenException("unknown Edwards curve OID " + curveOid);
                    }
                } else if (!EdECConstants.isMontgomeryCurve(curveOid)) {
                    throw new TokenException("unknown Montgomery curve OID " + curveOid);
                }
                SubjectPublicKeyInfo pkInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(curveOid), ecPoint);
                try {
                    return KeyUtil.generatePublicKey(pkInfo);
                }
                catch (InvalidKeySpecException ex) {
                    throw new TokenException(ex.getMessage(), (Exception)ex);
                }
            }
            try {
                return KeyUtil.createECPublicKey(curveOid, ecPoint);
            }
            catch (InvalidKeySpecException ex) {
                throw new TokenException(ex.getMessage(), (Exception)ex);
            }
        }
        throw new TokenException("unknown key type " + PKCS11Constants.ckkCodeToName((long)keyType));
    }
}

