/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs12;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.xipki.password.PasswordResolverException;
import org.xipki.password.Passwords;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.EdECConstants;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.SignerConf;
import org.xipki.security.SignerFactory;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs12.KeypairWithCert;
import org.xipki.security.pkcs12.P12ContentSignerBuilder;
import org.xipki.security.pkcs12.P12MacContentSignerBuilder;
import org.xipki.security.pkcs12.P12XdhMacContentSignerBuilder;
import org.xipki.util.Base64;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.ObjectCreationException;

public class P12SignerFactory
implements SignerFactory {
    private static final String TYPE_PKCS12 = "pkcs12";
    private static final String TYPE_JCEKS = "jceks";
    private static final Set<String> types = Set.of("pkcs12", "jceks");
    private SecurityFactory securityFactory;

    public void setSecurityFactory(SecurityFactory securityFactory) {
        this.securityFactory = securityFactory;
    }

    @Override
    public Set<String> getSupportedSignerTypes() {
        return types;
    }

    @Override
    public boolean canCreateSigner(String type) {
        return types.contains(type.toLowerCase());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ConcurrentContentSigner newSigner(String type, SignerConf conf, X509Cert[] certificateChain) throws ObjectCreationException {
        if (!this.canCreateSigner(type)) {
            throw new ObjectCreationException("unknown signer type " + type);
        }
        String str = conf.getConfValue("parallelism");
        int parallelism = this.securityFactory.getDfltSignerParallelism();
        if (str != null) {
            try {
                parallelism = Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                throw new ObjectCreationException("invalid parallelism " + str);
            }
            if (parallelism < 1) {
                throw new ObjectCreationException("invalid parallelism " + str);
            }
        }
        String passwordHint = conf.getConfValue("password");
        char[] password = this.getPassword(passwordHint);
        str = conf.getConfValue("keystore");
        String keyLabel = conf.getConfValue("key-label");
        try (InputStream keystoreStream = P12SignerFactory.getInputStream(str);){
            Object signerBuilder;
            SubjectPublicKeyInfo spki;
            SignAlgo sigAlgo = null;
            String algoName = conf.getConfValue("algo");
            if (algoName != null) {
                sigAlgo = SignAlgo.getInstance(algoName);
            }
            if (sigAlgo != null && sigAlgo.isMac()) {
                P12MacContentSignerBuilder signerBuilder2 = new P12MacContentSignerBuilder(type, keystoreStream, password, keyLabel, password);
                ConcurrentContentSigner concurrentContentSigner = signerBuilder2.createSigner(sigAlgo, parallelism);
                return concurrentContentSigner;
            }
            KeypairWithCert keypairWithCert = KeypairWithCert.fromKeystore(type, keystoreStream, password, keyLabel, password, certificateChain);
            PublicKey publicKey = keypairWithCert.getPublicKey();
            ASN1ObjectIdentifier xdhCurveOid = null;
            if (!(publicKey instanceof RSAPublicKey || publicKey instanceof ECPublicKey || publicKey instanceof DSAPublicKey || EdECConstants.isMontgomeryCurve(xdhCurveOid = (spki = keypairWithCert.getCertificateChain()[0].getSubjectPublicKeyInfo()).getAlgorithm().getAlgorithm()))) {
                xdhCurveOid = null;
            }
            if (xdhCurveOid != null) {
                signerBuilder = P12SignerFactory.getP12XdhMacContentSignerBuilder(conf, xdhCurveOid, keypairWithCert);
                ConcurrentContentSigner concurrentContentSigner = ((P12XdhMacContentSignerBuilder)signerBuilder).createSigner(parallelism);
                return concurrentContentSigner;
            }
            signerBuilder = new P12ContentSignerBuilder(keypairWithCert);
            if (sigAlgo == null) {
                PublicKey pubKey = ((P12ContentSignerBuilder)signerBuilder).getCertificate().getPublicKey();
                sigAlgo = SignAlgo.getInstance(pubKey, conf);
            }
            ConcurrentContentSigner concurrentContentSigner = ((P12ContentSignerBuilder)signerBuilder).createSigner(sigAlgo, parallelism, this.securityFactory.getRandom4Sign());
            return concurrentContentSigner;
        }
        catch (IOException | NoSuchAlgorithmException | XiSecurityException ex) {
            throw new ObjectCreationException(String.format("%s: %s", ex.getClass().getName(), ex.getMessage()));
        }
    }

    private static P12XdhMacContentSignerBuilder getP12XdhMacContentSignerBuilder(SignerConf conf, ASN1ObjectIdentifier curveId, KeypairWithCert keypairWithCert) throws ObjectCreationException, XiSecurityException {
        X509Cert peerCert = null;
        List<X509Cert> peerCerts = conf.getPeerCertificates();
        if (peerCerts != null) {
            for (X509Cert m : conf.getPeerCertificates()) {
                if (!curveId.equals((ASN1Primitive)m.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm())) continue;
                peerCert = m;
                break;
            }
        }
        if (peerCert == null) {
            throw new ObjectCreationException("could not find peer certificate for algorithm " + curveId.getId());
        }
        return new P12XdhMacContentSignerBuilder(keypairWithCert, peerCert);
    }

    private char[] getPassword(String passwordHint) throws ObjectCreationException {
        char[] password;
        if (passwordHint == null) {
            password = null;
        } else if (!passwordHint.contains(":")) {
            password = passwordHint.toCharArray();
        } else {
            try {
                password = Passwords.resolvePassword((String)passwordHint);
            }
            catch (PasswordResolverException ex) {
                throw new ObjectCreationException("could not resolve password. Message: " + ex.getMessage());
            }
        }
        return password;
    }

    private static InputStream getInputStream(String str) throws ObjectCreationException {
        if (StringUtil.startsWithIgnoreCase((String)str, (String)"base64:")) {
            return new ByteArrayInputStream(Base64.decode((String)str.substring("base64:".length())));
        }
        if (StringUtil.startsWithIgnoreCase((String)str, (String)"file:")) {
            String fn = str.substring("file:".length());
            try {
                return Files.newInputStream(Paths.get(IoUtil.detectPath((String)fn), new String[0]), new OpenOption[0]);
            }
            catch (IOException ex) {
                throw new ObjectCreationException("file not found: " + fn);
            }
        }
        throw new ObjectCreationException("unknown content format");
    }
}

