/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs12;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.operator.RuntimeOperatorException;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DfltConcurrentContentSigner;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.XiContentSigner;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs12.HmacContentSigner;
import org.xipki.security.pkcs12.KeypairWithCert;
import org.xipki.util.Args;

public class P12XdhMacContentSignerBuilder {
    private SecretKey key;
    private SignAlgo algo;
    private IssuerAndSerialNumber peerIssuerAndSerial;
    private final PublicKey publicKey;
    private final X509Cert[] certificateChain;

    public P12XdhMacContentSignerBuilder(X509Cert peerCert, PrivateKey privateKey, PublicKey publicKey) throws XiSecurityException {
        this.publicKey = (PublicKey)Args.notNull((Object)publicKey, (String)"publicKey");
        this.certificateChain = null;
        this.init((PrivateKey)Args.notNull((Object)privateKey, (String)"privateKey"), (X509Cert)Args.notNull((Object)peerCert, (String)"peerCert"));
    }

    public P12XdhMacContentSignerBuilder(KeypairWithCert keypairWithCert, X509Cert peerCert) throws XiSecurityException {
        this.publicKey = ((KeypairWithCert)Args.notNull((Object)keypairWithCert, (String)"keypairWithCert")).getPublicKey();
        this.certificateChain = keypairWithCert.getCertificateChain();
        this.init(keypairWithCert.getKey(), (X509Cert)Args.notNull((Object)peerCert, (String)"peerCert"));
    }

    private void init(PrivateKey privateKey, X509Cert peerCert) throws XiSecurityException {
        byte[] trailingInfo;
        byte[] leadingInfo;
        byte[] zz;
        String algorithm = privateKey.getAlgorithm();
        if ("X25519".equalsIgnoreCase(algorithm)) {
            this.algo = SignAlgo.DHPOP_X25519;
        } else if ("X448".equalsIgnoreCase(algorithm)) {
            this.algo = SignAlgo.DHPOP_X448;
        } else {
            throw new IllegalArgumentException("unsupported key.getAlgorithm(): " + algorithm);
        }
        PublicKey peerPubKey = peerCert.getPublicKey();
        if (!algorithm.equalsIgnoreCase(peerPubKey.getAlgorithm())) {
            throw new IllegalArgumentException("peerCert and key does not match");
        }
        try {
            KeyAgreement keyAgreement = KeyAgreement.getInstance(algorithm, "BC");
            keyAgreement.init(privateKey);
            keyAgreement.doPhase(peerPubKey, true);
            zz = keyAgreement.generateSecret();
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new XiSecurityException("KeyChange error", ex);
        }
        try {
            leadingInfo = peerCert.getSubject().getEncoded();
            trailingInfo = peerCert.getIssuer().getEncoded();
        }
        catch (IOException ex) {
            throw new XiSecurityException("error encoding certificate", ex);
        }
        byte[] k = this.algo.getHashAlgo().hash(leadingInfo, zz, trailingInfo);
        this.key = new SecretKeySpec(k, this.algo.getJceName());
        this.peerIssuerAndSerial = new IssuerAndSerialNumber(X500Name.getInstance((Object)trailingInfo), peerCert.getSerialNumber());
    }

    public ConcurrentContentSigner createSigner(int parallelism) throws XiSecurityException {
        DfltConcurrentContentSigner concurrentSigner;
        ArrayList<XiContentSigner> signers = new ArrayList<XiContentSigner>(Args.positive((int)parallelism, (String)"parallelism"));
        for (int i = 0; i < parallelism; ++i) {
            XdhMacContentSigner signer = new XdhMacContentSigner(this.algo, this.key, this.peerIssuerAndSerial);
            signers.add(signer);
        }
        boolean mac = true;
        try {
            concurrentSigner = new DfltConcurrentContentSigner(true, signers, this.key);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XiSecurityException(ex.getMessage(), ex);
        }
        concurrentSigner.setSha1DigestOfMacKey(HashAlgo.SHA1.hash(new byte[][]{this.key.getEncoded()}));
        if (this.certificateChain != null) {
            concurrentSigner.setCertificateChain(this.certificateChain);
        } else {
            concurrentSigner.setPublicKey(this.publicKey);
        }
        return concurrentSigner;
    }

    private static class XdhMacContentSigner
    extends HmacContentSigner {
        private final byte[] prefix;
        private final int hashLen;

        private XdhMacContentSigner(SignAlgo signAlgo, SecretKey signingKey, IssuerAndSerialNumber peerIssuerAndSerial) throws XiSecurityException {
            super(signAlgo, signingKey);
            byte[] encodedSig;
            this.hashLen = signAlgo.getHashAlgo().getLength();
            ASN1EncodableVector vec = new ASN1EncodableVector();
            if (peerIssuerAndSerial != null) {
                vec.add((ASN1Encodable)peerIssuerAndSerial);
            }
            vec.add((ASN1Encodable)new DEROctetString(new byte[this.hashLen]));
            try {
                encodedSig = new DERSequence(vec).getEncoded();
            }
            catch (IOException ex) {
                throw new XiSecurityException("exception initializing ContentSigner: " + ex.getMessage(), ex);
            }
            this.prefix = Arrays.copyOfRange(encodedSig, 0, encodedSig.length - this.hashLen);
        }

        @Override
        public byte[] getSignature() {
            byte[] hashValue = super.getSignature();
            if (hashValue.length != this.hashLen) {
                throw new RuntimeOperatorException("exception obtaining signature: invalid signature length");
            }
            byte[] sigValue = new byte[this.prefix.length + this.hashLen];
            System.arraycopy(this.prefix, 0, sigValue, 0, this.prefix.length);
            System.arraycopy(hashValue, 0, sigValue, this.prefix.length, this.hashLen);
            return sigValue;
        }
    }
}

