/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.shell;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.entry.KeypairGenEntry;
import org.xipki.ca.mgmt.shell.CaActions;
import org.xipki.ca.mgmt.shell.CaCompleters;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class KeypairGenActions {

    @Command(scope="ca", name="keypairgen-up", description="update keypair generation")
    @Service
    public static class KeypairGenUp
    extends CaActions.CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="keypair generation name")
        @Completion(value=CaCompleters.KeypairGenNameCompleter.class)
        protected String name;
        @Option(name="--type", description="keypair generation type")
        @Completion(value=CaCompleters.KeypairGenTypeCompleter.class)
        protected String type;
        @Option(name="--conf", description="keypair generation configuration or 'null'")
        protected String conf;
        @Option(name="--conf-file", description="keypair generation configuration file")
        @Completion(value=FileCompleter.class)
        protected String confFile;

        protected Object execute0() throws Exception {
            if (this.type == null && this.conf == null && this.confFile == null) {
                throw new IllegalCmdParamException("nothing to update");
            }
            if (this.conf == null && this.confFile != null) {
                this.conf = StringUtil.toUtf8String((byte[])IoUtil.read((String)this.confFile));
            }
            String msg = "keypair generation " + this.name;
            try {
                this.caManager.changeKeypairGen(this.name, this.type, this.conf);
                this.println("updated " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not update " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="keypairgen-rm", description="remove keypair generation")
    @Service
    public static class KeypairGenRm
    extends CaActions.CaAction {
        @Argument(index=0, name="name", required=true, description="keypair generation name")
        @Completion(value=CaCompleters.KeypairGenNameCompleter.class)
        private String name;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            String msg = "keypair generation " + this.name;
            if (this.force.booleanValue() || this.confirm("Do you want to remove " + msg, 3)) {
                try {
                    this.caManager.removeKeypairGen(this.name);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="keypairgen-info", description="show information of keypair generation")
    @Service
    public static class KeypairGenInfo
    extends CaActions.CaAction {
        @Argument(index=0, name="name", description="keypair generation name")
        @Completion(value=CaCompleters.KeypairGenNameCompleter.class)
        private String name;

        protected Object execute0() throws Exception {
            if (this.name == null) {
                Set names = this.caManager.getKeypairGenNames();
                int size = names.size();
                StringBuilder sb = new StringBuilder();
                if (size == 0 || size == 1) {
                    sb.append(size == 0 ? "no" : "1").append(" keypair generation is configured\n");
                } else {
                    sb.append(size).append(" keypair generation entries are configured:\n");
                }
                ArrayList sorted = new ArrayList(names);
                Collections.sort(sorted);
                for (String entry : sorted) {
                    sb.append("\t").append(entry).append("\n");
                }
                this.println(sb.toString());
            } else {
                KeypairGenEntry entry = Optional.ofNullable(this.caManager.getKeypairGen(this.name)).orElseThrow(() -> new CmdFailure("\tno keypair generation named '" + this.name + "' is configured"));
                this.println(entry.toString());
            }
            return null;
        }
    }

    @Command(scope="ca", name="keypairgen-add", description="add keypair generation")
    @Service
    public static class KeypairGenAdd
    extends CaActions.CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="keypair generation name")
        @Completion(value=CaCompleters.KeypairGenNameCompleter.class)
        private String name;
        @Option(name="--type", required=true, description="keypair generation type")
        @Completion(value=CaCompleters.KeypairGenTypeCompleter.class)
        private String type;
        @Option(name="--conf", description="keypair generation configuration")
        private String conf;
        @Option(name="--conf-file", description="keypair generation configuration file")
        @Completion(value=FileCompleter.class)
        private String confFile;

        protected Object execute0() throws Exception {
            if (this.conf == null && this.confFile != null) {
                this.conf = StringUtil.toUtf8String((byte[])IoUtil.read((String)this.confFile));
            }
            KeypairGenEntry entry = new KeypairGenEntry(this.name, this.type, this.conf);
            String msg = "keypair generation " + this.name;
            try {
                this.caManager.addKeypairGen(entry);
                this.println("added " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

