/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.certprofile.xijson;

import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import org.xipki.ca.certprofile.xijson.conf.QcStatements;
import org.xipki.util.Args;

class MonetaryValueOption {
    private final Iso4217CurrencyCode currency;
    private final String currencyString;
    private final QcStatements.Range2Type amountRange;
    private final QcStatements.Range2Type exponentRange;

    public MonetaryValueOption(Iso4217CurrencyCode currency, QcStatements.Range2Type amountRange, QcStatements.Range2Type exponentRange) {
        this.currency = (Iso4217CurrencyCode)Args.notNull((Object)currency, (String)"currency");
        this.amountRange = (QcStatements.Range2Type)((Object)Args.notNull((Object)((Object)amountRange), (String)"amountRange"));
        this.exponentRange = (QcStatements.Range2Type)((Object)Args.notNull((Object)((Object)exponentRange), (String)"exponentRange"));
        this.currencyString = currency.isAlphabetic() ? currency.getAlphabetic().toUpperCase() : Integer.toString(currency.getNumeric());
    }

    public Iso4217CurrencyCode getCurrency() {
        return this.currency;
    }

    public QcStatements.Range2Type getAmountRange() {
        return this.amountRange;
    }

    public QcStatements.Range2Type getExponentRange() {
        return this.exponentRange;
    }

    public String getCurrencyString() {
        return this.currencyString;
    }
}

