/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.certprofile.xijson;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import org.xipki.util.Args;

public class NotBeforeOption {
    private final ZoneId midNightTimeZone;
    private final Long offsetSeconds;

    private NotBeforeOption(ZoneId midNightTimeZone, Long offsetSeconds) {
        this.midNightTimeZone = midNightTimeZone;
        this.offsetSeconds = offsetSeconds;
    }

    static NotBeforeOption getMidNightOption(ZoneId timeZone) {
        return new NotBeforeOption(timeZone, null);
    }

    static NotBeforeOption getOffsetOption(long offsetSeconds) {
        Args.min((long)offsetSeconds, (String)"offsetSeconds", (long)-600L);
        return new NotBeforeOption(null, offsetSeconds);
    }

    Instant getNotBefore(Instant requestedNotBefore) {
        long nowSecond = Instant.now().getEpochSecond();
        if (requestedNotBefore != null) {
            long notOlderThan = this.offsetSeconds != null && this.offsetSeconds < 0L ? nowSecond + this.offsetSeconds : nowSecond;
            long notBefore = Math.max(requestedNotBefore.getEpochSecond(), notOlderThan);
            return this.midNightTimeZone != null ? this.setToMidnight(notBefore) : Instant.now();
        }
        return this.midNightTimeZone != null ? this.setToMidnight(nowSecond) : Instant.now().plusSeconds(this.offsetSeconds);
    }

    private Instant setToMidnight(long epochSeconds) {
        ZonedDateTime zd = ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSeconds).plus(1L, ChronoUnit.DAYS).minus(1L, ChronoUnit.MILLIS), this.midNightTimeZone);
        return ZonedDateTime.of(zd.getYear(), zd.getMonthValue(), zd.getDayOfMonth(), 0, 0, 0, 0, this.midNightTimeZone).toInstant();
    }

    public ZoneId getMidNightTimeZone() {
        return this.midNightTimeZone;
    }

    public Long getOffsetSeconds() {
        return this.offsetSeconds;
    }
}

