/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.certprofile.xijson.conf;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.isismtt.x509.NamingAuthority;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x509.GeneralName;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.certprofile.xijson.AdmissionExtension;
import org.xipki.ca.certprofile.xijson.conf.Describable;
import org.xipki.util.CollectionUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;

public class AdmissionSyntax
extends ValidableConf {
    private byte[] admissionAuthority;
    private List<AdmissionsType> contentsOfAdmissions;

    public byte[] getAdmissionAuthority() {
        return this.admissionAuthority;
    }

    public void setAdmissionAuthority(byte[] admissionAuthority) {
        this.admissionAuthority = admissionAuthority;
    }

    public List<AdmissionsType> getContentsOfAdmissions() {
        if (this.contentsOfAdmissions == null) {
            this.contentsOfAdmissions = new LinkedList<AdmissionsType>();
        }
        return this.contentsOfAdmissions;
    }

    public void setContentsOfAdmissions(List<AdmissionsType> contentsOfAdmissions) {
        this.contentsOfAdmissions = contentsOfAdmissions;
    }

    public void validate() throws InvalidConfException {
        AdmissionSyntax.notEmpty(this.contentsOfAdmissions, (String)"contentsOfAdmissions");
        AdmissionSyntax.validate(this.contentsOfAdmissions, (Collection[])new Collection[0]);
    }

    public AdmissionExtension.AdmissionSyntaxOption toXiAdmissionSyntax(boolean critical) throws CertprofileException {
        LinkedList<AdmissionExtension.AdmissionsOption> admissionsList = new LinkedList<AdmissionExtension.AdmissionsOption>();
        for (AdmissionsType at : this.getContentsOfAdmissions()) {
            LinkedList<AdmissionExtension.ProfessionInfoOption> professionInfos = new LinkedList<AdmissionExtension.ProfessionInfoOption>();
            for (ProfessionInfoType pi : at.getProfessionInfos()) {
                RegistrationNumber rnType;
                NamingAuthority namingAuthorityL3 = null;
                if (pi.getNamingAuthority() != null) {
                    namingAuthorityL3 = AdmissionSyntax.buildNamingAuthority(pi.getNamingAuthority());
                }
                List<Describable.DescribableOid> oidTypes = pi.getProfessionOids();
                LinkedList<ASN1ObjectIdentifier> oids = null;
                if (CollectionUtil.isNotEmpty(oidTypes)) {
                    oids = new LinkedList<ASN1ObjectIdentifier>();
                    for (Describable.DescribableOid k : oidTypes) {
                        oids.add(new ASN1ObjectIdentifier(k.getOid()));
                    }
                }
                AdmissionExtension.RegistrationNumberOption rno = (rnType = pi.getRegistrationNumber()) == null ? null : new AdmissionExtension.RegistrationNumberOption(rnType.getRegex(), rnType.getConstant());
                professionInfos.add(new AdmissionExtension.ProfessionInfoOption(namingAuthorityL3, pi.getProfessionItems(), oids, rno, pi.getAddProfessionInfo()));
            }
            GeneralName admissionAuthority = null;
            if (at.getNamingAuthority() != null) {
                admissionAuthority = GeneralName.getInstance((Object)AdmissionSyntax.asn1PrimitiveFromByteArray(at.getAdmissionAuthority()));
            }
            NamingAuthority namingAuthority = null;
            if (at.getNamingAuthority() != null) {
                namingAuthority = AdmissionSyntax.buildNamingAuthority(at.getNamingAuthority());
            }
            admissionsList.add(new AdmissionExtension.AdmissionsOption(admissionAuthority, namingAuthority, professionInfos));
        }
        GeneralName tmpAdmissionAuthority = this.admissionAuthority == null ? null : GeneralName.getInstance((Object)this.admissionAuthority);
        return new AdmissionExtension.AdmissionSyntaxOption(critical, tmpAdmissionAuthority, admissionsList);
    }

    private static ASN1Primitive asn1PrimitiveFromByteArray(byte[] encoded) throws CertprofileException {
        try {
            return ASN1Primitive.fromByteArray((byte[])encoded);
        }
        catch (IOException ex) {
            throw new CertprofileException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static NamingAuthority buildNamingAuthority(NamingAuthorityType value) {
        ASN1ObjectIdentifier oid = value.getOid() == null ? null : new ASN1ObjectIdentifier(value.getOid().getOid());
        String url = StringUtil.isBlank((String)value.getUrl()) ? null : value.getUrl();
        DirectoryString text = StringUtil.isBlank((String)value.getText()) ? null : new DirectoryString(value.getText());
        return new NamingAuthority(oid, url, text);
    }

    public static class AdmissionsType
    extends ValidableConf {
        private byte[] admissionAuthority;
        private NamingAuthorityType namingAuthority;
        private List<ProfessionInfoType> professionInfos;

        public byte[] getAdmissionAuthority() {
            return this.admissionAuthority;
        }

        public void setAdmissionAuthority(byte[] admissionAuthority) {
            this.admissionAuthority = admissionAuthority;
        }

        public NamingAuthorityType getNamingAuthority() {
            return this.namingAuthority;
        }

        public void setNamingAuthority(NamingAuthorityType namingAuthority) {
            this.namingAuthority = namingAuthority;
        }

        public List<ProfessionInfoType> getProfessionInfos() {
            if (this.professionInfos == null) {
                this.professionInfos = new LinkedList<ProfessionInfoType>();
            }
            return this.professionInfos;
        }

        public void setProfessionInfos(List<ProfessionInfoType> professionInfos) {
            this.professionInfos = professionInfos;
        }

        public void validate() throws InvalidConfException {
            AdmissionsType.validate((ValidableConf)this.namingAuthority, (ValidableConf[])new ValidableConf[0]);
            AdmissionsType.notEmpty(this.professionInfos, (String)"professionInfos");
            AdmissionsType.validate(this.professionInfos, (Collection[])new Collection[0]);
        }
    }

    public static class ProfessionInfoType
    extends ValidableConf {
        private NamingAuthorityType namingAuthority;
        private List<Describable.DescribableOid> professionOids;
        private List<String> professionItems;
        private RegistrationNumber registrationNumber;
        private byte[] addProfessionInfo;

        public NamingAuthorityType getNamingAuthority() {
            return this.namingAuthority;
        }

        public void setNamingAuthority(NamingAuthorityType namingAuthority) {
            this.namingAuthority = namingAuthority;
        }

        public List<Describable.DescribableOid> getProfessionOids() {
            if (this.professionOids == null) {
                this.professionOids = new LinkedList<Describable.DescribableOid>();
            }
            return this.professionOids;
        }

        public void setProfessionOids(List<Describable.DescribableOid> professionOids) {
            this.professionOids = professionOids;
        }

        public List<String> getProfessionItems() {
            if (this.professionItems == null) {
                this.professionItems = new LinkedList<String>();
            }
            return this.professionItems;
        }

        public void setProfessionItems(List<String> professionItems) {
            this.professionItems = professionItems;
        }

        public RegistrationNumber getRegistrationNumber() {
            return this.registrationNumber;
        }

        public void setRegistrationNumber(RegistrationNumber registrationNumber) {
            this.registrationNumber = registrationNumber;
        }

        public byte[] getAddProfessionInfo() {
            return this.addProfessionInfo;
        }

        public void setAddProfessionInfo(byte[] addProfessionInfo) {
            this.addProfessionInfo = addProfessionInfo;
        }

        public void validate() throws InvalidConfException {
            ProfessionInfoType.validate((ValidableConf)this.namingAuthority, (ValidableConf[])new ValidableConf[]{this.registrationNumber});
            ProfessionInfoType.validate(this.professionOids, (Collection[])new Collection[0]);
        }
    }

    public static class NamingAuthorityType
    extends ValidableConf {
        private Describable.DescribableOid oid;
        private String url;
        private String text;

        public Describable.DescribableOid getOid() {
            return this.oid;
        }

        public void setOid(Describable.DescribableOid oid) {
            this.oid = oid;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void validate() throws InvalidConfException {
            if (this.oid == null && this.url == null && this.text == null) {
                throw new InvalidConfException("oid, url and text may not be all null");
            }
            NamingAuthorityType.validate((ValidableConf)this.oid, (ValidableConf[])new ValidableConf[0]);
        }
    }

    public static class RegistrationNumber
    extends ValidableConf {
        private String regex;
        private String constant;

        public String getRegex() {
            return this.regex;
        }

        public void setRegex(String regex) {
            this.regex = regex;
        }

        public String getConstant() {
            return this.constant;
        }

        public void setConstant(String constant) {
            this.constant = constant;
        }

        public void validate() throws InvalidConfException {
            this.exactOne(this.regex, "regex", this.constant, "constant");
        }
    }
}

