/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.certprofile.xijson.conf;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;

public abstract class Describable
extends ValidableConf {
    private String description;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static class DescribableBinary
    extends Describable {
        private byte[] value;

        public byte[] getValue() {
            return this.value;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public void validate() throws InvalidConfException {
            DescribableBinary.notNull((Object)this.value, (String)"value");
        }
    }

    public static class DescribableInt
    extends Describable {
        private int value;

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public void validate() throws InvalidConfException {
        }
    }

    public static class DescribableOid
    extends Describable {
        private String oid;

        public String getOid() {
            return this.oid;
        }

        public void setOid(String oid) {
            this.oid = oid;
        }

        public ASN1ObjectIdentifier toXiOid() {
            return new ASN1ObjectIdentifier(this.oid);
        }

        public void validate() throws InvalidConfException {
            DescribableOid.notBlank((String)this.oid, (String)"oid");
            try {
                this.toXiOid();
            }
            catch (Exception ex) {
                throw new InvalidConfException("invalid oid " + this.oid);
            }
        }
    }
}

