/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.certprofile.xijson.conf;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.CertPolicyId;
import org.xipki.ca.certprofile.xijson.conf.Describable;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;

public class PolicyMappings
extends ValidableConf {
    private List<PolicyIdMappingType> mappings;

    public List<PolicyIdMappingType> getMappings() {
        if (this.mappings == null) {
            this.mappings = new LinkedList<PolicyIdMappingType>();
        }
        return this.mappings;
    }

    public void setMappings(List<PolicyIdMappingType> mappings) {
        this.mappings = mappings;
    }

    public void validate() throws InvalidConfException {
        PolicyMappings.notEmpty(this.mappings, (String)"mappings");
        PolicyMappings.validate(this.mappings, (Collection[])new Collection[0]);
    }

    public org.bouncycastle.asn1.x509.PolicyMappings toXiPolicyMappings() {
        List<PolicyIdMappingType> mappings = this.getMappings();
        int n = mappings.size();
        CertPolicyId[] issuerDomainPolicy = new CertPolicyId[n];
        CertPolicyId[] subjectDomainPolicy = new CertPolicyId[n];
        for (int i = 0; i < n; ++i) {
            PolicyIdMappingType mapping = mappings.get(i);
            issuerDomainPolicy[i] = CertPolicyId.getInstance((Object)new ASN1ObjectIdentifier(mapping.getIssuerDomainPolicy().getOid()));
            subjectDomainPolicy[i] = CertPolicyId.getInstance((Object)new ASN1ObjectIdentifier(mapping.getSubjectDomainPolicy().getOid()));
        }
        return new org.bouncycastle.asn1.x509.PolicyMappings(issuerDomainPolicy, subjectDomainPolicy);
    }

    public static class PolicyIdMappingType
    extends ValidableConf {
        private Describable.DescribableOid issuerDomainPolicy;
        private Describable.DescribableOid subjectDomainPolicy;

        public Describable.DescribableOid getIssuerDomainPolicy() {
            return this.issuerDomainPolicy;
        }

        public void setIssuerDomainPolicy(Describable.DescribableOid issuerDomainPolicy) {
            this.issuerDomainPolicy = issuerDomainPolicy;
        }

        public Describable.DescribableOid getSubjectDomainPolicy() {
            return this.subjectDomainPolicy;
        }

        public void setSubjectDomainPolicy(Describable.DescribableOid subjectDomainPolicy) {
            this.subjectDomainPolicy = subjectDomainPolicy;
        }

        public void validate() throws InvalidConfException {
            PolicyIdMappingType.notNull((Object)((Object)this.issuerDomainPolicy), (String)"issuerDomainPolicy");
            PolicyIdMappingType.notNull((Object)((Object)this.subjectDomainPolicy), (String)"subjectDomainPolicy");
            PolicyIdMappingType.validate((ValidableConf)this.issuerDomainPolicy, (ValidableConf[])new ValidableConf[]{this.subjectDomainPolicy});
        }
    }
}

