/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.certprofile.xijson.conf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.ExtensionValue;
import org.xipki.ca.api.profile.KeyParametersOption;
import org.xipki.ca.api.profile.NotAfterMode;
import org.xipki.ca.certprofile.xijson.conf.AlgorithmType;
import org.xipki.ca.certprofile.xijson.conf.Describable;
import org.xipki.ca.certprofile.xijson.conf.ExtensionType;
import org.xipki.ca.certprofile.xijson.conf.KeypairGenerationType;
import org.xipki.ca.certprofile.xijson.conf.Subject;
import org.xipki.ca.certprofile.xijson.conf.SubjectToSubjectAltNameType;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.JSON;
import org.xipki.util.TripleState;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;

public class X509ProfileType
extends ValidableConf {
    private static final Logger LOG = LoggerFactory.getLogger(X509ProfileType.class);
    private Map<String, String> metadata;
    private Certprofile.X509CertVersion version;
    private Certprofile.CertLevel certLevel;
    private Certprofile.CertDomain certDomain = Certprofile.CertDomain.RFC5280;
    private Integer maxSize;
    private String validity;
    private NotAfterMode notAfterMode;
    private String notBeforeTime;
    private KeypairGenerationType keypairGeneration;
    private String serialNumberMode;
    private List<String> signatureAlgorithms;
    private List<AlgorithmType> keyAlgorithms;
    private Subject subject;
    private List<SubjectToSubjectAltNameType> subjectToSubjectAltNames;
    private List<ExtensionType> extensions;

    public static X509ProfileType parse(byte[] confBytes) throws CertprofileException {
        Args.notNull((Object)confBytes, (String)"confBytes");
        try {
            X509ProfileType root = (X509ProfileType)((Object)JSON.parseObject((byte[])confBytes, X509ProfileType.class));
            root.validate();
            return root;
        }
        catch (RuntimeException | InvalidConfException ex) {
            throw new CertprofileException("parse profile failed, message: " + ex.getMessage(), ex);
        }
    }

    public static X509ProfileType parse(File confFile) throws CertprofileException {
        Args.notNull((Object)confFile, (String)"confFile");
        try {
            X509ProfileType root = (X509ProfileType)((Object)JSON.parseObject((File)confFile, X509ProfileType.class));
            root.validate();
            return root;
        }
        catch (IOException | RuntimeException | InvalidConfException ex) {
            throw new CertprofileException("parse profile failed, message: " + ex.getMessage(), ex);
        }
    }

    private static X509ProfileType parseAndClose(InputStream confStream) throws CertprofileException {
        try {
            X509ProfileType root = (X509ProfileType)((Object)JSON.parseObjectAndClose((InputStream)confStream, X509ProfileType.class));
            root.validate();
            return root;
        }
        catch (IOException | RuntimeException | InvalidConfException ex) {
            throw new CertprofileException("parse profile failed, message: " + ex.getMessage(), ex);
        }
    }

    public Certprofile.X509CertVersion getVersion() {
        return this.version;
    }

    public void setVersion(Certprofile.X509CertVersion version) {
        this.version = version;
    }

    @Deprecated
    private void setSerialNumberInReq(boolean serialNumberInReq) {
        if (serialNumberInReq) {
            LOG.warn("ignore setSerialNumberInReq with serialNumberInReq=true");
        }
    }

    public List<String> getSignatureAlgorithms() {
        if (this.signatureAlgorithms == null) {
            this.signatureAlgorithms = new LinkedList<String>();
        }
        return this.signatureAlgorithms;
    }

    public void setSignatureAlgorithms(List<String> signatureAlgorithms) {
        this.signatureAlgorithms = signatureAlgorithms;
    }

    public Certprofile.CertLevel getCertLevel() {
        return this.certLevel;
    }

    public void setCertLevel(Certprofile.CertLevel certLevel) {
        this.certLevel = certLevel;
    }

    public Certprofile.CertDomain getCertDomain() {
        return this.certDomain;
    }

    public void setCertDomain(Certprofile.CertDomain certDomain) {
        this.certDomain = certDomain;
    }

    public Map<String, String> getMetadata() {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getValidity() {
        return this.validity;
    }

    public void setValidity(String validity) {
        this.validity = validity;
    }

    public NotAfterMode getNotAfterMode() {
        return this.notAfterMode;
    }

    public void setNotAfterMode(NotAfterMode notAfterMode) {
        this.notAfterMode = notAfterMode;
    }

    public String getNotBeforeTime() {
        return this.notBeforeTime;
    }

    public void setNotBeforeTime(String notBeforeTime) {
        this.notBeforeTime = notBeforeTime;
    }

    public KeypairGenerationType getKeypairGeneration() {
        return this.keypairGeneration;
    }

    public void setKeypairGeneration(KeypairGenerationType keypairGeneration) {
        this.keypairGeneration = keypairGeneration;
    }

    public String getSerialNumberMode() {
        return this.serialNumberMode;
    }

    public void setSerialNumberMode(String serialNumberMode) {
        this.serialNumberMode = serialNumberMode;
    }

    public List<AlgorithmType> getKeyAlgorithms() {
        if (this.keyAlgorithms == null) {
            this.keyAlgorithms = new LinkedList<AlgorithmType>();
        }
        return this.keyAlgorithms;
    }

    public void setKeyAlgorithms(List<AlgorithmType> keyAlgorithms) {
        this.keyAlgorithms = keyAlgorithms;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public List<SubjectToSubjectAltNameType> getSubjectToSubjectAltNames() {
        if (this.subjectToSubjectAltNames == null) {
            this.subjectToSubjectAltNames = new LinkedList<SubjectToSubjectAltNameType>();
        }
        return this.subjectToSubjectAltNames;
    }

    public void setSubjectToSubjectAltNames(List<SubjectToSubjectAltNameType> subjectToSubjectAltNames) {
        this.subjectToSubjectAltNames = subjectToSubjectAltNames;
    }

    public List<ExtensionType> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new LinkedList<ExtensionType>();
        }
        return this.extensions;
    }

    public void setExtensions(List<ExtensionType> extensions) {
        this.extensions = extensions;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public Map<String, ExtensionType> buildExtensions() {
        HashMap<String, ExtensionType> ret = new HashMap<String, ExtensionType>();
        for (ExtensionType m : this.getExtensions()) {
            String type = m.getType().getOid();
            ret.put(type, m);
        }
        return ret;
    }

    public Map<ASN1ObjectIdentifier, KeyParametersOption> toXiKeyAlgorithms() throws CertprofileException {
        HashMap<ASN1ObjectIdentifier, KeyParametersOption.AllowAllParametersOption> keyAlgorithms = new HashMap<ASN1ObjectIdentifier, KeyParametersOption.AllowAllParametersOption>();
        for (AlgorithmType type : this.keyAlgorithms) {
            List<Describable.DescribableOid> algIds = type.getAlgorithms();
            ArrayList<ASN1ObjectIdentifier> oids = new ArrayList<ASN1ObjectIdentifier>(algIds.size());
            for (Describable.DescribableOid algId : algIds) {
                ASN1ObjectIdentifier oid = algId.toXiOid();
                if (keyAlgorithms.containsKey(oid)) {
                    throw new CertprofileException("duplicate definition of keyAlgorithm " + oid.getId());
                }
                oids.add(oid);
            }
            KeyParametersOption.AllowAllParametersOption keyParamsOption = type.getParameters() == null ? KeyParametersOption.ALLOW_ALL : type.getParameters().toXiKeyParametersOption();
            for (ASN1ObjectIdentifier oid : oids) {
                keyAlgorithms.put(oid, keyParamsOption);
            }
        }
        return CollectionUtil.unmodifiableMap(keyAlgorithms);
    }

    public void validate() throws InvalidConfException {
        X509ProfileType.notNull((Object)this.version, (String)"version");
        X509ProfileType.notNull((Object)this.certLevel, (String)"certLevel");
        X509ProfileType.notBlank((String)this.validity, (String)"validity");
        X509ProfileType.notBlank((String)this.notBeforeTime, (String)"notBeforeTime");
        X509ProfileType.notNull((Object)((Object)this.subject), (String)"subject");
        X509ProfileType.notNull(this.extensions, (String)"extensions");
        X509ProfileType.validate((ValidableConf)this.keypairGeneration, (ValidableConf[])new ValidableConf[]{this.subject});
        X509ProfileType.validate(this.keyAlgorithms, (Collection[])new Collection[]{this.subjectToSubjectAltNames, this.extensions});
        HashSet<String> extnTypes = new HashSet<String>();
        for (ExtensionType m : this.extensions) {
            String type = m.getType().getOid();
            if (extnTypes.add(type)) continue;
            throw new InvalidConfException("duplicated definition of extension " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)m.getType().toXiOid()));
        }
    }

    public Map<ASN1ObjectIdentifier, ExtensionValue> buildConstantExtesions() throws CertprofileException {
        HashMap<ASN1ObjectIdentifier, ExtensionValue> map = new HashMap<ASN1ObjectIdentifier, ExtensionValue>();
        for (ExtensionType m : this.getExtensions()) {
            ASN1Encodable value;
            ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(m.getType().getOid());
            if (Extension.subjectAlternativeName.equals((ASN1Primitive)oid) || Extension.subjectInfoAccess.equals((ASN1Primitive)oid) || Extension.biometricInfo.equals((ASN1Primitive)oid) || m.getConstant() == null) continue;
            try {
                value = m.getConstant().toASN1Encodable();
            }
            catch (InvalidConfException ex) {
                throw new CertprofileException(ex.getMessage(), (Throwable)ex);
            }
            ExtensionValue extension = new ExtensionValue(m.critical(), value);
            map.put(oid, extension);
        }
        if (CollectionUtil.isEmpty(map)) {
            return null;
        }
        return Collections.unmodifiableMap(map);
    }

    public Map<ASN1ObjectIdentifier, Certprofile.ExtensionControl> buildExtensionControls() throws CertprofileException {
        HashMap<ASN1ObjectIdentifier, Certprofile.ExtensionControl> controls = new HashMap<ASN1ObjectIdentifier, Certprofile.ExtensionControl>();
        for (ExtensionType extn : this.getExtensions()) {
            ASN1ObjectIdentifier oid = extn.getType().toXiOid();
            if (controls.containsKey(oid)) {
                throw new CertprofileException("duplicated definition of extension " + oid.getId());
            }
            TripleState inReq = extn.getInRequest();
            if (inReq == null) {
                inReq = TripleState.forbidden;
            }
            if (inReq != TripleState.forbidden && extn.getConstant() != null) {
                throw new CertprofileException("constant Extension is not permitted in request");
            }
            controls.put(oid, new Certprofile.ExtensionControl(extn.critical(), extn.required(), inReq));
        }
        return Collections.unmodifiableMap(controls);
    }

    public static Set<ASN1ObjectIdentifier> toOidSet(List<Describable.DescribableOid> oidWithDescTypes) {
        if (CollectionUtil.isEmpty(oidWithDescTypes)) {
            return null;
        }
        HashSet<ASN1ObjectIdentifier> oids = new HashSet<ASN1ObjectIdentifier>();
        for (Describable.DescribableOid type : oidWithDescTypes) {
            oids.add(type.toXiOid());
        }
        return Collections.unmodifiableSet(oids);
    }
}

