/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.xipki.pkcs11.wrapper.StaticLogger;

public class ConcurrentBag<T>
implements AutoCloseable {
    private final CopyOnWriteArrayList<BagEntry<T>> sharedList;
    private final boolean weakThreadLocals = this.useWeakThreadLocals();
    private final ThreadLocal<List<Object>> threadList;
    private final AtomicInteger waiters;
    private volatile boolean closed;
    private final SynchronousQueue<BagEntry<T>> handoffQueue = new SynchronousQueue(true);
    private static final int STATE_NOT_IN_USE = 0;
    private static final int STATE_IN_USE = 1;
    private static final int STATE_REMOVED = -1;
    private static final int STATE_RESERVED = -2;

    public ConcurrentBag() {
        this.waiters = new AtomicInteger();
        this.sharedList = new CopyOnWriteArrayList();
        this.threadList = this.weakThreadLocals ? ThreadLocal.withInitial(() -> new ArrayList(16)) : ThreadLocal.withInitial(() -> new FastList(BagEntry.class, 16));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BagEntry<T> borrow(long timeout, TimeUnit timeUnit) throws InterruptedException {
        BagEntry<T> bagEntry;
        List<Object> list = this.threadList.get();
        for (int i = list.size() - 1; i >= 0; --i) {
            Object entry = list.remove(i);
            BagEntry<T> bagEntry2 = bagEntry = this.weakThreadLocals ? (BagEntry)((WeakReference)entry).get() : (BagEntry<T>)entry;
            if (bagEntry == null || !bagEntry.compareAndSet(0, 1)) continue;
            return bagEntry;
        }
        try {
            long start;
            for (BagEntry<T> bagEntry3 : this.sharedList) {
                if (!bagEntry3.compareAndSet(0, 1)) continue;
                bagEntry = bagEntry3;
                return bagEntry;
            }
            timeout = timeUnit.toNanos(timeout);
            do {
                start = System.nanoTime();
                bagEntry = this.handoffQueue.poll(timeout, TimeUnit.NANOSECONDS);
                if (bagEntry != null && !bagEntry.compareAndSet(0, 1)) continue;
                BagEntry<T> bagEntry4 = bagEntry;
                return bagEntry4;
            } while ((timeout -= System.nanoTime() - start) > 10000L);
            BagEntry<T> bagEntry5 = null;
            return bagEntry5;
        }
        finally {
            this.waiters.decrementAndGet();
        }
    }

    public void requite(BagEntry<T> bagEntry) {
        bagEntry.setState(0);
        int i = 0;
        while (this.waiters.get() > 0) {
            if (bagEntry.getState() != 0 || this.handoffQueue.offer(bagEntry)) {
                return;
            }
            if ((i & 0xFF) == 255) {
                LockSupport.parkNanos(TimeUnit.MICROSECONDS.toNanos(10L));
            } else {
                Thread.yield();
            }
            ++i;
        }
        List<Object> threadLocalList = this.threadList.get();
        if (threadLocalList.size() < 50) {
            threadLocalList.add(this.weakThreadLocals ? new WeakReference<BagEntry<T>>(bagEntry) : bagEntry);
        }
    }

    public void add(BagEntry<T> bagEntry) {
        if (this.closed) {
            StaticLogger.info("ConcurrentBag has been closed, ignoring add()", new Object[0]);
            throw new IllegalStateException("ConcurrentBag has been closed, ignoring add()");
        }
        this.sharedList.add(bagEntry);
        while (this.waiters.get() > 0 && bagEntry.getState() == 0 && !this.handoffQueue.offer(bagEntry)) {
            Thread.yield();
        }
    }

    public boolean remove(BagEntry<T> bagEntry) {
        if (!(bagEntry.compareAndSet(1, -1) || bagEntry.compareAndSet(-2, -1) || this.closed)) {
            StaticLogger.warn("Attempt to remove an object from the bag that was not borrowed or reserved: {}", bagEntry);
            return false;
        }
        boolean removed = this.sharedList.remove(bagEntry);
        if (!removed && !this.closed) {
            StaticLogger.warn("Attempt to remove an object from the bag that does not exist: {}", bagEntry);
        }
        this.threadList.get().remove(bagEntry);
        return removed;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public List<BagEntry<T>> values() {
        return (List)this.sharedList.clone();
    }

    public int size() {
        return this.sharedList.size();
    }

    private boolean useWeakThreadLocals() {
        try {
            return this.getClass().getClassLoader() != ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException se) {
            return true;
        }
    }

    private static final class FastList<T>
    implements List<T>,
    RandomAccess {
        private final Class<?> clazz;
        private T[] elementData;
        private int size;

        public FastList(Class<?> clazz, int capacity) {
            this.elementData = (Object[])Array.newInstance(clazz, capacity);
            this.clazz = clazz;
        }

        @Override
        public boolean add(T element) {
            if (this.size < this.elementData.length) {
                this.elementData[this.size++] = element;
            } else {
                int oldCapacity = this.elementData.length;
                int newCapacity = oldCapacity << 1;
                Object[] newElementData = (Object[])Array.newInstance(this.clazz, newCapacity);
                System.arraycopy(this.elementData, 0, newElementData, 0, oldCapacity);
                newElementData[this.size++] = element;
                this.elementData = newElementData;
            }
            return true;
        }

        @Override
        public T get(int index) {
            return this.elementData[index];
        }

        @Override
        public boolean remove(Object element) {
            for (int index = this.size - 1; index >= 0; --index) {
                if (element != this.elementData[index]) continue;
                int numMoved = this.size - index - 1;
                if (numMoved > 0) {
                    System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
                }
                this.elementData[--this.size] = null;
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            for (int i = 0; i < this.size; ++i) {
                this.elementData[i] = null;
            }
            this.size = 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public T set(int index, T element) {
            T old = this.elementData[index];
            this.elementData[index] = element;
            return old;
        }

        @Override
        public T remove(int index) {
            if (this.size == 0) {
                return null;
            }
            T old = this.elementData[index];
            int numMoved = this.size - index - 1;
            if (numMoved > 0) {
                System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
            }
            this.elementData[--this.size] = null;
            return old;
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int index;

                @Override
                public boolean hasNext() {
                    return this.index < size;
                }

                @Override
                public T next() {
                    if (this.index < size) {
                        return elementData[this.index++];
                    }
                    throw new NoSuchElementException("No more elements in FastList");
                }
            };
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <E> E[] toArray(E[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lastIndexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<T> listIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Spliterator<T> spliterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super T> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<T> operator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super T> c) {
            throw new UnsupportedOperationException();
        }
    }

    public static class BagEntry<T> {
        private volatile int state = 0;
        private static final AtomicIntegerFieldUpdater<BagEntry> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(BagEntry.class, "state");
        private final T value;

        public BagEntry(T value) {
            this.value = value;
        }

        public T value() {
            return this.value;
        }

        public int getState() {
            return stateUpdater.get(this);
        }

        public boolean compareAndSet(int expect, int update) {
            return stateUpdater.compareAndSet(this, expect, update);
        }

        public void setState(int update) {
            stateUpdater.set(this, update);
        }
    }
}

