/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.TokenException;

public class PKCS11Exception
extends TokenException {
    private final long errorCode;
    private final String errorName;

    public PKCS11Exception(long errorCode) {
        this(errorCode, PKCS11Constants.ckrCodeToName(errorCode));
    }

    public PKCS11Exception(long errorCode, String name) {
        super(name);
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must not be null or blank.");
        }
        this.errorName = name;
        this.errorCode = errorCode;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public String getErrorName() {
        return this.errorName;
    }
}

