/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xipki.audit.Audits;
import org.xipki.ca.api.mgmt.CaJson;
import org.xipki.datasource.DataSourceConf;
import org.xipki.security.Securities;
import org.xipki.security.util.TlsHelper;
import org.xipki.util.Args;
import org.xipki.util.FileOrBinary;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.exception.ObjectCreationException;
import org.xipki.util.http.SslContextConf;

public class CaServerConf
extends ValidableConf {
    private Audits.AuditConf audit;
    private Securities.SecurityConf security;
    private RemoteMgmt remoteMgmt;
    private boolean master = true;
    private boolean noLock = false;
    private boolean noRA = false;
    private int shardId = 0;
    private boolean logReqResp;
    private String reverseProxyMode;
    private List<DataSourceConf> datasources;
    private List<SslContext> sslContexts;
    private CtLogConf ctLog;
    private List<String> certprofileFactories;
    private List<String> keypairGeneratorFactories;
    private List<String> caConfFiles;
    private final Map<String, SslContextConf> sslContextConfMap = new HashMap<String, SslContextConf>();

    public static CaServerConf readConfFromFile(String fileName) throws IOException, InvalidConfException {
        Args.notBlank((String)fileName, (String)"fileName");
        CaServerConf conf = (CaServerConf)((Object)CaJson.parseObject((File)new File(fileName), CaServerConf.class));
        conf.validate();
        return conf;
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public boolean isNoLock() {
        return this.noLock;
    }

    public void setNoLock(boolean noLock) {
        this.noLock = noLock;
    }

    public boolean isNoRA() {
        return this.noRA;
    }

    public void setNoRA(boolean noRA) {
        this.noRA = noRA;
    }

    public boolean isLogReqResp() {
        return this.logReqResp;
    }

    public void setLogReqResp(boolean logReqResp) {
        this.logReqResp = logReqResp;
    }

    public String getReverseProxyMode() {
        return this.reverseProxyMode;
    }

    public void setReverseProxyMode(String reverseProxyMode) {
        this.reverseProxyMode = reverseProxyMode;
    }

    public int getShardId() {
        return this.shardId;
    }

    public void setShardId(int shardId) {
        this.shardId = shardId;
    }

    public List<String> getCaConfFiles() {
        return this.caConfFiles;
    }

    public void setCaConfFiles(List<String> caConfFiles) {
        this.caConfFiles = caConfFiles;
    }

    public List<DataSourceConf> getDatasources() {
        return this.datasources;
    }

    public void setDatasources(List<DataSourceConf> datasources) {
        this.datasources = datasources;
    }

    public List<SslContext> getSslContexts() {
        return this.sslContexts;
    }

    public void setSslContexts(List<SslContext> sslContexts) {
        this.sslContexts = sslContexts;
    }

    public SslContext getSslContext(String name) {
        if (this.sslContexts == null) {
            return null;
        }
        for (SslContext m : this.sslContexts) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public Audits.AuditConf getAudit() {
        return this.audit == null ? Audits.AuditConf.DEFAULT : this.audit;
    }

    public void setAudit(Audits.AuditConf audit) {
        this.audit = audit;
    }

    public Securities.SecurityConf getSecurity() {
        return this.security == null ? Securities.SecurityConf.DEFAULT : this.security;
    }

    public void setSecurity(Securities.SecurityConf security) {
        this.security = security;
    }

    public RemoteMgmt getRemoteMgmt() {
        return this.remoteMgmt;
    }

    public void setRemoteMgmt(RemoteMgmt remoteMgmt) {
        this.remoteMgmt = remoteMgmt;
    }

    public List<String> getCertprofileFactories() {
        return this.certprofileFactories;
    }

    public void setCertprofileFactories(List<String> certprofileFactories) {
        this.certprofileFactories = certprofileFactories;
    }

    public List<String> getKeypairGeneratorFactories() {
        return this.keypairGeneratorFactories;
    }

    public void setKeypairGeneratorFactories(List<String> keypairGeneratorFactories) {
        this.keypairGeneratorFactories = keypairGeneratorFactories;
    }

    public CtLogConf getCtLog() {
        return this.ctLog;
    }

    public void setCtLog(CtLogConf ctLog) {
        this.ctLog = ctLog;
    }

    public void initSsl() {
        if (this.sslContexts == null || this.sslContexts.isEmpty()) {
            return;
        }
        if (this.sslContextConfMap.isEmpty()) {
            for (SslContext m : this.sslContexts) {
                SslContextConf conf = new SslContextConf(m.trustanchors, m.getHostverifier());
                try {
                    conf.init();
                }
                catch (ObjectCreationException e) {
                    throw new RuntimeException(e);
                }
                this.sslContextConfMap.put(m.getName(), conf);
            }
        }
    }

    public SslContextConf getSslContextConf(String name) {
        return this.sslContextConfMap.get(name);
    }

    public void validate() throws InvalidConfException {
        if (this.shardId < 0 || this.shardId > 127) {
            throw new InvalidConfException("shardId is not in [0, 127]");
        }
        boolean withCaconfDb = false;
        for (DataSourceConf dsConf : this.datasources) {
            if (!"caconf".equals(dsConf.getName())) continue;
            withCaconfDb = true;
            break;
        }
        if (this.caConfFiles == null) {
            if (!withCaconfDb) {
                throw new InvalidConfException("datasource 'caconf' is required but is not configured.");
            }
        } else if (withCaconfDb) {
            throw new InvalidConfException("datasource 'caconf' is not allowed but is configured.");
        }
        CaServerConf.validate((ValidableConf)this.remoteMgmt, (ValidableConf[])new ValidableConf[]{this.security});
        TlsHelper.checkReverseProxyMode((String)this.reverseProxyMode);
    }

    public static class CtLogConf {
        private String keydir;

        public String getKeydir() {
            return this.keydir;
        }

        public void setKeydir(String keydir) {
            this.keydir = keydir;
        }
    }

    public static class RemoteMgmt
    extends ValidableConf {
        private boolean enabled;
        private List<FileOrBinary> certs;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public List<FileOrBinary> getCerts() {
            return this.certs;
        }

        public void setCerts(List<FileOrBinary> certs) {
            this.certs = certs;
        }

        public void validate() {
        }
    }

    public static class SslContext
    extends ValidableConf {
        private String name;
        private FileOrBinary[] trustanchors;
        private String hostverifier;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public FileOrBinary[] getTrustanchors() {
            return this.trustanchors;
        }

        public void setTrustanchors(FileOrBinary[] trustanchors) {
            this.trustanchors = trustanchors;
        }

        public String getHostverifier() {
            return this.hostverifier;
        }

        public void setHostverifier(String hostverifier) {
            this.hostverifier = hostverifier;
        }

        public void validate() throws InvalidConfException {
            SslContext.notBlank((String)this.name, (String)"name");
        }
    }
}

