/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.io.IOException;
import java.math.BigInteger;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.RequestorInfo;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.sdk.CaIdentifierRequest;
import org.xipki.ca.sdk.CaNameResponse;
import org.xipki.ca.sdk.CertChainResponse;
import org.xipki.ca.sdk.CertprofileInfoRequest;
import org.xipki.ca.sdk.CertsMode;
import org.xipki.ca.sdk.ConfirmCertRequestEntry;
import org.xipki.ca.sdk.ConfirmCertsRequest;
import org.xipki.ca.sdk.CrlResponse;
import org.xipki.ca.sdk.EnrollCertRequestEntry;
import org.xipki.ca.sdk.EnrollCertsRequest;
import org.xipki.ca.sdk.EnrollOrPollCertsResponse;
import org.xipki.ca.sdk.EnrollOrPullCertResponseEntry;
import org.xipki.ca.sdk.ErrorEntry;
import org.xipki.ca.sdk.ErrorResponse;
import org.xipki.ca.sdk.GenCRLRequest;
import org.xipki.ca.sdk.GetCRLRequest;
import org.xipki.ca.sdk.GetCertRequest;
import org.xipki.ca.sdk.OldCertInfoByIssuerAndSerial;
import org.xipki.ca.sdk.OldCertInfoBySubject;
import org.xipki.ca.sdk.PayloadResponse;
import org.xipki.ca.sdk.PollCertRequest;
import org.xipki.ca.sdk.PollCertRequestEntry;
import org.xipki.ca.sdk.RevokeCertRequestEntry;
import org.xipki.ca.sdk.RevokeCertsRequest;
import org.xipki.ca.sdk.RevokeCertsResponse;
import org.xipki.ca.sdk.SdkResponse;
import org.xipki.ca.sdk.SingleCertSerialEntry;
import org.xipki.ca.sdk.TransactionIdRequest;
import org.xipki.ca.sdk.UnSuspendOrRemoveCertsResponse;
import org.xipki.ca.sdk.UnsuspendOrRemoveRequest;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.ca.server.CertTemplateData;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.ca.server.PendingCertificatePool;
import org.xipki.ca.server.X509Ca;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.pki.ErrorCode;
import org.xipki.pki.OperationException;
import org.xipki.security.CrlReason;
import org.xipki.security.X509Cert;
import org.xipki.security.util.TlsHelper;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.Hex;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.InsufficientPermissionException;
import org.xipki.util.http.XiHttpRequest;

public class SdkResponder {
    private static final int DFLT_CONFIRM_WAIT_TIME_MS = 600000;
    private final PendingCertificatePool pendingCertPool;
    private static final Logger LOG = LoggerFactory.getLogger(SdkResponder.class);
    private static final Set<String> reenrollCertExtnIds = CollectionUtil.asUnmodifiableSet((Object[])new String[]{Extension.biometricInfo.getId(), Extension.extendedKeyUsage.getId(), Extension.keyUsage.getId(), Extension.qCStatements.getId(), Extension.subjectAlternativeName.getId(), Extension.subjectInfoAccess.getId()});
    private final String reverseProxyMode;
    private final CaManagerImpl caManager;
    private ScheduledThreadPoolExecutor threadPoolExecutor;

    public SdkResponder(String reverseProxyMode, CaManagerImpl caManager) {
        this.reverseProxyMode = reverseProxyMode;
        this.caManager = (CaManagerImpl)Args.notNull((Object)caManager, (String)"caManager");
        this.pendingCertPool = new PendingCertificatePool();
        this.threadPoolExecutor = new ScheduledThreadPoolExecutor(1);
        this.threadPoolExecutor.setRemoveOnCancelPolicy(true);
        this.threadPoolExecutor.scheduleAtFixedRate(new PendingPoolCleaner(), 10L, 10L, TimeUnit.MINUTES);
    }

    public SdkResponse service(String path, byte[] request, XiHttpRequest httpRequest) {
        try {
            TlsHelper.getTlsClientCert((XiHttpRequest)httpRequest, (String)this.reverseProxyMode);
            SdkResponse resp = this.service0(path, request, httpRequest);
            if (resp instanceof ErrorResponse) {
                LOG.warn("returned ErrorResponse: {}", (Object)resp);
            }
            return resp;
        }
        catch (Throwable th) {
            LOG.error("Throwable thrown, this should not happen!", th);
            return new ErrorResponse(null, ErrorCode.SYSTEM_FAILURE, "internal error");
        }
    }

    private SdkResponse service0(String path, byte[] request, XiHttpRequest httpRequest) {
        try {
            X509Cert clientCert;
            X509Ca ca;
            if (this.caManager == null) {
                return new ErrorResponse(null, ErrorCode.SYSTEM_FAILURE, "responderManager in servlet not configured");
            }
            String caName = null;
            String command = null;
            if (path.length() > 1) {
                String coreUri = path;
                int sepIndex = coreUri.indexOf(47, 1);
                if (sepIndex == -1 || sepIndex == coreUri.length() - 1) {
                    return new ErrorResponse(null, ErrorCode.PATH_NOT_FOUND, "invalid path " + path);
                }
                String caAlias = coreUri.substring(1, sepIndex).toLowerCase();
                command = coreUri.substring(sepIndex + 1).toLowerCase();
                if ("-".equals(caAlias)) {
                    caName = "-";
                } else {
                    caName = this.caManager.getCaNameForAlias(caAlias);
                    if (caName == null) {
                        caName = caAlias;
                    }
                }
            }
            if (StringUtil.isBlank(command)) {
                return new ErrorResponse(null, ErrorCode.PATH_NOT_FOUND, "command is not specified");
            }
            CaIdentifierRequest req = null;
            if (!"-".equals(caName)) {
                try {
                    ca = this.caManager.getX509Ca(caName);
                }
                catch (CaMgmtException e) {
                    return new ErrorResponse(null, ErrorCode.PATH_NOT_FOUND, "CA unknown");
                }
                if (ca == null) {
                    return new ErrorResponse(null, ErrorCode.PATH_NOT_FOUND, "unknown CA '" + caName + "'");
                }
            } else {
                switch (command) {
                    case "caname": 
                    case "cacert2": 
                    case "cacerts2": {
                        req = CaIdentifierRequest.decode((byte[])SdkResponder.requireNonNullRequest(request));
                        break;
                    }
                    case "poll_cert": 
                    case "remove_cert": 
                    case "revoke_cert": 
                    case "unsuspend_cert": {
                        if ("poll_cert".equals(command)) {
                            req = PollCertRequest.decode((byte[])SdkResponder.requireNonNullRequest(request));
                            break;
                        }
                        if ("revoke_cert".equals(command)) {
                            req = RevokeCertsRequest.decode((byte[])SdkResponder.requireNonNullRequest(request));
                            break;
                        }
                        req = UnsuspendOrRemoveRequest.decode((byte[])SdkResponder.requireNonNullRequest(request));
                        break;
                    }
                    default: {
                        return new ErrorResponse(null, ErrorCode.PATH_NOT_FOUND, "invalid command '" + command + "'");
                    }
                }
                ca = this.caManager.getCa(req);
                if (ca == null) {
                    String message = "could not find CA for " + req.idText();
                    return new ErrorResponse(null, ErrorCode.PATH_NOT_FOUND, message);
                }
            }
            if (ca.getCaInfo().getStatus() != CaStatus.active) {
                return new ErrorResponse(null, ErrorCode.PATH_NOT_FOUND, "CA '" + ca.getCaIdent().getName() + "' is out of service");
            }
            try {
                clientCert = TlsHelper.getTlsClientCert((XiHttpRequest)httpRequest, (String)this.reverseProxyMode);
            }
            catch (IOException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error getTlsClientCert");
                return new ErrorResponse(null, ErrorCode.UNAUTHORIZED, "error retrieving client certificate");
            }
            if (clientCert == null) {
                return new ErrorResponse(null, ErrorCode.UNAUTHORIZED, "no client certificate");
            }
            RequestorInfo.CertRequestorInfo requestor = ca.getRequestor(clientCert);
            if (requestor == null) {
                return new ErrorResponse(null, ErrorCode.NOT_PERMITTED, "no requestor specified");
            }
            switch (command) {
                case "health": {
                    return ca.healthy() ? null : new ErrorResponse(null, ErrorCode.SYSTEM_UNAVAILABLE, "CA is not healthy");
                }
                case "cacert": {
                    return this.buildCertChainResponse(ca.getCaInfo().getCert(), null);
                }
                case "cacerts": {
                    return this.buildCertChainResponse(ca.getCaInfo().getCert(), ca.getCaInfo().getCertchain());
                }
                case "enroll": {
                    SdkResponder.assertPermitted((RequestorInfo)requestor, 1);
                    return this.enroll(ca, SdkResponder.requireNonNullRequest(request), (RequestorInfo)requestor, false, false);
                }
                case "reenroll": {
                    SdkResponder.assertPermitted((RequestorInfo)requestor, 16);
                    return this.enroll(ca, SdkResponder.requireNonNullRequest(request), (RequestorInfo)requestor, true, false);
                }
                case "enroll_cross": {
                    SdkResponder.assertPermitted((RequestorInfo)requestor, 128);
                    return this.enroll(ca, SdkResponder.requireNonNullRequest(request), (RequestorInfo)requestor, false, true);
                }
                case "poll_cert": {
                    if (!requestor.isPermitted(1) && !requestor.isPermitted(16)) {
                        throw new OperationException(ErrorCode.NOT_PERMITTED);
                    }
                    return this.poll(ca, (PollCertRequest)req, "-".equals(caName));
                }
                case "revoke_cert": {
                    SdkResponder.assertPermitted((RequestorInfo)requestor, 2);
                    return this.revoke((RequestorInfo)requestor, ca, (RevokeCertsRequest)req, "-".equals(caName));
                }
                case "confirm_enroll": {
                    if (!requestor.isPermitted(1) && !requestor.isPermitted(16)) {
                        throw new OperationException(ErrorCode.NOT_PERMITTED);
                    }
                    return this.confirmCertificates((RequestorInfo)requestor, ca, SdkResponder.requireNonNullRequest(request));
                }
                case "revoke_pending_cert": {
                    if (!requestor.isPermitted(1) && !requestor.isPermitted(16)) {
                        throw new OperationException(ErrorCode.NOT_PERMITTED);
                    }
                    this.revokePendingCertificates((RequestorInfo)requestor, ca, TransactionIdRequest.decode((byte[])SdkResponder.requireNonNullRequest(request)).getTid());
                    return null;
                }
                case "unsuspend_cert": {
                    SdkResponder.assertPermitted((RequestorInfo)requestor, 4);
                    return this.removeOrUnsuspend((RequestorInfo)requestor, ca, (UnsuspendOrRemoveRequest)req, true, "-".equals(caName));
                }
                case "remove_cert": {
                    SdkResponder.assertPermitted((RequestorInfo)requestor, 8);
                    return this.removeOrUnsuspend((RequestorInfo)requestor, ca, (UnsuspendOrRemoveRequest)req, false, "-".equals(caName));
                }
                case "gen_crl": {
                    SdkResponder.assertPermitted((RequestorInfo)requestor, 32);
                    return this.genCrl((RequestorInfo)requestor, ca, SdkResponder.requireNonNullRequest(request));
                }
                case "crl": {
                    return this.getCrl((RequestorInfo)requestor, ca, SdkResponder.requireNonNullRequest(request));
                }
                case "get_cert": {
                    SdkResponder.assertPermitted((RequestorInfo)requestor, 512);
                    return this.getCert(ca, SdkResponder.requireNonNullRequest(request));
                }
                case "profileinfo": {
                    return this.getProfileInfo(SdkResponder.requireNonNullRequest(request));
                }
                case "cacert2": {
                    return this.buildCertChainResponse(ca.getCaCert(), null);
                }
                case "cacerts2": {
                    return this.buildCertChainResponse(ca.getCaCert(), ca.caInfo.getCertchain());
                }
                case "caname": {
                    String name = ca.getCaIdent().getName();
                    Set<String> aliases = this.caManager.getAliasesForCa(name);
                    String[] aliasArray = CollectionUtil.isEmpty(aliases) ? null : aliases.toArray(new String[0]);
                    return new CaNameResponse(name, aliasArray);
                }
            }
            return new ErrorResponse(null, ErrorCode.PATH_NOT_FOUND, "invalid command '" + command + "'");
        }
        catch (DecodeException ex) {
            return new ErrorResponse(null, ErrorCode.BAD_REQUEST, ex.getMessage());
        }
        catch (OperationException ex) {
            return new ErrorResponse(null, ex.getErrorCode(), ex.getErrorMessage());
        }
    }

    private static byte[] requireNonNullRequest(byte[] reqBytes) throws DecodeException {
        return Optional.ofNullable(reqBytes).orElseThrow(() -> new DecodeException("request must no be null"));
    }

    private CertChainResponse buildCertChainResponse(X509Cert cert, List<X509Cert> certchain) {
        int size = 1 + (certchain == null ? 0 : certchain.size());
        byte[][] certs = new byte[size][];
        certs[0] = cert.getEncoded();
        if (size > 1) {
            for (int i = 1; i < size; ++i) {
                certs[i] = certchain.get(i - 1).getEncoded();
            }
        }
        return new CertChainResponse((byte[][])certs);
    }

    private SdkResponse enroll(X509Ca ca, byte[] request, RequestorInfo requestor, boolean reenroll, boolean crossCert) throws OperationException, DecodeException {
        CertsMode caCertMode;
        EnrollOrPullCertResponseEntry[] rentries;
        boolean explicitConform;
        EnrollCertsRequest req = EnrollCertsRequest.decode((byte[])request);
        EnrollCertRequestEntry[] entries = req.getEntries();
        ArrayList<CertTemplateData> certTemplates = new ArrayList<CertTemplateData>(entries.length);
        HashSet<String> profiles = new HashSet<String>();
        for (EnrollCertRequestEntry entry : entries) {
            String profile = entry.getCertprofile();
            Instant notBefore = entry.getNotBefore();
            Instant notAfter = entry.getNotAfter();
            X500Name subject = null;
            Extensions extensions = null;
            SubjectPublicKeyInfo publicKeyInfo = null;
            if (entry.getP10req() != null) {
                CertificationRequestInfo certTemp;
                try {
                    certTemp = CertificationRequest.getInstance((Object)X509Util.toDerEncoded((byte[])entry.getP10req())).getCertificationRequestInfo();
                }
                catch (Exception ex) {
                    throw new OperationException(ErrorCode.BAD_REQUEST, "invalid CSR: " + ex.getMessage());
                }
                subject = certTemp.getSubject();
                publicKeyInfo = certTemp.getSubjectPublicKeyInfo();
                extensions = X509Util.getExtensions((CertificationRequestInfo)certTemp);
            } else {
                X500NameType subject0 = entry.getSubject();
                if (subject0 == null) {
                    if (!reenroll) {
                        throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "subject is not set");
                    }
                } else {
                    try {
                        subject = subject0.toX500Name();
                    }
                    catch (IOException ex) {
                        throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE);
                    }
                }
                if (entry.getExtensions() != null) {
                    extensions = Extensions.getInstance((Object)entry.getExtensions());
                }
                if (entry.getSubjectPublicKey() != null) {
                    publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)entry.getSubjectPublicKey());
                }
                if (reenroll) {
                    ASN1ObjectIdentifier[] oldOids;
                    CertWithRevocationInfo oldCert;
                    String text;
                    boolean reusePublicKey;
                    OldCertInfoByIssuerAndSerial ocIsn = entry.getOldCertIsn();
                    OldCertInfoBySubject ocSubject = entry.getOldCertSubject();
                    if (ocIsn == null && ocSubject == null) {
                        throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "Neither oldCertIsn nor oldCertSubject is specified in reenroll_cert command, but exactly one of them is permitted");
                    }
                    if (ocIsn != null && ocSubject != null) {
                        throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "Both oldCertIsn and oldCertSubject are specified in reenroll_cert command, but exactly one of them is permitted");
                    }
                    if (ocIsn != null) {
                        reusePublicKey = ocIsn.isReusePublicKey();
                        X500Name issuer = X500Name.getInstance((Object)ocIsn.getIssuer());
                        BigInteger serialNumber = ocIsn.getSerialNumber();
                        text = "certificate with the issuer '" + X509Util.x500NameText((X500Name)issuer) + "' and serial number " + serialNumber;
                        oldCert = ca.getCertWithRevocationInfo(serialNumber);
                    } else {
                        reusePublicKey = ocSubject.isReusePublicKey();
                        X500Name oldSubject = X500Name.getInstance((Object)ocSubject.getSubject());
                        String subjectText = X509Util.x500NameText((X500Name)oldSubject);
                        text = "certificate with subject '" + subjectText + "'";
                        oldCert = ca.getCertWithRevocationInfoBySubject(oldSubject, ocSubject.getSan());
                    }
                    if (oldCert == null) {
                        throw new OperationException(ErrorCode.UNKNOWN_CERT, "found no " + text);
                    }
                    if (oldCert.isRevoked()) {
                        throw new OperationException(ErrorCode.CERT_REVOKED, "could not update a revoked " + text);
                    }
                    if (profile == null) {
                        profile = oldCert.getCertprofile();
                        profiles.add(profile);
                    }
                    if (subject == null) {
                        subject = oldCert.getCert().getCert().getSubject();
                    }
                    if (publicKeyInfo == null && reusePublicKey) {
                        publicKeyInfo = oldCert.getCert().getCert().getSubjectPublicKeyInfo();
                    }
                    HashMap<String, Extension> extns = new HashMap<String, Extension>();
                    if (extensions != null) {
                        ASN1ObjectIdentifier[] oids;
                        for (ASN1ObjectIdentifier oid : oids = extensions.getExtensionOIDs()) {
                            extns.put(oid.getId(), extensions.getExtension(oid));
                        }
                    }
                    Extensions oldExtensions = oldCert.getCert().getCert().toBcCert().getExtensions();
                    for (ASN1ObjectIdentifier oid : oldOids = oldExtensions.getExtensionOIDs()) {
                        String id = oid.getId();
                        if (extns.containsKey(id) || reenrollCertExtnIds.contains(id)) continue;
                        extns.put(id, oldExtensions.getExtension(oid));
                    }
                    extensions = new Extensions(extns.values().toArray(new Extension[0]));
                }
            }
            profiles.add(profile);
            boolean serverkeygen = publicKeyInfo == null;
            CertTemplateData certTemplate = new CertTemplateData(subject, publicKeyInfo, notBefore, notAfter, extensions, profile, entry.getCertReqId(), serverkeygen);
            certTemplate.setForCrossCert(crossCert);
            certTemplates.add(certTemplate);
        }
        for (String profile : profiles) {
            IdentifiedCertprofile idProfile;
            if (!requestor.isCertprofilePermitted(profile)) {
                throw new OperationException(ErrorCode.NOT_PERMITTED, "cert profile " + profile + " is not allowed");
            }
            if (!crossCert || Certprofile.CertLevel.CROSS == (idProfile = Optional.ofNullable(this.caManager.getIdentifiedCertprofile(profile)).orElseThrow(() -> new OperationException(ErrorCode.UNKNOWN_CERT_PROFILE, "unknown cert profile " + profile))).getCertLevel()) continue;
            throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "cert profile " + profile + " is not for CROSS certificate");
        }
        long waitForConfirmUtil = 0L;
        boolean bl = explicitConform = req.getExplicitConfirm() != null && req.getExplicitConfirm() != false;
        if (explicitConform) {
            int confirmWaitTimeMs = req.getConfirmWaitTimeMs() == null ? 600000 : req.getConfirmWaitTimeMs();
            waitForConfirmUtil = Clock.systemUTC().millis() + (long)confirmWaitTimeMs;
        }
        if ((rentries = this.generateCertificates(requestor, ca, certTemplates, req, waitForConfirmUtil)) == null) {
            return new ErrorResponse(req.getTransactionId(), ErrorCode.SYSTEM_FAILURE, null);
        }
        EnrollOrPollCertsResponse resp = new EnrollOrPollCertsResponse();
        resp.setTransactionId(req.getTransactionId());
        resp.setEntries(rentries);
        if (explicitConform) {
            resp.setConfirmWaitTime(Long.valueOf(waitForConfirmUtil));
        }
        if ((caCertMode = req.getCaCertMode()) == CertsMode.CERT) {
            resp.setExtraCerts((byte[][])new byte[][]{ca.getCaCert().getEncoded()});
        } else if (caCertMode == CertsMode.CHAIN) {
            List<X509Cert> chain = ca.getCaInfo().getCertchain();
            if (CollectionUtil.isEmpty(chain)) {
                resp.setExtraCerts((byte[][])new byte[][]{ca.getCaCert().getEncoded()});
            } else {
                resp.setExtraCerts((byte[][])ca.getEncodedCaCertChain().toArray((T[])new byte[0][0]));
            }
        }
        return resp;
    }

    private SdkResponse poll(X509Ca ca, PollCertRequest req, boolean caReqMatchChecked) throws OperationException {
        if (!caReqMatchChecked) {
            this.assertIssuerMatch(ca, (CaIdentifierRequest)req);
        }
        String tid = req.getTransactionId();
        PollCertRequestEntry[] entries = req.getEntries();
        EnrollOrPullCertResponseEntry[] rentries = new EnrollOrPullCertResponseEntry[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            PollCertRequestEntry m = entries[i];
            ErrorEntry error = null;
            X500Name subject = null;
            try {
                subject = m.getSubject().toX500Name();
            }
            catch (IOException e) {
                error = new ErrorEntry(ErrorCode.BAD_REQUEST, "invalid subject");
            }
            byte[] certBytes = null;
            if (error == null) {
                X509Cert cert = ca.getCert(subject, tid);
                if (cert != null) {
                    certBytes = cert.getEncoded();
                } else {
                    error = new ErrorEntry(ErrorCode.UNKNOWN_CERT, null);
                }
            }
            rentries[i] = new EnrollOrPullCertResponseEntry(m.getId(), error, certBytes, null);
        }
        EnrollOrPollCertsResponse resp = new EnrollOrPollCertsResponse();
        resp.setTransactionId(tid);
        resp.setEntries(rentries);
        return resp;
    }

    private SdkResponse revoke(RequestorInfo requestor, X509Ca ca, RevokeCertsRequest req, boolean caReqMatchChecked) throws OperationException {
        if (!caReqMatchChecked) {
            this.assertIssuerMatch(ca, (CaIdentifierRequest)req);
        }
        RevokeCertRequestEntry[] entries = req.getEntries();
        SingleCertSerialEntry[] rentries = new SingleCertSerialEntry[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            RevokeCertRequestEntry entry = entries[i];
            BigInteger serialNumber = entry.getSerialNumber();
            CrlReason reason = entry.getReason();
            ErrorEntry errorEntry = null;
            if (reason == CrlReason.REMOVE_FROM_CRL) {
                String msg = "Reason removeFromCRL is not permitted";
                errorEntry = new ErrorEntry(ErrorCode.BAD_REQUEST, msg);
            } else {
                Instant invalidityTime = entry.getInvalidityTime();
                try {
                    ca.revokeCert(requestor, serialNumber, reason, invalidityTime);
                }
                catch (OperationException e) {
                    errorEntry = new ErrorEntry(e.getErrorCode(), e.getErrorMessage());
                }
            }
            rentries[i] = new SingleCertSerialEntry(serialNumber, errorEntry);
        }
        return new RevokeCertsResponse(rentries);
    }

    private SdkResponse removeOrUnsuspend(RequestorInfo requestor, X509Ca ca, UnsuspendOrRemoveRequest req, boolean unsuspend, boolean caReqMatchChecked) throws OperationException {
        if (!caReqMatchChecked) {
            this.assertIssuerMatch(ca, (CaIdentifierRequest)req);
        }
        BigInteger[] entries = req.getEntries();
        SingleCertSerialEntry[] rentries = new SingleCertSerialEntry[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            BigInteger serialNumber = entries[i];
            ErrorEntry error = null;
            try {
                if (unsuspend) {
                    ca.unsuspendCert(requestor, serialNumber);
                } else {
                    ca.removeCert(requestor, serialNumber);
                }
            }
            catch (OperationException e) {
                error = new ErrorEntry(e.getErrorCode(), e.getErrorMessage());
            }
            rentries[i] = new SingleCertSerialEntry(serialNumber, error);
        }
        return new UnSuspendOrRemoveCertsResponse(rentries);
    }

    private void assertIssuerMatch(X509Ca ca, CaIdentifierRequest req) throws OperationException {
        byte[] caSki;
        X500NameType issuer = req.getIssuer();
        byte[] authorityKeyId = req.getAuthorityKeyIdentifier();
        byte[] issuerCertSha1Fp = req.getIssuerCertSha1Fp();
        if (issuer == null && authorityKeyId == null && issuerCertSha1Fp == null) {
            throw new OperationException(ErrorCode.BAD_REQUEST, "no issuer's identifier is specified");
        }
        if (issuer != null) {
            X500Name x500Issuer;
            try {
                x500Issuer = issuer.toX500Name();
            }
            catch (IOException e) {
                throw new OperationException(ErrorCode.BAD_REQUEST, "error toX500Name");
            }
            X500Name caSubject = ca.getCaCert().getSubject();
            if (!x500Issuer.equals((Object)caSubject)) {
                throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "issuer does not target at the CA");
            }
        }
        if (authorityKeyId != null && !Arrays.equals(caSki = ca.getCaCert().getSubjectKeyId(), authorityKeyId)) {
            throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "AuthorityKeyIdentifier does not target at the CA");
        }
        if (issuerCertSha1Fp != null && !Hex.encode((byte[])issuerCertSha1Fp).equalsIgnoreCase(ca.getHexSha1OfCert())) {
            throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "IssuerCertSha256Fp does not target at the CA");
        }
    }

    private SdkResponse genCrl(RequestorInfo requestor, X509Ca ca, byte[] request) throws OperationException, DecodeException {
        GenCRLRequest req = GenCRLRequest.decode((byte[])request);
        X509CRLHolder crl = ca.generateCrlOnDemand(requestor);
        return SdkResponder.buildCrlResp(crl, "generate CRL");
    }

    private SdkResponse getCrl(RequestorInfo requestor, X509Ca ca, byte[] request) throws OperationException, DecodeException {
        GetCRLRequest req = GetCRLRequest.decode((byte[])request);
        X509CRLHolder crl = ca.getCrl(requestor, req.getCrlNumber());
        return SdkResponder.buildCrlResp(crl, "get CRL");
    }

    private static SdkResponse buildCrlResp(X509CRLHolder crl, String desc) {
        if (crl == null) {
            String message = "could not " + desc;
            LOG.warn(message);
            return new ErrorResponse(null, ErrorCode.SYSTEM_FAILURE, message);
        }
        try {
            return new CrlResponse(crl.getEncoded());
        }
        catch (IOException e) {
            return new ErrorResponse(null, ErrorCode.SYSTEM_FAILURE, "error encoding CRL");
        }
    }

    private SdkResponse getCert(X509Ca ca, byte[] request) throws OperationException, DecodeException {
        X500Name issuer;
        GetCertRequest req = GetCertRequest.decode((byte[])request);
        try {
            issuer = req.getIssuer().toX500Name();
        }
        catch (IOException e) {
            throw new OperationException(ErrorCode.BAD_REQUEST, "error toX500Name");
        }
        if (!issuer.equals((Object)ca.getCaCert().getSubject())) {
            throw new OperationException(ErrorCode.BAD_REQUEST, "unknown issuer");
        }
        BigInteger sn = req.getSerialNumber();
        X509Cert cert = ca.getCert(sn);
        if (cert == null) {
            throw new OperationException(ErrorCode.UNKNOWN_CERT, "unknown certificate");
        }
        return new PayloadResponse(cert.getEncoded());
    }

    private SdkResponse getProfileInfo(byte[] request) throws OperationException, DecodeException {
        CertprofileInfoRequest req = CertprofileInfoRequest.decode((byte[])request);
        String profileName = req.getProfile();
        return this.caManager.getCertprofileInfo(profileName);
    }

    private static void assertPermitted(RequestorInfo requestor, int permission) throws OperationException {
        try {
            requestor.assertPermitted(permission);
        }
        catch (InsufficientPermissionException ex) {
            throw new OperationException(ErrorCode.NOT_PERMITTED, ex.getMessage());
        }
    }

    private EnrollOrPullCertResponseEntry[] generateCertificates(RequestorInfo requestor, X509Ca ca, List<CertTemplateData> certTemplates, EnrollCertsRequest req, long waitForConfirmUtil) {
        String caName = ca.getCaInfo().getIdent().getName();
        int n = certTemplates.size();
        String tid = req.getTransactionId();
        Boolean b = req.getGroupEnroll();
        boolean groupEnroll = b != null && b != false;
        b = req.getExplicitConfirm();
        boolean explicitConfirm = b != null && b != false;
        ArrayList<EnrollOrPullCertResponseEntry> ret = new ArrayList<EnrollOrPullCertResponseEntry>(n);
        if (groupEnroll) {
            List<CertificateInfo> certInfos = null;
            try {
                certInfos = ca.generateCerts(requestor, certTemplates, tid);
                for (int i = 0; i < n; ++i) {
                    CertificateInfo certInfo = certInfos.get(i);
                    BigInteger certReqId = certTemplates.get(i).getCertReqId();
                    if (explicitConfirm) {
                        this.pendingCertPool.addCertificate(tid, certReqId, certInfo, waitForConfirmUtil);
                    }
                    byte[] privateKeyBytes = null;
                    ErrorEntry error = null;
                    if (certInfo.getPrivateKey() != null) {
                        try {
                            privateKeyBytes = certInfo.getPrivateKey().getEncoded();
                        }
                        catch (IOException e) {
                            error = new ErrorEntry(ErrorCode.SYSTEM_FAILURE, "error encoding CRL");
                        }
                    }
                    byte[] certBytes = null;
                    if (error == null) {
                        certBytes = certInfo.getCert().getCert().getEncoded();
                    }
                    ret.add(new EnrollOrPullCertResponseEntry(certReqId, error, certBytes, privateKeyBytes));
                }
                return ret.toArray(new EnrollOrPullCertResponseEntry[0]);
            }
            catch (OperationException ex) {
                if (certInfos != null) {
                    for (CertificateInfo certInfo : certInfos) {
                        BigInteger sn = certInfo.getCert().getCert().getSerialNumber();
                        try {
                            ca.revokeCert(requestor, sn, CrlReason.CESSATION_OF_OPERATION, null);
                        }
                        catch (OperationException ex2) {
                            LogUtil.error((Logger)LOG, (Throwable)ex2, (String)("CA " + caName + " could not revoke certificate " + sn));
                        }
                    }
                }
                return null;
            }
        }
        for (CertTemplateData certTemplate : certTemplates) {
            BigInteger certReqId = certTemplate.getCertReqId();
            byte[] certBytes = null;
            byte[] privateKeyBytes = null;
            ErrorEntry error = null;
            try {
                CertificateInfo certInfo = ca.generateCert(requestor, certTemplate, tid);
                if (explicitConfirm) {
                    this.pendingCertPool.addCertificate(tid, certReqId, certInfo, waitForConfirmUtil);
                }
                if (certInfo.getPrivateKey() != null) {
                    try {
                        privateKeyBytes = certInfo.getPrivateKey().getEncoded();
                    }
                    catch (IOException e) {
                        error = new ErrorEntry(ErrorCode.SYSTEM_FAILURE, "error encoding CRL");
                    }
                }
                if (error == null) {
                    certBytes = certInfo.getCert().getCert().getEncoded();
                }
            }
            catch (OperationException ex) {
                error = new ErrorEntry(ex.getErrorCode(), ex.getErrorMessage());
            }
            ret.add(new EnrollOrPullCertResponseEntry(certReqId, error, certBytes, privateKeyBytes));
        }
        return ret.toArray(new EnrollOrPullCertResponseEntry[0]);
    }

    protected SdkResponse confirmCertificates(RequestorInfo requestor, X509Ca ca, byte[] request) throws DecodeException {
        ConfirmCertsRequest req = ConfirmCertsRequest.decode((byte[])request);
        String tid = req.getTransactionId();
        boolean successful = true;
        for (ConfirmCertRequestEntry m : req.getEntries()) {
            byte[] certHash;
            BigInteger certReqId = m.getCertReqId();
            CertificateInfo certInfo = this.pendingCertPool.removeCertificate(tid, certReqId, certHash = m.getCerthash());
            if (certInfo == null) {
                LOG.warn("no cert under transactionId={}, certReqId={} and certHash=0X{}", new Object[]{tid, certReqId, Hex.encode((byte[])certHash)});
                continue;
            }
            if (m.isAccept()) continue;
            BigInteger serialNumber = certInfo.getCert().getCert().getSerialNumber();
            try {
                ca.revokeCert(requestor, serialNumber, CrlReason.CESSATION_OF_OPERATION, Instant.now());
            }
            catch (OperationException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("could not revoke certificate ca=" + ca.getCaInfo().getIdent() + " serialNumber=" + LogUtil.formatCsn((BigInteger)serialNumber)));
            }
            successful = false;
        }
        if (!this.revokePendingCertificates(requestor, ca, tid)) {
            successful = false;
        }
        if (successful) {
            return null;
        }
        return new ErrorResponse(tid, ErrorCode.SYSTEM_FAILURE, null);
    }

    public boolean revokePendingCertificates(RequestorInfo requestor, X509Ca ca, String transactionId) {
        Set<CertificateInfo> remainingCerts = this.pendingCertPool.removeCertificates(transactionId);
        if (CollectionUtil.isEmpty(remainingCerts)) {
            return true;
        }
        boolean successful = true;
        Instant invalidityDate = Instant.now();
        for (CertificateInfo remainingCert : remainingCerts) {
            try {
                ca.revokeCert(requestor, remainingCert.getCert().getCert().getSerialNumber(), CrlReason.CESSATION_OF_OPERATION, invalidityDate);
            }
            catch (OperationException ex) {
                successful = false;
            }
        }
        return successful;
    }

    public void close() {
        if (this.threadPoolExecutor == null) {
            return;
        }
        this.threadPoolExecutor.shutdown();
        this.threadPoolExecutor = null;
    }

    private class PendingPoolCleaner
    implements Runnable {
        private PendingPoolCleaner() {
        }

        @Override
        public void run() {
            Set<CertificateInfo> remainingCerts = SdkResponder.this.pendingCertPool.removeConfirmTimeoutedCertificates();
            if (CollectionUtil.isEmpty(remainingCerts)) {
                return;
            }
            Instant invalidityDate = Instant.now();
            X509Ca ca = null;
            for (CertificateInfo remainingCert : remainingCerts) {
                String caName = remainingCert.getIssuer().getName();
                BigInteger serialNumber = remainingCert.getCert().getCert().getSerialNumber();
                if (ca == null || !ca.getCaIdent().getName().equals(caName)) {
                    try {
                        ca = SdkResponder.this.caManager.getX509Ca(caName);
                    }
                    catch (CaMgmtException e) {
                        LOG.error("could not revoke certificate (CA={}, serialNumber={}): unknown CA", (Object)caName, (Object)LogUtil.formatCsn((BigInteger)serialNumber));
                        continue;
                    }
                }
                try {
                    ca.revokeCert(null, serialNumber, CrlReason.CESSATION_OF_OPERATION, invalidityDate);
                }
                catch (Throwable th) {
                    LOG.error("could not revoke certificate (CA={}, serialNumber={}): {}", new Object[]{ca.getCaInfo().getIdent(), LogUtil.formatCsn((BigInteger)serialNumber), th.getMessage()});
                }
            }
        }
    }
}

