/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.util.Arrays;
import org.xipki.util.StringUtil;

public class Base64Url {
    private static final String CA_TEXT = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
    private static final char[] CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();
    private static final byte[] BASE64URL_BYTES = StringUtil.toUtf8Bytes("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_=");
    private static final int[] IA = new int[256];

    public static boolean containsOnlyBase64UrlChars(byte[] bytes, int offset, int len) {
        int maxIndex = Math.min(bytes.length, offset + len);
        for (int i = offset; i < maxIndex; ++i) {
            byte bt = bytes[i];
            boolean contained = false;
            for (byte cb : BASE64URL_BYTES) {
                if (bt != cb) continue;
                contained = true;
                break;
            }
            if (contained) continue;
            return false;
        }
        return true;
    }

    public static char[] encodeToChar(byte[] sArr) {
        return Base64Url.encodeToChar(sArr, true);
    }

    public static char[] encodeToCharNoPadding(byte[] sArr) {
        return Base64Url.encodeToChar(sArr, false);
    }

    public static char[] encodeToChar(byte[] sArr, boolean withPadding) {
        int dLen;
        int sLen;
        int n = sLen = sArr != null ? sArr.length : 0;
        if (sLen == 0) {
            return new char[0];
        }
        int eLen = sLen / 3 * 3;
        int left = sLen - eLen;
        if (withPadding) {
            dLen = (sLen - 1) / 3 + 1 << 2;
        } else {
            dLen = eLen / 3 * 4;
            if (left == 1) {
                dLen += 2;
            } else if (left == 2) {
                dLen += 3;
            }
        }
        char[] dArr = new char[dLen];
        int s = 0;
        int d = 0;
        while (s < eLen) {
            int i = (sArr[s++] & 0xFF) << 16 | (sArr[s++] & 0xFF) << 8 | sArr[s++] & 0xFF;
            dArr[d++] = CA[i >>> 18 & 0x3F];
            dArr[d++] = CA[i >>> 12 & 0x3F];
            dArr[d++] = CA[i >>> 6 & 0x3F];
            dArr[d++] = CA[i & 0x3F];
        }
        int offset = eLen / 3 * 4;
        if (left > 0) {
            int i = (sArr[eLen] & 0xFF) << 10 | (left == 2 ? (sArr[sLen - 1] & 0xFF) << 2 : 0);
            dArr[offset++] = CA[i >> 12];
            dArr[offset++] = CA[i >>> 6 & 0x3F];
            if (withPadding) {
                dArr[offset++] = left == 2 ? CA[i & 0x3F] : 61;
                dArr[offset] = 61;
            } else if (left == 2) {
                dArr[offset] = CA[i & 0x3F];
            }
        }
        return dArr;
    }

    public static byte[] decodeFast(char[] sArr) {
        int sIx;
        int sLen = sArr.length;
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && IA[sArr[sIx]] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[sArr[eIx]] < 0) {
            --eIx;
        }
        int pad = sArr[eIx] == '=' ? (sArr[eIx - 1] == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int len = (cCnt * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = IA[sArr[sIx++]] << 18 | IA[sArr[sIx++]] << 12 | IA[sArr[sIx++]] << 6 | IA[sArr[sIx++]];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= IA[sArr[sIx++]] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    public static byte[] encodeToByte(byte[] sArr) {
        return Base64Url.encodeToByte(sArr, true);
    }

    public static byte[] encodeToByteNoPadding(byte[] sArr) {
        return Base64Url.encodeToByte(sArr, false);
    }

    public static byte[] encodeToByte(byte[] sArr, boolean withPadding) {
        int dLen;
        int sLen;
        int n = sLen = sArr != null ? sArr.length : 0;
        if (sLen == 0) {
            return new byte[0];
        }
        int eLen = sLen / 3 * 3;
        int left = sLen - eLen;
        if (withPadding) {
            dLen = (sLen - 1) / 3 + 1 << 2;
        } else {
            dLen = eLen / 3 * 4;
            if (left == 1) {
                dLen += 2;
            } else if (left == 2) {
                dLen += 3;
            }
        }
        byte[] dArr = new byte[dLen];
        int s = 0;
        int d = 0;
        while (s < eLen) {
            int i = (sArr[s++] & 0xFF) << 16 | (sArr[s++] & 0xFF) << 8 | sArr[s++] & 0xFF;
            dArr[d++] = (byte)CA[i >>> 18 & 0x3F];
            dArr[d++] = (byte)CA[i >>> 12 & 0x3F];
            dArr[d++] = (byte)CA[i >>> 6 & 0x3F];
            dArr[d++] = (byte)CA[i & 0x3F];
        }
        int offset = eLen / 3 * 4;
        if (left > 0) {
            int i = (sArr[eLen] & 0xFF) << 10 | (left == 2 ? (sArr[sLen - 1] & 0xFF) << 2 : 0);
            dArr[offset++] = (byte)CA[i >> 12];
            dArr[offset++] = (byte)CA[i >>> 6 & 0x3F];
            if (withPadding) {
                dArr[offset++] = left == 2 ? (int)CA[i & 0x3F] : 61;
                dArr[offset] = 61;
            } else if (left == 2) {
                dArr[offset] = (byte)CA[i & 0x3F];
            }
        }
        return dArr;
    }

    public static byte[] decodeFast(byte[] sArr) {
        int sIx;
        int sLen = sArr.length;
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && IA[sArr[sIx] & 0xFF] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[sArr[eIx] & 0xFF] < 0) {
            --eIx;
        }
        int pad = sArr[eIx] == 61 ? (sArr[eIx - 1] == 61 ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int len = (cCnt * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = IA[sArr[sIx++]] << 18 | IA[sArr[sIx++]] << 12 | IA[sArr[sIx++]] << 6 | IA[sArr[sIx++]];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= IA[sArr[sIx++]] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    public static String encodeToString(byte[] sArr) {
        return new String(Base64Url.encodeToChar(sArr, true));
    }

    public static String encodeToStringNoPadding(byte[] sArr) {
        return new String(Base64Url.encodeToChar(sArr, false));
    }

    public static String encodeToString(byte[] sArr, boolean withPadding) {
        return new String(Base64Url.encodeToChar(sArr, withPadding));
    }

    public static byte[] decodeFast(String s) {
        int sIx;
        int sLen = s.length();
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && IA[s.charAt(sIx) & 0xFF] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[s.charAt(eIx) & 0xFF] < 0) {
            --eIx;
        }
        int pad = s.charAt(eIx) == '=' ? (s.charAt(eIx - 1) == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int len = (cCnt * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = IA[s.charAt(sIx++)] << 18 | IA[s.charAt(sIx++)] << 12 | IA[s.charAt(sIx++)] << 6 | IA[s.charAt(sIx++)];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= IA[s.charAt(sIx++)] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    static {
        Arrays.fill(IA, -1);
        int is = CA.length;
        for (int i = 0; i < is; ++i) {
            Base64Url.IA[Base64Url.CA[i]] = i;
        }
        Base64Url.IA[61] = 0;
    }
}

