/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.http.XiHttpResponse;

public class HttpResponse {
    private final int statusCode;
    private final String contentType;
    private final Map<String, List<String>> headers;
    private final boolean base64;
    private final byte[] body;

    public HttpResponse(int statusCode) {
        this(statusCode, null, null, false, null);
    }

    public HttpResponse(int statusCode, String contentType, Map<String, String> headers, byte[] body) {
        this(statusCode, contentType, headers, false, body);
    }

    public HttpResponse(int statusCode, String contentType, Map<String, String> headers, boolean base64, byte[] body) {
        this.statusCode = statusCode;
        this.base64 = base64;
        this.contentType = contentType;
        this.headers = new HashMap<String, List<String>>();
        if (headers != null) {
            for (Map.Entry<String, String> m : headers.entrySet()) {
                this.headers.put(m.getKey(), Collections.singletonList(m.getValue()));
            }
        }
        this.body = body;
    }

    public boolean isBase64() {
        return this.base64;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public HttpResponse putHeader(String name, String value) {
        List values = this.headers.computeIfAbsent(name, k -> new ArrayList(1));
        values.add(value);
        return this;
    }

    public void fillResponse(XiHttpResponse resp) throws IOException {
        resp.setStatus(this.statusCode);
        if (this.contentType != null) {
            resp.setContentType(this.contentType);
        }
        if (CollectionUtil.isNotEmpty(this.headers)) {
            for (Map.Entry<String, List<String>> m : this.headers.entrySet()) {
                for (String value : m.getValue()) {
                    resp.addHeader(m.getKey(), value);
                }
            }
        }
        if (this.body == null || this.body.length == 0) {
            resp.setContentLength(0);
        } else {
            byte[] content;
            if (this.base64) {
                resp.setHeader("Content-Transfer-Encoding", "base64");
                content = Base64.encodeToByte(this.body, true);
            } else {
                content = this.body;
            }
            resp.setContentLength(content.length);
            resp.getOutputStream().write(content);
        }
    }
}

