/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.IoUtil;
import org.xipki.util.exception.ObjectCreationException;
import org.xipki.util.http.HttpRespContent;
import org.xipki.util.http.SslContextConf;
import org.xipki.util.http.XiHttpClientException;

public class XiHttpClient {
    private final SSLSocketFactory sslSocketFactory;
    private final HostnameVerifier hostnameVerifier;

    public XiHttpClient() {
        this.sslSocketFactory = null;
        this.hostnameVerifier = null;
    }

    public XiHttpClient(SslContextConf sslContextConf) throws ObjectCreationException {
        this.sslSocketFactory = sslContextConf.getSslSocketFactory();
        this.hostnameVerifier = sslContextConf.getHostnameVerifier();
    }

    public XiHttpClient(SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier) {
        this.sslSocketFactory = sslSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
    }

    public HttpRespContent httpGet(String url) throws IOException {
        try {
            HttpURLConnection httpConn = this.openHttpConn(new URL(Args.notNull(url, "url")));
            httpConn.setRequestMethod("GET");
            return this.parseResponse(httpConn);
        }
        catch (XiHttpClientException ex) {
            throw new IOException(ex);
        }
    }

    public HttpRespContent httpPost(String url, String requestContentType, byte[] request, String expectedRespContentType) throws IOException {
        HttpRespContent resp = this.httpPost(url, requestContentType, request);
        String responseContentType = resp.getContentType();
        boolean isValidContentType = false;
        if (responseContentType != null && responseContentType.equalsIgnoreCase(expectedRespContentType)) {
            isValidContentType = true;
        }
        if (!isValidContentType) {
            throw new IOException("bad response: mime type " + responseContentType + " not supported!");
        }
        return resp;
    }

    public HttpRespContent httpPost(String url, String requestContentType, byte[] request) throws IOException {
        try {
            HttpURLConnection httpConn = this.openHttpConn(new URL(Args.notNull(url, "url")));
            httpConn.setRequestMethod("POST");
            httpConn.setDoOutput(true);
            httpConn.setUseCaches(false);
            if (request != null) {
                if (requestContentType != null) {
                    httpConn.setRequestProperty("Content-Type", requestContentType);
                }
                httpConn.setRequestProperty("Content-Length", Integer.toString(request.length));
                OutputStream outputstream = httpConn.getOutputStream();
                outputstream.write(request);
                outputstream.flush();
            }
            return this.parseResponse(httpConn);
        }
        catch (XiHttpClientException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    private HttpRespContent parseResponse(HttpURLConnection conn) throws XiHttpClientException {
        try {
            String encoding;
            byte[] content;
            int respCode = Args.notNull(conn, "conn").getResponseCode();
            InputStream inputstream = respCode == 200 ? conn.getInputStream() : conn.getErrorStream();
            byte[] byArray = content = inputstream == null ? new byte[]{} : IoUtil.readAllBytesAndClose(inputstream);
            if (content.length > 0 && (encoding = conn.getHeaderField("content-transfer-encoding")) != null && "base64".equalsIgnoreCase(encoding.trim())) {
                content = Base64.decode(content);
            }
            return respCode == 200 ? HttpRespContent.ofOk(conn.getContentType(), content) : HttpRespContent.of(respCode, conn.getContentType(), content);
        }
        catch (IOException ex) {
            throw new XiHttpClientException(ex);
        }
    }

    private HttpURLConnection openHttpConn(URL url) throws IOException {
        URLConnection conn = Args.notNull(url, "url").openConnection();
        if (!(conn instanceof HttpURLConnection)) {
            throw new IOException(url + " is not of protocol HTTP: " + url.getProtocol());
        }
        if (conn instanceof HttpsURLConnection) {
            if (this.sslSocketFactory != null) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(this.sslSocketFactory);
            }
            if (this.hostnameVerifier != null) {
                ((HttpsURLConnection)conn).setHostnameVerifier(this.hostnameVerifier);
            }
        }
        return (HttpURLConnection)conn;
    }
}

