/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.SecureRandom;
import java.time.Clock;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.util.Base64Url;
import org.xipki.util.LogUtil;

public class NonceManager {
    private static final Logger LOG = LoggerFactory.getLogger(NonceManager.class);
    private final AtomicLong lastCleanUp = new AtomicLong();
    private final ConcurrentHashMap<String, Long> noncePool = new ConcurrentHashMap();
    private final int nonceNumBytes;
    private long validityMs = 600000L;
    private final SecureRandom rnd = new SecureRandom();

    public NonceManager(int nonceNumBytes) {
        this.nonceNumBytes = nonceNumBytes;
        File nonceFile = new File(".nonces");
        if (!nonceFile.exists()) {
            return;
        }
        long now = Clock.systemUTC().millis();
        long maxNotAftter = now + 10000L;
        int sum = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(nonceFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, ":");
                String nonce = tokenizer.nextToken();
                long notAfter = Math.min(maxNotAftter, Long.parseLong(tokenizer.nextToken(), 16));
                if (notAfter <= now) continue;
                ++sum;
                this.noncePool.put(nonce, notAfter);
            }
        }
        catch (IOException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error reading nonces");
        }
        LOG.info("restored {} nonces", (Object)sum);
    }

    public long getValidityMs() {
        return this.validityMs;
    }

    public void setValidityMs(long validityMs) {
        this.validityMs = validityMs;
    }

    public String newNonce() {
        if (this.noncePool.size() > 9999) {
            long now = Clock.systemUTC().millis();
            if (now > this.lastCleanUp.get() + 10000L) {
                for (Map.Entry<String, Long> entry : this.noncePool.entrySet()) {
                    if (entry.getValue() >= now) continue;
                    this.noncePool.remove(entry.getKey());
                }
            }
            this.lastCleanUp.set(now);
        }
        byte[] nonce = new byte[this.nonceNumBytes];
        this.rnd.nextBytes(nonce);
        String nonceText = Base64Url.encodeToStringNoPadding((byte[])nonce);
        this.noncePool.put(nonceText, Clock.systemUTC().millis() + this.validityMs);
        return nonceText;
    }

    public boolean removeNonce(String nonce) {
        return null != this.noncePool.remove(nonce);
    }

    public void close() {
        if (this.noncePool.isEmpty()) {
            return;
        }
        long now = Clock.systemUTC().millis();
        int sum = 0;
        try (OutputStream os = Files.newOutputStream(Paths.get(".nonces", new String[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            for (Map.Entry<String, Long> entry : this.noncePool.entrySet()) {
                if (entry.getValue() < now) continue;
                ++sum;
                String line = entry.getKey() + ":" + Long.toString(entry.getValue(), 16) + "\n";
                os.write(line.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error saving nonces");
        }
        LOG.info("saved {} nonces", (Object)sum);
    }
}

