/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import java.math.BigInteger;
import org.xipki.ca.sdk.SdkEncodable;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;

public class ConfirmCertRequestEntry
extends SdkEncodable {
    private final boolean accept;
    private final BigInteger certReqId;
    private final byte[] certhash;

    public ConfirmCertRequestEntry(boolean accept, BigInteger certReqId, byte[] certhash) {
        this.accept = accept;
        this.certhash = certhash;
        this.certReqId = certReqId;
    }

    public BigInteger getCertReqId() {
        return this.certReqId;
    }

    public byte[] getCerthash() {
        return this.certhash;
    }

    public boolean isAccept() {
        return this.accept;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws IOException {
        encoder.writeArrayStart(3);
        encoder.writeBoolean(this.accept);
        encoder.writeBigInt(this.certReqId);
        encoder.writeByteString(this.certhash);
    }

    public static ConfirmCertRequestEntry decode(CborDecoder decoder) throws DecodeException {
        try {
            if (decoder.readNullOrArrayLength(3)) {
                return null;
            }
            return new ConfirmCertRequestEntry(decoder.readBoolean(), decoder.readBigInt(), decoder.readByteString());
        }
        catch (IOException | RuntimeException ex) {
            throw new DecodeException(ConfirmCertRequestEntry.buildDecodeErrMessage(ex, ConfirmCertRequestEntry.class), (Throwable)ex);
        }
    }

    public static ConfirmCertRequestEntry[] decodeArray(CborDecoder decoder) throws DecodeException {
        Integer arrayLen = decoder.readNullOrArrayLength(ConfirmCertRequestEntry[].class);
        if (arrayLen == null) {
            return null;
        }
        ConfirmCertRequestEntry[] entries = new ConfirmCertRequestEntry[arrayLen.intValue()];
        for (int i = 0; i < arrayLen; ++i) {
            entries[i] = ConfirmCertRequestEntry.decode(decoder);
        }
        return entries;
    }
}

