/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import org.xipki.ca.sdk.OldCertInfo;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class OldCertInfoBySubject
extends OldCertInfo {
    private final byte[] subject;
    private final byte[] san;

    public OldCertInfoBySubject(boolean reusePublicKey, byte[] subject, byte[] san) {
        super(reusePublicKey);
        this.subject = subject;
        this.san = san;
    }

    public byte[] getSubject() {
        return this.subject;
    }

    public byte[] getSan() {
        return this.san;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
        encoder.writeArrayStart(3);
        encoder.writeBoolean(this.isReusePublicKey());
        encoder.writeByteString(this.subject);
        encoder.writeByteString(this.san);
    }

    public static OldCertInfoBySubject decode(CborDecoder decoder) throws DecodeException {
        try {
            if (decoder.readNullOrArrayLength(3)) {
                return null;
            }
            return new OldCertInfoBySubject(decoder.readBoolean(), decoder.readByteString(), decoder.readByteString());
        }
        catch (IOException | RuntimeException ex) {
            throw new DecodeException(OldCertInfoBySubject.buildDecodeErrMessage(ex, OldCertInfoBySubject.class), (Throwable)ex);
        }
    }
}

