/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import java.math.BigInteger;
import java.time.Instant;
import org.xipki.ca.sdk.SdkEncodable;
import org.xipki.security.CrlReason;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class RevokeCertRequestEntry
extends SdkEncodable {
    private final BigInteger serialNumber;
    private final CrlReason reason;
    private final Instant invalidityTime;

    public RevokeCertRequestEntry(BigInteger serialNumber, CrlReason reason, Instant invalidityTime) {
        this.serialNumber = serialNumber;
        this.reason = reason;
        this.invalidityTime = invalidityTime;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public CrlReason getReason() {
        return this.reason;
    }

    public Instant getInvalidityTime() {
        return this.invalidityTime;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
        encoder.writeArrayStart(3);
        encoder.writeBigInt(this.serialNumber);
        encoder.writeEnumObj((Enum)this.reason);
        encoder.writeInstant(this.invalidityTime);
    }

    public static RevokeCertRequestEntry decode(CborDecoder decoder) throws DecodeException {
        try {
            if (decoder.readNullOrArrayLength(3)) {
                return null;
            }
            BigInteger serialNumber = decoder.readBigInt();
            String str = decoder.readTextString();
            CrlReason reason = str == null ? null : CrlReason.valueOf((String)str);
            return new RevokeCertRequestEntry(serialNumber, reason, decoder.readInstant());
        }
        catch (IOException | RuntimeException ex) {
            throw new DecodeException(RevokeCertRequestEntry.buildDecodeErrMessage(ex, RevokeCertRequestEntry.class), (Throwable)ex);
        }
    }

    public static RevokeCertRequestEntry[] decodeArray(CborDecoder decoder) throws DecodeException {
        Integer arrayLen;
        try {
            arrayLen = decoder.readNullOrArrayLength();
        }
        catch (IOException ex) {
            throw new DecodeException("error decoding " + RevokeCertRequestEntry[].class.getName(), (Throwable)ex);
        }
        if (arrayLen == null) {
            return null;
        }
        RevokeCertRequestEntry[] entries = new RevokeCertRequestEntry[arrayLen.intValue()];
        for (int i = 0; i < arrayLen; ++i) {
            entries[i] = RevokeCertRequestEntry.decode(decoder);
        }
        return entries;
    }
}

