/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import org.xipki.ca.sdk.CaIdentifierRequest;
import org.xipki.ca.sdk.RevokeCertRequestEntry;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.util.cbor.ByteArrayCborDecoder;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncodable;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class RevokeCertsRequest
extends CaIdentifierRequest {
    private final RevokeCertRequestEntry[] entries;

    public RevokeCertsRequest(byte[] issuerCertSha1Fp, X500NameType issuer, byte[] authorityKeyIdentifier, RevokeCertRequestEntry[] entries) {
        super(issuerCertSha1Fp, issuer, authorityKeyIdentifier);
        this.entries = entries;
    }

    public RevokeCertRequestEntry[] getEntries() {
        return this.entries;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
        super.encode0(encoder, 1);
        encoder.writeObjects((CborEncodable[])this.entries);
    }

    public static RevokeCertsRequest decode(byte[] encoded) throws DecodeException {
        RevokeCertsRequest revokeCertsRequest;
        ByteArrayCborDecoder decoder = new ByteArrayCborDecoder(encoded);
        try {
            RevokeCertsRequest.assertArrayStart("RevokeCertsRequest", (CborDecoder)decoder, 4);
            revokeCertsRequest = new RevokeCertsRequest(decoder.readByteString(), X500NameType.decode((CborDecoder)decoder), decoder.readByteString(), RevokeCertRequestEntry.decodeArray((CborDecoder)decoder));
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(RevokeCertsRequest.buildDecodeErrMessage(ex, RevokeCertsRequest.class), (Throwable)ex);
            }
        }
        decoder.close();
        return revokeCertsRequest;
    }
}

