/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.asn1.x500.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.sdk.CaIdentifierRequest;
import org.xipki.ca.sdk.CaNameResponse;
import org.xipki.ca.sdk.CertChainResponse;
import org.xipki.ca.sdk.CertprofileInfoRequest;
import org.xipki.ca.sdk.CertprofileInfoResponse;
import org.xipki.ca.sdk.CertsMode;
import org.xipki.ca.sdk.ConfirmCertsRequest;
import org.xipki.ca.sdk.CrlResponse;
import org.xipki.ca.sdk.EnrollCertRequestEntry;
import org.xipki.ca.sdk.EnrollCertsRequest;
import org.xipki.ca.sdk.EnrollOrPollCertsResponse;
import org.xipki.ca.sdk.EnrollOrPullCertResponseEntry;
import org.xipki.ca.sdk.ErrorResponse;
import org.xipki.ca.sdk.GenCRLRequest;
import org.xipki.ca.sdk.GetCRLRequest;
import org.xipki.ca.sdk.GetCertRequest;
import org.xipki.ca.sdk.OldCertInfoByIssuerAndSerial;
import org.xipki.ca.sdk.PayloadResponse;
import org.xipki.ca.sdk.PollCertRequest;
import org.xipki.ca.sdk.RevokeCertsRequest;
import org.xipki.ca.sdk.RevokeCertsResponse;
import org.xipki.ca.sdk.SdkClientConf;
import org.xipki.ca.sdk.SdkErrorResponseException;
import org.xipki.ca.sdk.SdkRequest;
import org.xipki.ca.sdk.TransactionIdRequest;
import org.xipki.ca.sdk.UnSuspendOrRemoveCertsResponse;
import org.xipki.ca.sdk.UnsuspendOrRemoveRequest;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.pki.ErrorCode;
import org.xipki.security.KeyCertBytesPair;
import org.xipki.util.LogUtil;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;
import org.xipki.util.exception.ObjectCreationException;
import org.xipki.util.http.HttpRespContent;
import org.xipki.util.http.SslConf;
import org.xipki.util.http.SslContextConf;
import org.xipki.util.http.XiHttpClient;

public class SdkClient {
    private static final Logger LOG = LoggerFactory.getLogger(SdkClient.class);
    private static final String CONTENT_TYPE_CBOR = "application/cbor";
    private final String serverUrl;
    private final XiHttpClient client;

    public SdkClient(SdkClientConf conf) throws ObjectCreationException {
        this.serverUrl = conf.getServerUrl();
        SslContextConf sdkSslConf = SslContextConf.ofSslConf((SslConf)conf.getSsl());
        this.client = new XiHttpClient(sdkSslConf.getSslSocketFactory(), sdkSslConf.getHostnameVerifier());
    }

    public SdkClient(String serverUrl, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier) {
        this.serverUrl = serverUrl;
        this.client = new XiHttpClient(sslSocketFactory, hostnameVerifier);
    }

    public byte[] send(String ca, String command, SdkRequest request) throws SdkErrorResponseException {
        HttpRespContent resp;
        block9: {
            String ct = request == null ? null : CONTENT_TYPE_CBOR;
            String prefix = ca == null ? this.serverUrl + "-/" : this.serverUrl + ca + "/";
            try {
                byte[] encodedReq;
                if (request == null) {
                    resp = this.client.httpGet(prefix + command);
                    break block9;
                }
                try {
                    encodedReq = request.encode();
                }
                catch (EncodeException e) {
                    LogUtil.warn((Logger)LOG, (Throwable)e, (String)e.getMessage());
                    throw new SdkErrorResponseException(ErrorCode.CLIENT_REQUEST_ENCODE_ERROR, e.getMessage());
                }
                resp = this.client.httpPost(prefix + command, ct, encodedReq, CONTENT_TYPE_CBOR);
            }
            catch (IOException ex) {
                throw new SdkErrorResponseException(ErrorCode.SYSTEM_UNAVAILABLE, "IO error sending request to the CA");
            }
        }
        if (resp.isOK()) {
            return resp.getContent();
        }
        byte[] errorContent = resp.getContent();
        if (errorContent == null) {
            throw new SdkErrorResponseException(ErrorCode.SYSTEM_FAILURE, null);
        }
        try {
            throw new SdkErrorResponseException(ErrorResponse.decode(errorContent));
        }
        catch (DecodeException e) {
            throw new SdkErrorResponseException(ErrorCode.CLIENT_RESPONSE_DECODE_ERROR, e.getMessage());
        }
    }

    public boolean healthy(String ca) {
        try {
            this.send(ca, "health", null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public byte[] cacert(String ca) throws SdkErrorResponseException {
        CertChainResponse resp;
        byte[] respBytes = this.send(ca, "cacert", null);
        try {
            resp = CertChainResponse.decode(respBytes);
        }
        catch (DecodeException e) {
            throw new SdkErrorResponseException(ErrorCode.CLIENT_RESPONSE_DECODE_ERROR, e.getMessage());
        }
        byte[][] certs = resp.getCertificates();
        return certs == null || certs.length == 0 ? null : certs[0];
    }

    public byte[][] cacerts(String ca) throws SdkErrorResponseException {
        CertChainResponse resp;
        byte[] respBytes = this.send(ca, "cacerts", null);
        try {
            resp = CertChainResponse.decode(respBytes);
        }
        catch (DecodeException e) {
            throw new SdkErrorResponseException(ErrorCode.CLIENT_RESPONSE_DECODE_ERROR, e.getMessage());
        }
        return resp.getCertificates();
    }

    public byte[] cacertBySubject(byte[] subject) throws SdkErrorResponseException {
        CertChainResponse resp;
        X500NameType issuer = new X500NameType(subject);
        CaIdentifierRequest req = new CaIdentifierRequest(null, issuer, null);
        byte[] respBytes = this.send(null, "cacert2", req);
        try {
            resp = CertChainResponse.decode(respBytes);
        }
        catch (DecodeException e) {
            throw new SdkErrorResponseException(ErrorCode.CLIENT_RESPONSE_DECODE_ERROR, e.getMessage());
        }
        byte[][] certs = resp.getCertificates();
        return certs == null || certs.length == 0 ? null : certs[0];
    }

    public byte[][] cacertsBySubject(byte[] subject) throws SdkErrorResponseException {
        CertChainResponse resp;
        X500NameType issuer = new X500NameType(subject);
        CaIdentifierRequest req = new CaIdentifierRequest(null, issuer, null);
        byte[] respBytes = this.send(null, "cacerts2", req);
        try {
            resp = CertChainResponse.decode(respBytes);
        }
        catch (DecodeException e) {
            throw new SdkErrorResponseException(ErrorCode.CLIENT_RESPONSE_DECODE_ERROR, e.getMessage());
        }
        return resp.getCertificates();
    }

    public CaNameResponse caNameBySubject(byte[] subject) throws SdkErrorResponseException {
        X500NameType issuer = new X500NameType(subject);
        CaIdentifierRequest req = new CaIdentifierRequest(null, issuer, null);
        byte[] respBytes = this.send(null, "caname", req);
        try {
            return CaNameResponse.decode(respBytes);
        }
        catch (DecodeException e) {
            throw new SdkErrorResponseException(ErrorCode.CLIENT_RESPONSE_DECODE_ERROR, e.getMessage());
        }
    }

    public CertprofileInfoResponse profileInfo(String ca, String profileName) throws SdkErrorResponseException {
        CertprofileInfoRequest req = new CertprofileInfoRequest(profileName);
        byte[] respBytes = this.send(ca, "profileinfo", req);
        try {
            return CertprofileInfoResponse.decode(respBytes);
        }
        catch (DecodeException e) {
            throw new SdkErrorResponseException(ErrorCode.CLIENT_RESPONSE_DECODE_ERROR, e.getMessage());
        }
    }

    public byte[] generateCrl(String ca, String crldp) throws SdkErrorResponseException {
        CrlResponse resp;
        GenCRLRequest req = new GenCRLRequest(crldp);
        byte[] respBytes = this.send(ca, "gen_crl", req);
        try {
            resp = CrlResponse.decode(respBytes);
        }
        catch (DecodeException e) {
            throw new SdkErrorResponseException(ErrorCode.CLIENT_RESPONSE_DECODE_ERROR, e.getMessage());
        }
        return resp.getCrl();
    }

    public byte[] currentCrl(String ca) throws SdkErrorResponseException {
        return this.currentCrl(ca, null, null, null);
    }

    public byte[] currentCrl(String ca, BigInteger crlNumber, Instant thisUpdate, String crlDp) throws SdkErrorResponseException {
        CrlResponse resp;
        GetCRLRequest req = new GetCRLRequest(crlNumber, thisUpdate, crlDp);
        byte[] respBytes = this.send(ca, "crl", req);
        try {
            resp = CrlResponse.decode(respBytes);
        }
        catch (DecodeException e) {
            throw new SdkErrorResponseException(ErrorCode.CLIENT_RESPONSE_DECODE_ERROR, e.getMessage());
        }
        return resp.getCrl();
    }

    private byte[] enrollCert0(String func, String cmd, String ca, EnrollCertRequestEntry reqEntry) throws SdkErrorResponseException {
        EnrollOrPollCertsResponse resp;
        EnrollCertsRequest req = new EnrollCertsRequest();
        req.setCaCertMode(CertsMode.NONE);
        req.setEntries(new EnrollCertRequestEntry[]{reqEntry});
        byte[] respBytes = this.send(ca, cmd, req);
        try {
            resp = EnrollOrPollCertsResponse.decode(respBytes);
        }
        catch (DecodeException e) {
            throw new SdkErrorResponseException(ErrorCode.CLIENT_RESPONSE_DECODE_ERROR, e.getMessage());
        }
        EnrollOrPullCertResponseEntry rEntry = resp.getEntries()[0];
        return Optional.ofNullable(rEntry.getCert()).orElseThrow(() -> new SdkErrorResponseException(ErrorCode.SYSTEM_FAILURE, "error " + func));
    }

    private KeyCertBytesPair enrollCertCaGenKeypair0(String func, String cmd, String ca, EnrollCertRequestEntry reqEntry) throws SdkErrorResponseException {
        EnrollOrPollCertsResponse resp;
        EnrollCertsRequest req = new EnrollCertsRequest();
        req.setCaCertMode(CertsMode.NONE);
        req.setEntries(new EnrollCertRequestEntry[]{reqEntry});
        byte[] respBytes = this.send(ca, cmd, req);
        try {
            resp = EnrollOrPollCertsResponse.decode(respBytes);
        }
        catch (DecodeException e) {
            throw new SdkErrorResponseException(ErrorCode.CLIENT_RESPONSE_DECODE_ERROR, e.getMessage());
        }
        EnrollOrPullCertResponseEntry rEntry = resp.getEntries()[0];
        if (rEntry.getCert() == null || rEntry.getPrivateKey() == null) {
            throw new SdkErrorResponseException(ErrorCode.SYSTEM_FAILURE, "error " + func);
        }
        return new KeyCertBytesPair(rEntry.getPrivateKey(), rEntry.getCert());
    }

    public byte[] enrollCert(String ca, String certprofile, byte[] p10Req) throws SdkErrorResponseException {
        EnrollCertRequestEntry reqEntry = new EnrollCertRequestEntry();
        reqEntry.setP10req(p10Req);
        reqEntry.setCertprofile(certprofile);
        return this.enrollCert0("enrollCert", "enroll", ca, reqEntry);
    }

    public KeyCertBytesPair enrollCertCaGenKeypair(String ca, String certprofile, String subject) throws SdkErrorResponseException {
        EnrollCertRequestEntry reqEntry = new EnrollCertRequestEntry();
        reqEntry.setSubject(new X500NameType(subject));
        reqEntry.setCertprofile(certprofile);
        return this.enrollCertCaGenKeypair0("enrollCertCaGenKeypair", "enroll", ca, reqEntry);
    }

    public byte[] reenrollCert(String ca, String certprofile, byte[] p10Req, X500Name oldCertIssuer, BigInteger oldCertSerialNumber) throws SdkErrorResponseException {
        EnrollCertRequestEntry reqEntry = new EnrollCertRequestEntry();
        reqEntry.setCertprofile(certprofile);
        reqEntry.setP10req(p10Req);
        reqEntry.setOldCertIsn(new OldCertInfoByIssuerAndSerial(false, new X500NameType(oldCertIssuer), oldCertSerialNumber));
        return this.enrollCert0("reenrollCert", "reenroll", ca, reqEntry);
    }

    public KeyCertBytesPair reenrollCertCaGenKeypair(String ca, String certprofile, X500Name subject, String oldCertIssuer, BigInteger oldCertSerialNumber) throws SdkErrorResponseException {
        EnrollCertRequestEntry reqEntry = new EnrollCertRequestEntry();
        reqEntry.setCertprofile(certprofile);
        reqEntry.setSubject(new X500NameType(subject));
        reqEntry.setOldCertIsn(new OldCertInfoByIssuerAndSerial(false, new X500NameType(oldCertIssuer), oldCertSerialNumber));
        return this.enrollCertCaGenKeypair0("reenrollCertCaGenKeypair", "reenroll", ca, reqEntry);
    }

    public EnrollOrPollCertsResponse enrollCerts(String ca, EnrollCertsRequest req) throws SdkErrorResponseException {
        byte[] respBytes = this.send(ca, "enroll", req);
        return this.checkEnrollResp(respBytes, req);
    }

    public EnrollOrPollCertsResponse enrollCrossCerts(String ca, EnrollCertsRequest req) throws SdkErrorResponseException {
        byte[] respBytes = this.send(ca, "enroll_cross", req);
        return this.checkEnrollResp(respBytes, req);
    }

    public EnrollOrPollCertsResponse reenrollCerts(String ca, EnrollCertsRequest req) throws SdkErrorResponseException {
        byte[] respBytes = this.send(ca, "reenroll", req);
        return this.checkEnrollResp(respBytes, req);
    }

    private EnrollOrPollCertsResponse checkEnrollResp(byte[] respBytes, EnrollCertsRequest req) throws SdkErrorResponseException {
        int size;
        EnrollOrPollCertsResponse resp;
        try {
            resp = EnrollOrPollCertsResponse.decode(respBytes);
        }
        catch (DecodeException e) {
            throw new SdkErrorResponseException(ErrorCode.CLIENT_RESPONSE_DECODE_ERROR, e.getMessage());
        }
        EnrollOrPullCertResponseEntry[] entries = resp.getEntries();
        int expectedSize = req.getEntries().length;
        int n = size = entries == null ? 0 : entries.length;
        if (expectedSize != size) {
            throw new SdkErrorResponseException(ErrorCode.SYSTEM_FAILURE, "expected " + expectedSize + " entries, but received " + size);
        }
        return resp;
    }

    public void confirmCerts(String ca, ConfirmCertsRequest req) throws SdkErrorResponseException {
        this.send(ca, "confirm_enroll", req);
    }

    public void revokePendingCerts(String ca, String tid) throws SdkErrorResponseException {
        TransactionIdRequest req = new TransactionIdRequest(tid);
        this.send(ca, "revoke_pending_cert", req);
    }

    public EnrollOrPollCertsResponse pollCerts(PollCertRequest req) throws SdkErrorResponseException {
        byte[] respBytes = this.send(null, "poll_cert", req);
        try {
            return EnrollOrPollCertsResponse.decode(respBytes);
        }
        catch (DecodeException e) {
            throw new SdkErrorResponseException(ErrorCode.CLIENT_RESPONSE_DECODE_ERROR, e.getMessage());
        }
    }

    public RevokeCertsResponse revokeCerts(RevokeCertsRequest req) throws SdkErrorResponseException {
        byte[] respBytes = this.send(null, "revoke_cert", req);
        try {
            return RevokeCertsResponse.decode(respBytes);
        }
        catch (DecodeException e) {
            throw new SdkErrorResponseException(ErrorCode.CLIENT_RESPONSE_DECODE_ERROR, e.getMessage());
        }
    }

    public UnSuspendOrRemoveCertsResponse unsuspendCerts(UnsuspendOrRemoveRequest req) throws SdkErrorResponseException {
        byte[] respBytes = this.send(null, "unsuspend_cert", req);
        try {
            return UnSuspendOrRemoveCertsResponse.decode(respBytes);
        }
        catch (DecodeException e) {
            throw new SdkErrorResponseException(ErrorCode.CLIENT_RESPONSE_DECODE_ERROR, e.getMessage());
        }
    }

    public UnSuspendOrRemoveCertsResponse removeCerts(UnsuspendOrRemoveRequest req) throws SdkErrorResponseException {
        byte[] respBytes = this.send(null, "remove_cert", req);
        try {
            return UnSuspendOrRemoveCertsResponse.decode(respBytes);
        }
        catch (DecodeException e) {
            throw new SdkErrorResponseException(ErrorCode.CLIENT_RESPONSE_DECODE_ERROR, e.getMessage());
        }
    }

    public byte[] getCert(String caName, X500Name issuer, BigInteger serialNumber) throws SdkErrorResponseException {
        PayloadResponse resp;
        GetCertRequest req = new GetCertRequest(serialNumber, new X500NameType(issuer));
        byte[] respBytes = this.send(caName, "get_cert", req);
        try {
            resp = PayloadResponse.decode(respBytes);
        }
        catch (DecodeException e) {
            throw new SdkErrorResponseException(ErrorCode.CLIENT_RESPONSE_DECODE_ERROR, e.getMessage());
        }
        return resp.getPayload();
    }
}

