/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.scep;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Optional;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditService;
import org.xipki.audit.AuditStatus;
import org.xipki.audit.Audits;
import org.xipki.ca.gateway.GatewayUtil;
import org.xipki.ca.gateway.PopControl;
import org.xipki.ca.gateway.Requestor;
import org.xipki.ca.gateway.RequestorAuthenticator;
import org.xipki.ca.gateway.conf.CaProfilesControl;
import org.xipki.ca.gateway.scep.CaNameScepSigners;
import org.xipki.ca.gateway.scep.ScepControl;
import org.xipki.ca.gateway.scep.ScepSigner;
import org.xipki.ca.sdk.CertsMode;
import org.xipki.ca.sdk.EnrollCertRequestEntry;
import org.xipki.ca.sdk.EnrollCertsRequest;
import org.xipki.ca.sdk.EnrollOrPollCertsResponse;
import org.xipki.ca.sdk.EnrollOrPullCertResponseEntry;
import org.xipki.ca.sdk.PollCertRequest;
import org.xipki.ca.sdk.PollCertRequestEntry;
import org.xipki.ca.sdk.SdkClient;
import org.xipki.ca.sdk.SdkErrorResponseException;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.pki.ErrorCode;
import org.xipki.pki.OperationException;
import org.xipki.scep.message.CaCaps;
import org.xipki.scep.message.DecodedPkiMessage;
import org.xipki.scep.message.EnvelopedDataDecryptor;
import org.xipki.scep.message.IssuerAndSubject;
import org.xipki.scep.message.MessageDecodingException;
import org.xipki.scep.message.MessageEncodingException;
import org.xipki.scep.message.PkiMessage;
import org.xipki.scep.transaction.CaCapability;
import org.xipki.scep.transaction.FailInfo;
import org.xipki.scep.transaction.MessageType;
import org.xipki.scep.transaction.Nonce;
import org.xipki.scep.transaction.Operation;
import org.xipki.scep.transaction.PkiStatus;
import org.xipki.security.HashAlgo;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.http.HttpResponse;
import org.xipki.util.http.XiHttpRequest;

public class ScepResponder {
    private static final String NAME_decryption = "decryption";
    private static final String NAME_fail_info = "fail_info";
    private static final String NAME_failure_message = "failure_message";
    private static final String NAME_message_type = "message_type";
    private static final String NAME_pki_status = "pki_status";
    private static final String NAME_signature = "signature";
    private static final Logger LOG = LoggerFactory.getLogger(ScepResponder.class);
    private static final String CGI_PROGRAM = "/pkiclient.exe";
    private static final int CGI_PROGRAM_LEN = "/pkiclient.exe".length();
    private static final String CT_RESPONSE = "application/x-pki-message";
    private final ScepControl control;
    private final SdkClient sdk;
    private final PopControl popControl;
    private final CaProfilesControl caProfilesControl;
    private final CaCaps caCaps;
    private final SecurityFactory securityFactory;
    private final RequestorAuthenticator authenticator;
    private final CaNameScepSigners signers;

    public ScepResponder(ScepControl control, SdkClient sdk, SecurityFactory securityFactory, CaNameScepSigners signers, RequestorAuthenticator authenticator, PopControl popControl, CaProfilesControl caProfiles) {
        this.control = (ScepControl)Args.notNull((Object)control, (String)"control");
        this.sdk = (SdkClient)Args.notNull((Object)sdk, (String)"sdk");
        this.securityFactory = (SecurityFactory)Args.notNull((Object)securityFactory, (String)"securityFactory");
        this.authenticator = (RequestorAuthenticator)Args.notNull((Object)authenticator, (String)"authenticator");
        this.popControl = (PopControl)Args.notNull((Object)popControl, (String)"popControl");
        CaCaps caps = new CaCaps();
        caps.addCapabilities(new CaCapability[]{CaCapability.SCEPStandard, CaCapability.AES, CaCapability.DES3, CaCapability.POSTPKIOperation, CaCapability.Renewal, CaCapability.SHA1, CaCapability.SHA256, CaCapability.SHA512});
        this.caCaps = caps;
        this.signers = signers;
        this.caProfilesControl = (CaProfilesControl)Args.notNull((Object)caProfiles, (String)"caProfiles");
    }

    private CaCaps getCaCaps() {
        return this.caCaps;
    }

    private Requestor.PasswordRequestor getRequestor(String user) {
        return this.authenticator.getPasswordRequestorByUser(user);
    }

    private Requestor.CertRequestor getRequestor(X509Cert cert) {
        return this.authenticator.getCertRequestor(cert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpResponse service(String path, byte[] request, XiHttpRequest metadataRetriever) {
        caName = null;
        certprofileName = null;
        if (path.length() > 1 && path.endsWith("/pkiclient.exe")) {
            if (path.length() == ScepResponder.CGI_PROGRAM_LEN) {
                tokens = new String[]{};
            } else {
                tpath = path.substring(1, path.length() - ScepResponder.CGI_PROGRAM_LEN);
                tokens = StringUtil.splitAsArray((String)tpath, (String)"/");
            }
            if (tokens.length == 0 || tokens.length == 1) {
                alias = tokens.length == 0 ? "default" : tokens[0].trim();
                caProfileConf = this.caProfilesControl.getCaProfile(alias);
                if (caProfileConf == null) {
                    message = "unknown alias " + alias;
                    ScepResponder.LOG.warn(message);
                    return new HttpResponse(404);
                }
                caName = caProfileConf.getCa();
                certprofileName = caProfileConf.getCertprofile();
            } else if (tokens.length == 2) {
                caName = tokens[0];
                certprofileName = tokens[1].toLowerCase();
            }
        }
        if (caName == null) {
            return new HttpResponse(404);
        }
        auditService = Audits.getAuditService();
        event = new AuditEvent();
        event.setApplicationName("scep-gw");
        event.addEventData("name", (Object)(caName + "/" + certprofileName));
        auditLevel = AuditLevel.INFO;
        auditStatus = AuditStatus.SUCCESSFUL;
        auditMessage = null;
        operation = metadataRetriever.getParameter("operation");
        event.addEventData("operation", (Object)operation);
        if (!"PKIOperation".equalsIgnoreCase(operation)) ** GOTO lbl111
        try {
            reqMessage = new CMSSignedData(request);
            ** GOTO lbl-1000
        }
        catch (Exception ex) {
            msg = "invalid request";
            LogUtil.error((Logger)ScepResponder.LOG, (Throwable)ex, (String)"invalid request");
            auditMessage = "invalid request";
            auditStatus = AuditStatus.FAILED;
            var18_21 = new HttpResponse(400);
            ScepResponder.audit(auditService, event, auditLevel, auditStatus, (String)auditMessage);
            return var18_21;
        }
        {
            catch (Throwable th) {
                block31: {
                    try {
                        ScepResponder.LOG.error("Throwable thrown, this should not happen!", th);
                        auditLevel = AuditLevel.ERROR;
                        auditStatus = AuditStatus.FAILED;
                        auditMessage = "internal error";
                        ret = new HttpResponse(500);
                    }
                    catch (Throwable var22_35) {
                        ScepResponder.audit(auditService, event, auditLevel, auditStatus, auditMessage);
                        throw var22_35;
                    }
lbl-1000:
                    // 1 sources

                    {
                        signer = this.signers.getSigner(caName);
                        if (signer != null) break block31;
                        msg = "found no signer";
                        ScepResponder.LOG.error("found no signer for CA {}", (Object)caName);
                        auditMessage = "found no signer";
                        auditStatus = AuditStatus.FAILED;
                        var18_22 = new HttpResponse(400);
                    }
                    ScepResponder.audit(auditService, event, auditLevel, auditStatus, (String)auditMessage);
                    return var18_22;
                }
                try {
                    ci = this.servicePkiOperation(signer, caName, reqMessage, certprofileName, event);
                    ** GOTO lbl-1000
                }
                catch (MessageDecodingException ex) {
                    msg = "could not decrypt and/or verify the request";
                    LogUtil.error((Logger)ScepResponder.LOG, (Throwable)ex, (String)"could not decrypt and/or verify the request");
                    auditMessage = "could not decrypt and/or verify the request";
                    auditStatus = AuditStatus.FAILED;
                    var20_27 = new HttpResponse(400);
                    ScepResponder.audit(auditService, event, auditLevel, auditStatus, (String)auditMessage);
                    return var20_27;
                }
                catch (SdkErrorResponseException | OperationException ex) {}
                {
                    if (ex instanceof OperationException) {
                        auditMessage = ex.getMessage();
                        code = ((OperationException)ex).getErrorCode();
                    } else {
                        err = ((SdkErrorResponseException)ex).getErrorResponse();
                        auditMessage = err.getMessage();
                        code = err.getCode();
                    }
                    switch (1.$SwitchMap$org$xipki$pki$ErrorCode[code.ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: {
                            httpCode = 403;
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: {
                            httpCode = 400;
                            break;
                        }
                        case 10: {
                            httpCode = 401;
                            break;
                        }
                        case 11: {
                            httpCode = 503;
                            break;
                        }
                        default: {
                            httpCode = 500;
                        }
                    }
                    LogUtil.error((Logger)ScepResponder.LOG, (Throwable)ex, (String)auditMessage);
                    auditStatus = AuditStatus.FAILED;
                    var21_30 = new HttpResponse(httpCode);
                }
                ScepResponder.audit(auditService, event, auditLevel, auditStatus, (String)auditMessage);
                return var21_30;
lbl-1000:
                // 1 sources

                {
                    block33: {
                        block32: {
                            respBody = ci.getEncoded();
                            contentType = "application/x-pki-message";
                            ** GOTO lbl-1000
lbl111:
                            // 1 sources

                            if (!Operation.GetCACaps.getCode().equalsIgnoreCase(operation)) break block32;
                            contentType = "text/plain";
                            respBody = this.getCaCaps().getBytes();
                            ** GOTO lbl-1000
                        }
                        if (!Operation.GetCACert.getCode().equalsIgnoreCase(operation)) break block33;
                        contentType = "application/x-x509-ca-ra-cert";
                        respBody = this.getCaCertResp(caName);
                        ** GOTO lbl-1000
                    }
                    if (!Operation.GetNextCACert.getCode().equalsIgnoreCase(operation)) ** GOTO lbl-1000
                    auditMessage = "SCEP operation '" + operation + "' is not permitted";
                    auditStatus = AuditStatus.FAILED;
                    var15_14 = new HttpResponse(403);
                }
                ScepResponder.audit(auditService, event, auditLevel, auditStatus, (String)auditMessage);
                return var15_14;
lbl-1000:
                // 1 sources

                {
                    auditMessage = "unknown SCEP operation '" + operation + "'";
                    auditStatus = AuditStatus.FAILED;
                    var15_15 = new HttpResponse(400);
                }
                ScepResponder.audit(auditService, event, auditLevel, auditStatus, (String)auditMessage);
                return var15_15;
lbl-1000:
                // 3 sources

                {
                    ret = new HttpResponse(200, contentType, null, respBody);
                }
                ScepResponder.audit(auditService, event, auditLevel, auditStatus, (String)auditMessage);
                return ret;
                ScepResponder.audit(auditService, event, auditLevel, auditStatus, (String)auditMessage);
                return ret;
            }
        }
    }

    private static void audit(AuditService auditService, AuditEvent event, AuditLevel auditLevel, AuditStatus auditStatus, String auditMessage) {
        AuditLevel curLevel = event.getLevel();
        if (curLevel == null) {
            event.setLevel(auditLevel);
        } else if (curLevel.getValue() > auditLevel.getValue()) {
            event.setLevel(auditLevel);
        }
        if (auditStatus != null) {
            event.setStatus(auditStatus);
        }
        if (auditMessage != null) {
            event.addEventData("message", (Object)auditMessage);
        }
        event.finish();
        auditService.logEvent(event);
        GatewayUtil.logAuditEvent((Logger)LOG, (AuditEvent)event);
    }

    private byte[] getCaCertResp(String caName) throws OperationException, SdkErrorResponseException {
        try {
            ScepSigner signer = Optional.ofNullable(this.signers.getSigner(caName)).orElseThrow(() -> new OperationException(ErrorCode.PATH_NOT_FOUND, "found na signer for CA " + caName));
            byte[] cacert = Optional.ofNullable(this.sdk.cacert(caName)).orElseThrow(() -> new OperationException(ErrorCode.PATH_NOT_FOUND, "unknown CA " + caName));
            CMSSignedDataGenerator cmsSignedDataGen = new CMSSignedDataGenerator();
            try {
                cmsSignedDataGen.addCertificate(new X509CertificateHolder(Certificate.getInstance((Object)cacert)));
                cmsSignedDataGen.addCertificate(signer.getCert().toBcCert());
                CMSSignedData degenerateSignedData = cmsSignedDataGen.generate((CMSTypedData)new CMSAbsentContent());
                return degenerateSignedData.getEncoded();
            }
            catch (IOException ex) {
                throw new CMSException("could not build CMS SignedDta");
            }
        }
        catch (CMSException ex) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, ex.getMessage());
        }
    }

    private ContentInfo servicePkiOperation(ScepSigner signer, String caName, CMSSignedData requestContent, String certprofileName, AuditEvent event) throws MessageDecodingException, OperationException, SdkErrorResponseException {
        DecodedPkiMessage req = DecodedPkiMessage.decode((CMSSignedData)requestContent, (EnvelopedDataDecryptor)signer.getDecryptor(), null);
        PkiMessage rep = this.servicePkiOperation0(caName, requestContent, req, certprofileName, event);
        ScepResponder.audit(event, NAME_pki_status, rep.getPkiStatus().toString());
        if (rep.getPkiStatus() == PkiStatus.FAILURE) {
            event.setStatus(AuditStatus.FAILED);
        }
        if (rep.getFailInfo() != null) {
            ScepResponder.audit(event, NAME_fail_info, rep.getFailInfo().toString());
        }
        return this.encodeResponse(signer, rep, req);
    }

    private PkiMessage servicePkiOperation0(String caName, CMSSignedData requestContent, DecodedPkiMessage req, String certprofileName, AuditEvent event) throws OperationException, SdkErrorResponseException {
        Args.notNull((Object)requestContent, (String)"requestContent");
        String tid = ((DecodedPkiMessage)Args.notNull((Object)req, (String)"req")).getTransactionId().getId();
        ScepResponder.audit(event, "tid", tid);
        if (req.getFailureMessage() != null) {
            ScepResponder.audit(event, NAME_failure_message, req.getFailureMessage());
        }
        if (!ScepResponder.dfltTrue(req.isSignatureValid())) {
            ScepResponder.audit(event, NAME_signature, "invalid");
        }
        if (!ScepResponder.dfltTrue(req.isDecryptionSuccessful())) {
            ScepResponder.audit(event, NAME_decryption, "failed");
        }
        PkiMessage rep = new PkiMessage(req.getTransactionId(), MessageType.CertRep, Nonce.randomNonce());
        rep.setRecipientNonce(req.getSenderNonce());
        if (req.getFailureMessage() != null) {
            return ScepResponder.fail(rep, FailInfo.badRequest);
        }
        if (!ScepResponder.dfltTrue(req.isSignatureValid())) {
            return ScepResponder.fail(rep, FailInfo.badMessageCheck);
        }
        if (!ScepResponder.dfltTrue(req.isDecryptionSuccessful())) {
            return ScepResponder.fail(rep, FailInfo.badRequest);
        }
        Instant signingTime = req.getSigningTime();
        long maxSigningTimeBiasInMs = 1000L * this.control.getMaxSigningTimeBias();
        if (maxSigningTimeBiasInMs > 0L) {
            boolean isTimeBad;
            boolean bl = isTimeBad = signingTime == null || Math.abs(Instant.now().toEpochMilli() - signingTime.toEpochMilli()) > maxSigningTimeBiasInMs;
            if (isTimeBad) {
                return ScepResponder.fail(rep, FailInfo.badTime);
            }
        }
        HashAlgo hashAlgo = req.getDigestAlgorithm();
        boolean supported = false;
        if (hashAlgo == HashAlgo.SHA1) {
            if (this.caCaps.supportsSHA1()) {
                supported = true;
            }
        } else if (hashAlgo == HashAlgo.SHA256) {
            if (this.caCaps.supportsSHA256()) {
                supported = true;
            }
        } else if (hashAlgo == HashAlgo.SHA512 && this.caCaps.supportsSHA512()) {
            supported = true;
        }
        if (!supported) {
            LOG.warn("tid={}: unsupported digest algorithm {}", (Object)tid, (Object)hashAlgo);
            return ScepResponder.fail(rep, FailInfo.badAlg);
        }
        ASN1ObjectIdentifier encOid = req.getContentEncryptionAlgorithm();
        if (CMSAlgorithm.DES_EDE3_CBC.equals((ASN1Primitive)encOid)) {
            if (!this.caCaps.supportsDES3()) {
                LOG.warn("tid={}: encryption with DES3 algorithm {} is not permitted", (Object)tid, (Object)encOid);
                return ScepResponder.fail(rep, FailInfo.badAlg);
            }
        } else if (CMSAlgorithm.AES128_CBC.equals((ASN1Primitive)encOid)) {
            if (!this.caCaps.supportsAES()) {
                LOG.warn("tid={}: encryption with AES algorithm {} is not permitted", (Object)tid, (Object)encOid);
                return ScepResponder.fail(rep, FailInfo.badAlg);
            }
        } else {
            LOG.warn("tid={}: encryption with algorithm {} is not permitted", (Object)tid, (Object)encOid);
            return ScepResponder.fail(rep, FailInfo.badAlg);
        }
        try {
            SignedData signedData;
            MessageType mt = req.getMessageType();
            ScepResponder.audit(event, NAME_message_type, mt.toString());
            Requestor.CertRequestor requestor = null;
            switch (mt) {
                case PKCSReq: 
                case RenewalReq: {
                    CertificationRequest csr = GatewayUtil.parseCsrInRequest((ASN1Encodable)req.getMessageData());
                    X500Name reqSubject = csr.getCertificationRequestInfo().getSubject();
                    if (LOG.isInfoEnabled()) {
                        LOG.info("tid={}, subject={}", (Object)tid, (Object)X509Util.x500NameText((X500Name)reqSubject));
                    }
                    event.addEventData("certprofile", (Object)certprofileName);
                    event.addEventData("req_subject", (Object)("\"" + X509Util.x500NameText((X500Name)reqSubject) + "\""));
                    if (!GatewayUtil.verifyCsr((CertificationRequest)csr, (SecurityFactory)this.securityFactory, (PopControl)this.popControl)) {
                        LOG.warn("tid={} POP verification failed", (Object)tid);
                        throw FailInfoException.BAD_MESSAGE_CHECK;
                    }
                    CertificationRequestInfo csrReqInfo = csr.getCertificationRequestInfo();
                    X509Cert reqSignatureCert = req.getSignatureCert();
                    if (reqSignatureCert.isSelfSigned() && !reqSignatureCert.getSubject().equals((Object)csrReqInfo.getSubject())) {
                        LOG.warn("tid={}, self-signed identityCert.subject ({}) != csr.subject ({})", new Object[]{tid, reqSignatureCert.getSubject(), csrReqInfo.getSubject()});
                        throw FailInfoException.BAD_REQUEST;
                    }
                    if (X509Util.getCommonName((X500Name)csrReqInfo.getSubject()) == null) {
                        throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "tid=" + tid + ": no CommonName in requested subject");
                    }
                    String challengePwd = X509Util.getChallengePassword((CertificationRequestInfo)csrReqInfo);
                    if (challengePwd != null) {
                        boolean authorized;
                        String[] strs = challengePwd.split(":");
                        if (strs.length != 2) {
                            LOG.warn("tid={}: challengePassword does not have the format <user>:<password>", (Object)tid);
                            throw FailInfoException.BAD_REQUEST;
                        }
                        String user = strs[0];
                        String password = strs[1];
                        Requestor.PasswordRequestor requestor0 = this.getRequestor(user);
                        requestor = requestor0;
                        boolean bl = authorized = requestor0 != null && requestor0.authenticate(password.getBytes(StandardCharsets.UTF_8));
                        if (!authorized) {
                            LOG.warn("tid={}: could not authenticate user {}", (Object)tid, (Object)user);
                            throw FailInfoException.BAD_REQUEST;
                        }
                    }
                    if (reqSignatureCert.isSelfSigned()) {
                        if (MessageType.PKCSReq != mt) {
                            LOG.warn("tid={}: self-signed certificate is not permitted for messageType {}", (Object)tid, (Object)mt);
                            throw FailInfoException.BAD_REQUEST;
                        }
                        if (requestor == null) {
                            LOG.warn("tid={}: could not extract user & password from challengePassword, which are required for self-signed signature certificate", (Object)tid);
                            throw FailInfoException.BAD_REQUEST;
                        }
                    } else if (requestor == null && (requestor = this.getRequestor(reqSignatureCert)) == null) {
                        LOG.warn("tid={}: signature certificate is not trusted by the CA", (Object)tid);
                        throw FailInfoException.BAD_REQUEST;
                    }
                    ScepResponder.checkUserPermission((Requestor)requestor, caName, certprofileName);
                    Extensions extensions = X509Util.getExtensions((CertificationRequestInfo)csrReqInfo);
                    EnrollCertRequestEntry template = new EnrollCertRequestEntry();
                    template.setCertprofile(certprofileName);
                    template.setSubject(new X500NameType(csrReqInfo.getSubject()));
                    try {
                        template.extensions(extensions);
                    }
                    catch (IOException e) {
                        LogUtil.warn((Logger)LOG, (Throwable)e, (String)"could not encode extensions");
                        throw FailInfoException.BAD_REQUEST;
                    }
                    try {
                        template.subjectPublicKey(csrReqInfo.getSubjectPublicKeyInfo());
                    }
                    catch (IOException e) {
                        LogUtil.warn((Logger)LOG, (Throwable)e, (String)"could not encode SubjectPublicKeyInfo");
                        throw FailInfoException.BAD_REQUEST;
                    }
                    EnrollCertsRequest sdkReq = new EnrollCertsRequest();
                    sdkReq.setEntries(new EnrollCertRequestEntry[]{template});
                    sdkReq.setTransactionId(tid);
                    sdkReq.setExplicitConfirm(Boolean.valueOf(false));
                    CertsMode certsMode = this.control.isIncludeCertChain() ? CertsMode.CHAIN : (this.control.isIncludeCaCert() ? CertsMode.CERT : CertsMode.NONE);
                    sdkReq.setCaCertMode(certsMode);
                    signedData = this.buildSignedData(this.sdk.enrollCerts(caName, sdkReq));
                    break;
                }
                case CertPoll: {
                    IssuerAndSubject is = IssuerAndSubject.getInstance((Object)req.getMessageData());
                    ScepResponder.audit(event, "issuer", "\"" + X509Util.x500NameText((X500Name)is.getIssuer()) + "\"");
                    ScepResponder.audit(event, "subject", "\"" + X509Util.x500NameText((X500Name)is.getSubject()) + "\"");
                    PollCertRequestEntry template = new PollCertRequestEntry(null, new X500NameType(is.getSubject()));
                    PollCertRequest sdkReq = new PollCertRequest(null, new X500NameType(is.getIssuer()), null, req.getTransactionId().getId(), new PollCertRequestEntry[]{template});
                    signedData = this.buildSignedData(this.sdk.pollCerts(sdkReq));
                    break;
                }
                case GetCert: {
                    IssuerAndSerialNumber isn = IssuerAndSerialNumber.getInstance((Object)req.getMessageData());
                    BigInteger serial = isn.getSerialNumber().getPositiveValue();
                    ScepResponder.audit(event, "issuer", "\"" + X509Util.x500NameText((X500Name)isn.getName()) + "\"");
                    ScepResponder.audit(event, "serial", LogUtil.formatCsn((BigInteger)serial));
                    signedData = this.getCert(caName, isn.getName(), serial);
                    break;
                }
                case GetCRL: {
                    IssuerAndSerialNumber isn = IssuerAndSerialNumber.getInstance((Object)req.getMessageData());
                    BigInteger serial = isn.getSerialNumber().getPositiveValue();
                    ScepResponder.audit(event, "issuer", "\"" + X509Util.x500NameText((X500Name)isn.getName()) + "\"");
                    ScepResponder.audit(event, "serial", LogUtil.formatCsn((BigInteger)serial));
                    signedData = this.getCrl(caName, isn.getName(), serial);
                    break;
                }
                default: {
                    LOG.error("unknown SCEP messageType '{}'", (Object)req.getMessageType());
                    throw FailInfoException.BAD_REQUEST;
                }
            }
            rep.setMessageData((ASN1Encodable)new ContentInfo(CMSObjectIdentifiers.signedData, (ASN1Encodable)signedData));
            rep.setPkiStatus(PkiStatus.SUCCESS);
            return rep;
        }
        catch (FailInfoException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            return ScepResponder.fail(rep, ex.getFailInfo());
        }
    }

    private SignedData getCert(String caName, X500Name issuer, BigInteger serialNumber) throws FailInfoException, OperationException, SdkErrorResponseException {
        byte[] encodedCert = this.sdk.getCert(caName, issuer, serialNumber);
        if (encodedCert == null) {
            throw FailInfoException.BAD_CERTID;
        }
        return this.buildSignedData(encodedCert, null);
    }

    private SignedData buildSignedData(EnrollOrPollCertsResponse sdkResp) throws OperationException {
        int n;
        EnrollOrPullCertResponseEntry[] entries = sdkResp.getEntries();
        int n2 = n = entries == null ? 0 : entries.length;
        if (n != 1) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, "expected 1 cert, but received " + n);
        }
        EnrollOrPullCertResponseEntry entry = entries[0];
        byte[] cert = Optional.ofNullable(entry.getCert()).orElseThrow(() -> new OperationException(ErrorCode.ofCode((int)entry.getError().getCode()), "expected 1 cert, but received none"));
        return this.buildSignedData(cert, sdkResp.getExtraCerts());
    }

    private SignedData buildSignedData(byte[] cert, byte[][] extraCerts) throws OperationException {
        CMSSignedDataGenerator cmsSignedDataGen = new CMSSignedDataGenerator();
        try {
            cmsSignedDataGen.addCertificate(new X509CertificateHolder(Certificate.getInstance((Object)cert)));
            if (extraCerts != null) {
                for (byte[] c : extraCerts) {
                    cmsSignedDataGen.addCertificate(new X509CertificateHolder(Certificate.getInstance((Object)c)));
                }
            }
            return SignedData.getInstance((Object)cmsSignedDataGen.generate((CMSTypedData)new CMSAbsentContent()).toASN1Structure().getContent());
        }
        catch (CMSException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
        }
    }

    private SignedData getCrl(String caName, X500Name issuer, BigInteger serialNumber) throws FailInfoException, OperationException, SdkErrorResponseException {
        CMSSignedData signedData;
        if (!this.control.isSupportGetCrl()) {
            throw FailInfoException.BAD_REQUEST;
        }
        byte[] crl = this.sdk.currentCrl(caName);
        if (crl == null) {
            LOG.error("found no CRL");
            throw FailInfoException.BAD_REQUEST;
        }
        CMSSignedDataGenerator cmsSignedDataGen = new CMSSignedDataGenerator();
        cmsSignedDataGen.addCRL(new X509CRLHolder(CertificateList.getInstance((Object)crl)));
        try {
            signedData = cmsSignedDataGen.generate((CMSTypedData)new CMSAbsentContent());
        }
        catch (CMSException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not generate CMSSignedData");
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, (Throwable)ex);
        }
        return SignedData.getInstance((Object)signedData.toASN1Structure().getContent());
    }

    private ContentInfo encodeResponse(ScepSigner signer, PkiMessage response, DecodedPkiMessage request) throws OperationException {
        ContentInfo ci;
        Args.notNull((Object)response, (String)"response");
        Args.notNull((Object)request, (String)"request");
        String algorithm = signer.getKey().getAlgorithm();
        if (!"RSA".equalsIgnoreCase(algorithm)) {
            throw new UnsupportedOperationException("getSignatureAlgorithm() for non-RSA is not supported yet.");
        }
        HashAlgo hashAlgo = request.getDigestAlgorithm();
        try {
            X509Cert[] x509CertArray;
            SignAlgo signatureAlgorithm = SignAlgo.getInstance((String)(hashAlgo.getJceName() + "withRSA"));
            if (this.control.isIncludeSignerCert()) {
                X509Cert[] x509CertArray2 = new X509Cert[1];
                x509CertArray = x509CertArray2;
                x509CertArray2[0] = signer.getCert();
            } else {
                x509CertArray = null;
            }
            X509Cert[] cmsCertSet = x509CertArray;
            ci = response.encode(signer.getKey(), signatureAlgorithm, signer.getCert(), cmsCertSet, request.getSignatureCert(), request.getContentEncryptionAlgorithm());
        }
        catch (NoSuchAlgorithmException | MessageEncodingException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not encode response");
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, ex);
        }
        return ci;
    }

    private static void checkUserPermission(Requestor requestor, String caName, String certprofile) throws OperationException {
        Requestor.Permission permission = Requestor.Permission.ENROLL_CERT;
        if (!requestor.isPermitted(permission)) {
            throw new OperationException(ErrorCode.NOT_PERMITTED, permission + " is not permitted for user " + requestor.getName());
        }
        if (!requestor.isCertprofilePermitted(caName, certprofile)) {
            throw new OperationException(ErrorCode.NOT_PERMITTED, "Certificate profile " + certprofile + " is not permitted for user " + requestor.getName());
        }
    }

    private static void audit(AuditEvent audit, String name, String value) {
        audit.addEventData(name, (Object)(value == null ? "null" : value));
    }

    private static PkiMessage fail(PkiMessage rep, FailInfo failInfo) {
        rep.setPkiStatus(PkiStatus.FAILURE);
        rep.setFailInfo(FailInfo.badMessageCheck);
        return rep;
    }

    private static boolean dfltTrue(Boolean b) {
        return b == null || b != false;
    }

    static {
        LOG.info("XiPKI SCEP-Gateway version {}", (Object)StringUtil.getBundleVersion(ScepResponder.class));
    }

    private static class FailInfoException
    extends Exception {
        public static final FailInfoException BAD_CERTID = new FailInfoException(FailInfo.badCertId);
        public static final FailInfoException BAD_MESSAGE_CHECK = new FailInfoException(FailInfo.badMessageCheck);
        public static final FailInfoException BAD_REQUEST = new FailInfoException(FailInfo.badRequest);
        private final FailInfo failInfo;

        private FailInfoException(FailInfo failInfo) {
            super(((FailInfo)Args.notNull((Object)failInfo, (String)"failInfo")).name());
            this.failInfo = failInfo;
        }

        public FailInfo getFailInfo() {
            return this.failInfo;
        }
    }
}

