/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.exception.InvalidConfException;

public class CaNameSigners {
    private final ConcurrentContentSigner defaultSigner;
    private final Map<String, ConcurrentContentSigner> signers;

    public CaNameSigners(ConcurrentContentSigner defaultSigner, Map<String, ConcurrentContentSigner> signers) throws InvalidConfException {
        if (defaultSigner == null && CollectionUtil.isEmpty(signers)) {
            throw new InvalidConfException("At least one of defaultSigner and signers must be set");
        }
        this.defaultSigner = defaultSigner;
        if (signers == null) {
            this.signers = null;
        } else {
            this.signers = new HashMap<String, ConcurrentContentSigner>(signers.size() * 3 / 2);
            for (Map.Entry<String, ConcurrentContentSigner> m : signers.entrySet()) {
                String name = m.getKey().toLowerCase(Locale.ROOT);
                if (this.signers.containsKey(name)) {
                    throw new InvalidConfException("at least two signers for the CA " + name + " are set");
                }
                this.signers.put(m.getKey().toLowerCase(Locale.ROOT), m.getValue());
            }
        }
    }

    public ConcurrentContentSigner getSigner(String caName) {
        ConcurrentContentSigner signer;
        String loName = Args.toNonBlankLower((String)caName, (String)"caName");
        if (this.signers != null && (signer = this.signers.get(loName)) != null) {
            return signer;
        }
        return this.defaultSigner;
    }

    public ConcurrentContentSigner getDefaultSigner() {
        return this.defaultSigner;
    }

    public Set<String> signerNames() {
        return this.signers == null ? Collections.emptySet() : this.signers.keySet();
    }
}

