/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.shell;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.shell.XiAction;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.Curl;
import org.xipki.util.FileUtils;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class Actions {

    @Command(scope="xi", name="exec", description="execute terminal")
    @Service
    public static class ExecTerminalCommand
    extends XiAction {
        @Argument(name="terminal command", required=true, description="Terminal command")
        @Completion(value=FileCompleter.class)
        private String command;
        @Option(name="--ignore-error", description="whether ignores error")
        private Boolean ignoreError;

        @Override
        protected Object execute0() throws Exception {
            System.out.println("Executing command '" + this.command + "'");
            this.command = IoUtil.expandFilepath((String)this.command, (boolean)false);
            Process process = Runtime.getRuntime().exec(this.command);
            int status = process.waitFor();
            System.out.write(IoUtil.readAllBytes((InputStream)process.getInputStream()));
            if (status != 0) {
                System.err.write(IoUtil.readAllBytes((InputStream)process.getErrorStream()));
                if (this.ignoreError == null || !this.ignoreError.booleanValue()) {
                    throw new Exception("process exited with status " + status);
                }
            }
            return null;
        }
    }

    @Command(scope="xi", name="osinfo", description="get info of operation system")
    @Service
    public static class OsInfo
    extends XiAction {
        @Option(name="--name", aliases={"-n"}, description="output OS name")
        private Boolean printName;
        @Option(name="--arch", aliases={"-a"}, description="output OS arch")
        private Boolean printArch;

        @Override
        protected Object execute0() throws Exception {
            boolean bArch;
            String name = System.getProperty("os.name").toLowerCase(Locale.ROOT);
            if (name.startsWith("windows")) {
                name = "windows";
            } else if (name.startsWith("linux")) {
                name = "linux";
            } else if (name.startsWith("mac os x")) {
                name = "macosx";
            }
            String arch = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
            if (this.printName == null && this.printArch == null) {
                return name + "/" + arch;
            }
            boolean bName = this.printName != null && this.printName != false;
            boolean bl = bArch = this.printArch != null && this.printArch != false;
            if (bName && bArch) {
                return name + "/" + arch;
            }
            if (bName) {
                return name;
            }
            if (bArch) {
                return arch;
            }
            return "";
        }
    }

    @Command(scope="xi", name="datetime", description="get current date-time")
    @Service
    public static class DateTime
    extends XiAction {
        @Argument(name="format", description="format")
        @Completion(value=FileCompleter.class)
        private String format = "yyyyMMdd-HHmmss";

        @Override
        protected Object execute0() throws Exception {
            return new SimpleDateFormat(this.format).format(Instant.now());
        }
    }

    @Command(scope="xi", name="rm", description="remove file or directory")
    @Service
    public static class Rm
    extends XiAction {
        @Argument(index=0, name="file", required=true, description="file or directory to be deleted")
        @Completion(value=FileCompleter.class)
        private String targetPath;
        @Option(name="--recursive", aliases={"-r"}, description="remove directories and their contents recursively")
        private Boolean recursive = Boolean.FALSE;
        @Option(name="--force", aliases={"-f"}, description="remove files without prompt")
        private Boolean force = Boolean.FALSE;

        @Override
        protected Object execute0() throws Exception {
            this.targetPath = Rm.expandFilepath(this.targetPath);
            File target = new File(this.targetPath);
            if (!target.exists()) {
                return null;
            }
            if (target.isDirectory()) {
                if (!this.recursive.booleanValue()) {
                    this.println("Please use option --recursive to delete directory");
                    return null;
                }
                if (this.force.booleanValue() || this.confirm("Do you want to remove directory " + this.targetPath, 3)) {
                    FileUtils.deleteDirectory((File)target);
                    this.println("removed directory " + this.targetPath);
                }
            } else if (this.force.booleanValue() || this.confirm("Do you want to remove file " + this.targetPath, 3)) {
                IoUtil.deleteFile0((File)target);
                this.println("removed file " + this.targetPath);
            }
            return null;
        }
    }

    @Command(scope="xi", name="replace", description="replace text in file")
    @Service
    public static class Replace
    extends XiAction {
        @Argument(index=0, name="file", required=true, description="file")
        @Completion(value=FileCompleter.class)
        private String source;
        @Option(name="--old", required=true, description="text to be replaced")
        private String oldText;
        @Option(name="--new", required=true, description="next text")
        private String newText;

        @Override
        protected Object execute0() throws Exception {
            File sourceFile = new File(Replace.expandFilepath(this.source));
            if (!sourceFile.exists()) {
                System.err.println(this.source + " does not exist");
                return null;
            }
            if (!sourceFile.isFile()) {
                System.err.println(this.source + " is not a file");
                return null;
            }
            Args.notBlank((String)this.oldText, (String)"oldText");
            this.replaceFile(sourceFile, this.oldText, this.newText);
            return null;
        }

        private void replaceFile(File file, String oldText, String newText) throws Exception {
            boolean changed = false;
            byte[] newBytes = null;
            try (BufferedReader reader = Files.newBufferedReader(file.toPath());
                 ByteArrayOutputStream writer = new ByteArrayOutputStream();){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.contains(oldText)) {
                        changed = true;
                        writer.write(StringUtil.toUtf8Bytes((String)line.replace(oldText, newText)));
                    } else {
                        writer.write(StringUtil.toUtf8Bytes((String)line));
                    }
                    writer.write(10);
                }
                if (changed) {
                    newBytes = writer.toByteArray();
                }
            }
            if (changed) {
                IoUtil.save((File)new File(file.getPath()), (byte[])newBytes);
            }
        }
    }

    @Command(scope="xi", name="move-file", description="move file")
    @Service
    public static class MoveFile
    extends XiAction {
        @Argument(index=0, name="source-file", required=true, description="file to be moved")
        @Completion(value=FileCompleter.class)
        private String source;
        @Argument(index=1, name="destination", required=true, description="destination file")
        @Completion(value=FileCompleter.class)
        private String dest;
        @Option(name="--force", aliases={"-f"}, description="override existing file, never prompt")
        private Boolean force = Boolean.FALSE;

        @Override
        protected Object execute0() throws Exception {
            this.source = MoveFile.expandFilepath(this.source);
            this.dest = MoveFile.expandFilepath(this.dest);
            File sourceFile = new File(this.source);
            if (!sourceFile.exists()) {
                throw new IllegalCmdParamException(this.source + " does not exist");
            }
            if (!sourceFile.isFile()) {
                throw new IllegalCmdParamException(this.source + " is not a file");
            }
            File destFile = new File(this.dest);
            if (destFile.exists()) {
                if (!destFile.isFile()) {
                    throw new IllegalCmdParamException("cannot override an existing directory by a file");
                }
                if (!this.force.booleanValue() && !this.confirm("Do you want to override the file " + this.dest, 3)) {
                    return null;
                }
            } else {
                IoUtil.mkdirsParent((Path)destFile.toPath());
            }
            FileUtils.copyFile((File)sourceFile, (File)destFile, (boolean)true);
            IoUtil.deleteFile0((File)sourceFile);
            return null;
        }
    }

    @Command(scope="xi", name="move-dir", description="move content of the directory to destination")
    @Service
    public static class MoveDir
    extends XiAction {
        @Argument(index=0, name="source", required=true, description="content of this directory will be copied")
        @Completion(value=Completers.DirCompleter.class)
        private String source;
        @Argument(index=1, name="destination", required=true, description="destination directory")
        @Completion(value=Completers.DirCompleter.class)
        private String dest;

        @Override
        protected Object execute0() throws Exception {
            this.source = MoveDir.expandFilepath(this.source);
            this.dest = MoveDir.expandFilepath(this.dest);
            File sourceDir = new File(this.source);
            if (!sourceDir.exists()) {
                throw new IllegalCmdParamException(this.source + " does not exist");
            }
            if (!sourceDir.isDirectory()) {
                throw new IllegalCmdParamException(this.source + " is not a directory");
            }
            File destDir = new File(this.dest);
            if (destDir.exists()) {
                if (destDir.isFile()) {
                    throw new IllegalCmdParamException(this.dest + " is not a directory");
                }
            } else {
                IoUtil.mkdirs((File)destDir);
            }
            FileUtils.copyDirectory((File)sourceDir, (File)destDir);
            FileUtils.deleteDirectory((File)sourceDir);
            return null;
        }
    }

    @Command(scope="xi", name="mkdir", description="make directories")
    @Service
    public static class Mkdir
    extends XiAction {
        @Argument(index=0, name="directory", required=true, description="directory to be created")
        @Completion(value=Completers.DirCompleter.class)
        private String dirName;

        @Override
        protected Object execute0() throws Exception {
            File target = new File(Mkdir.expandFilepath(this.dirName));
            try {
                IoUtil.mkdirs((File)target);
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
            return null;
        }
    }

    @Command(scope="xi", name="curl", description="transfer a URL")
    @Service
    public static class Curl
    extends XiAction {
        @Argument(index=0, name="url", required=true, description="URL")
        private String url;
        @Option(name="--verbose", aliases={"-v"}, description="show request and response verbosely")
        private Boolean verbose = Boolean.FALSE;
        @Option(name="--post", aliases={"-p"}, description="send the request via HTTP POST")
        private Boolean usePost = Boolean.FALSE;
        @Option(name="--data", aliases={"-d"}, description="data to be sent in a POST request")
        private String postData;
        @Option(name="--data-charset", aliases={"-c"}, description="charset of data")
        private String postDataCharSet = "UTF-8";
        @Option(name="--data-file", description="file contains the data to be sent in a POST request")
        @Completion(value=FileCompleter.class)
        private String postDataFile;
        @Option(name="--out", description="where to save the response")
        @Completion(value=FileCompleter.class)
        private String outFile;
        @Option(name="--header", aliases={"-h"}, multiValued=true, description="header in request")
        private List<String> headers;
        @Option(name="--user", aliases={"-u"}, description="User and password of the form user:password")
        private String userPassword;
        @Option(name="--base64", description="Base64-encode the content")
        private boolean base64;
        @Reference
        private org.xipki.util.Curl curl;

        @Override
        protected Object execute0() throws Exception {
            Curl.CurlResult result;
            HashMap<String, String> headerNameValues;
            byte[] content = null;
            if (this.postData != null) {
                content = this.postData.getBytes(this.postDataCharSet);
            } else if (this.postDataFile != null) {
                content = IoUtil.read((String)this.postDataFile);
            }
            if (content != null) {
                this.usePost = Boolean.TRUE;
            }
            HashMap<String, String> hashMap = headerNameValues = this.base64 || this.headers != null ? new HashMap<String, String>() : null;
            if (this.headers != null) {
                for (String header : this.headers) {
                    int idx = header.indexOf(58);
                    if (idx == -1 || idx == header.length() - 1) {
                        throw new IllegalCmdParamException("invalid HTTP header: '" + header + "'");
                    }
                    String key = header.substring(0, idx);
                    String value = header.substring(idx + 1).trim();
                    headerNameValues.put(key, value);
                }
            }
            if (this.base64) {
                headerNameValues.put("Content-Transfer-Encoding", "base64");
                if (content != null) {
                    content = Base64.encodeToByte((byte[])content, (boolean)true);
                }
            }
            Curl.CurlResult curlResult = result = this.usePost != false ? this.curl.curlPost(this.url, this.verbose.booleanValue(), headerNameValues, this.userPassword, content) : this.curl.curlGet(this.url, this.verbose.booleanValue(), headerNameValues, this.userPassword);
            if (result.getContent() == null && result.getErrorContent() == null) {
                this.println("NO response content");
                return null;
            }
            if (this.outFile != null) {
                if (result.getContent() != null) {
                    this.saveVerbose("saved response to file", this.outFile, result.getContent());
                } else {
                    this.saveVerbose("saved (error) response to file", "error-" + this.outFile, result.getErrorContent());
                }
            } else {
                String ct = result.getContentType();
                String charset = Curl.getCharset(ct);
                if (charset == null) {
                    charset = "UTF-8";
                }
                if (result.getContent() != null) {
                    this.println(new String(result.getContent(), charset));
                } else {
                    this.println("ERROR: ");
                    this.println(new String(result.getContent(), charset));
                }
            }
            return null;
        }

        private static String getCharset(String contentType) {
            if (StringUtil.isBlank((String)contentType) || contentType.indexOf(59) == -1) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(contentType, ";");
            st.nextToken();
            while (st.hasMoreTokens()) {
                String paramName;
                String token = st.nextToken();
                int idx = token.indexOf(61);
                if (idx == -1 || !"charset".equalsIgnoreCase(paramName = token.substring(0, idx).trim())) continue;
                return token.substring(idx + 1);
            }
            return null;
        }
    }

    @Command(scope="xi", name="base64", description="Base64 encode / decode")
    @Service
    public static class Base64EnDecode
    extends XiAction {
        @Option(name="--decode", aliases={"-d"}, description="Decode")
        private boolean decode = false;
        @Argument(index=0, name="source", required=true, description="source file")
        @Completion(value=FileCompleter.class)
        private String source;
        @Argument(index=1, name="destination", required=true, description="destination file")
        @Completion(value=FileCompleter.class)
        private String dest;

        @Override
        protected Object execute0() throws Exception {
            this.source = Base64EnDecode.expandFilepath(this.source);
            this.dest = Base64EnDecode.expandFilepath(this.dest);
            File sourceFile = new File(this.source);
            if (!sourceFile.exists()) {
                throw new IllegalCmdParamException(this.source + " does not exist");
            }
            if (!sourceFile.isFile()) {
                throw new IllegalCmdParamException(this.source + " is not a file");
            }
            byte[] sourceBytes = IoUtil.read((File)sourceFile);
            byte[] targetBytes = this.decode ? Base64.decode((byte[])sourceBytes) : Base64.encodeToByte((byte[])sourceBytes, (boolean)true);
            IoUtil.save((String)this.dest, (byte[])targetBytes);
            return null;
        }
    }

    @Command(scope="xi", name="file-exists", description="test whether file or folder exists")
    @Service
    public static class FileExists
    extends XiAction {
        @Argument(name="target", required=true, description="file or dir to be checked")
        @Completion(value=FileCompleter.class)
        private String target;

        @Override
        protected Object execute0() throws Exception {
            return new File(this.target).exists();
        }
    }

    @Command(scope="xi", name="copy-file", description="copy file")
    @Service
    public static class CopyFile
    extends XiAction {
        @Argument(index=0, name="files or dir", multiValued=true, required=true, description="The last one is the destination file or dir (ending with '/'),\nthe remaining are the files to be copied")
        @Completion(value=FileCompleter.class)
        private List<String> files;
        @Option(name="--force", aliases={"-f"}, description="override existing file, never prompt")
        private Boolean force = Boolean.FALSE;

        @Override
        protected Object execute0() throws Exception {
            boolean isDestDir;
            int n = this.files.size();
            if (n < 2) {
                throw new IllegalCmdParamException("too less parameters");
            }
            String dest = this.files.get(n - 1);
            File destObj = new File(dest = CopyFile.expandFilepath(dest));
            boolean destExists = destObj.exists();
            if (destExists) {
                isDestDir = destObj.isDirectory();
            } else if (n > 2) {
                isDestDir = true;
            } else {
                char c = dest.charAt(dest.length() - 1);
                boolean bl = isDestDir = c == '\\' || c == '/';
            }
            if (n > 2 && !isDestDir) {
                throw new IllegalCmdParamException(dest + " is not a folder");
            }
            ArrayList<File> sourceFiles = new ArrayList<File>(n - 1);
            for (int i = 0; i < n - 1; ++i) {
                String source = CopyFile.expandFilepath(this.files.get(i));
                File sourceFile = new File(source);
                if (!sourceFile.exists()) {
                    throw new IllegalCmdParamException(source + " does not exist");
                }
                if (!sourceFile.isFile()) {
                    throw new IllegalCmdParamException(source + " is not a file");
                }
                sourceFiles.add(sourceFile);
            }
            if (isDestDir) {
                for (File sourceFile : sourceFiles) {
                    this.copyFile(sourceFile, new File(dest, sourceFile.getName()));
                }
            } else {
                this.copyFile((File)sourceFiles.get(0), new File(dest));
            }
            return null;
        }

        private void copyFile(File sourceFile, File destFile) throws IllegalCmdParamException, IOException {
            if (destFile.exists()) {
                if (!destFile.isFile()) {
                    throw new IllegalCmdParamException("cannot override an existing directory by a file");
                }
                if (!this.force.booleanValue() && !this.confirm("Do you want to override the file " + destFile.getPath(), 3)) {
                    return;
                }
            } else {
                IoUtil.mkdirsParent((Path)destFile.toPath());
            }
            FileUtils.copyFile((File)sourceFile, (File)destFile, (boolean)true);
        }
    }

    @Command(scope="xi", name="copy-dir", description="copy content of the directory to destination")
    @Service
    public static class CopyDir
    extends XiAction {
        @Argument(index=0, name="source", required=true, description="content of this directory will be copied")
        @Completion(value=Completers.DirCompleter.class)
        private String source;
        @Argument(index=1, name="destination", required=true, description="destination directory")
        @Completion(value=Completers.DirCompleter.class)
        private String dest;

        @Override
        protected Object execute0() throws Exception {
            this.source = CopyDir.expandFilepath(this.source);
            this.dest = CopyDir.expandFilepath(this.dest);
            File sourceDir = new File(this.source);
            if (!sourceDir.exists()) {
                throw new IllegalCmdParamException(this.source + " does not exist");
            }
            if (!sourceDir.isDirectory()) {
                throw new IllegalCmdParamException(this.source + " is not a directory");
            }
            File destDir = new File(this.dest);
            IoUtil.mkdirs((File)destDir);
            FileUtils.copyDirectory((File)sourceDir, (File)destDir);
            return null;
        }
    }

    @Command(scope="xi", name="confirm", description="confirm an action")
    @Service
    public static class Confirm
    extends XiAction {
        @Argument(index=0, name="message", required=true, description="prompt message")
        private String prompt;

        @Override
        protected Object execute0() throws Exception {
            boolean toContinue = this.confirm(this.prompt + "\nDo you want to continue", 3);
            if (!toContinue) {
                throw new CmdFailure("User cancelled");
            }
            return null;
        }
    }
}

