/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.audit.services;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditService;
import org.xipki.audit.PciAuditEvent;
import org.xipki.util.Base64;
import org.xipki.util.ConfPairs;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;

public abstract class MacAuditService
implements AuditService {
    public static final String KEY_SHARD_ID = "shard-id";
    public static final String KEY_ALGO = "algo";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_KEYID = "keyid";
    public static final String KEY_OLD_PASSWORD = "old-password";
    public static final String KEY_OLD_KEYID = "old-keyid";
    public static final String KEY_ENC_INTERVAL = "enc-interval";
    private static final int ALGO_ID_HMAC_SHA256 = 1;
    private static final String VERSION_V1 = "v1";
    protected static final String DELIM = ";";
    private static final String INNER_DELIM = ":";
    private static final Logger LOG = LoggerFactory.getLogger(MacAuditService.class);
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("yyyy.MM.dd-HH:mm:ss.SSS");
    private final ZoneId timeZone = ZoneId.systemDefault();
    protected int shardId;
    protected final AtomicLong id = new AtomicLong(0L);
    protected String previousTag;
    private String tagPrefix;
    private byte[] tagPrefixBytes;
    private String keyId;
    private SecureRandom rnd;
    private SecretKey encKey;
    private Mac mac;
    private Cipher cipher;
    private int encInterval;

    protected String formatDate(Instant date) {
        return DTF.format(date.atZone(this.timeZone));
    }

    private String buildMacPayload(Instant date, long thisId, int eventType, String levelText, long previousId, String previousTag, String message) {
        return this.formatDate(date) + DELIM + levelText + DELIM + eventType + DELIM + this.shardId + DELIM + thisId + DELIM + previousId + INNER_DELIM + (previousTag == null ? "" : previousTag) + DELIM + message;
    }

    protected abstract void storeLog(Instant var1, long var2, int var4, String var5, long var6, String var8, String var9);

    protected abstract void storeIntegrity(String var1);

    protected abstract void doClose() throws Exception;

    protected void doExtraInit(ConfPairs confPairs) throws InvalidConfException {
    }

    protected void verify(long id, String tag, String integrityText, ConfPairs confPairs) {
        String plaintext;
        SecretKey decryptionKey;
        if (id == 0L) {
            if (StringUtil.isBlank((String)integrityText)) {
                return;
            }
            throw new IllegalStateException("audit entry deleted unexpectedly");
        }
        if (StringUtil.isBlank((String)integrityText)) {
            throw new IllegalStateException("integrityText deleted unexpectedly");
        }
        StringTokenizer tokenizer = new StringTokenizer(integrityText, DELIM);
        String version = tokenizer.nextToken();
        if (!VERSION_V1.equalsIgnoreCase(version)) {
            throw new IllegalStateException("unknown version " + version);
        }
        String thisKeyId = tokenizer.nextToken();
        byte[] iv = Base64.decodeFast((String)tokenizer.nextToken());
        byte[] cipherText = Base64.decodeFast((String)tokenizer.nextToken());
        if (this.keyId.equals(thisKeyId)) {
            decryptionKey = this.encKey;
        } else {
            String oldKeyId = confPairs.value(KEY_OLD_KEYID);
            if (!thisKeyId.equals(oldKeyId)) {
                throw new IllegalStateException("found no key to decrypt the integrityText");
            }
            String password = confPairs.value(KEY_OLD_PASSWORD);
            try {
                SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
                char[] passwordChars = password.toCharArray();
                PBEKeySpec spec = new PBEKeySpec(passwordChars, "ENC".getBytes(StandardCharsets.UTF_8), 10000, 256);
                decryptionKey = factory.generateSecret(spec);
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
                throw new IllegalStateException("error deriving key", ex);
            }
        }
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        try {
            this.cipher.init(2, (Key)decryptionKey, spec);
            plaintext = new String(this.cipher.doFinal(cipherText));
        }
        catch (Exception ex) {
            throw new IllegalStateException("error while decrypting the integrityText");
        }
        tokenizer = new StringTokenizer(plaintext, DELIM);
        version = tokenizer.nextToken();
        if (!VERSION_V1.equalsIgnoreCase(version)) {
            throw new IllegalStateException("unknown version " + version);
        }
        int integrityShardId = Integer.parseInt(tokenizer.nextToken());
        long integrityId = Long.parseLong(tokenizer.nextToken());
        String thisTag = tokenizer.nextToken();
        if (integrityShardId != this.shardId) {
            throw new IllegalStateException(String.format("shardId in integrityText (%d) != configured shardId (%d)", integrityShardId, this.shardId));
        }
        if (integrityId == id) {
            if (!tag.equals(thisTag)) {
                throw new IllegalStateException("tag in integrityText does not match the audit entry.");
            }
        } else {
            if (integrityId > id) {
                throw new IllegalStateException(String.format("audit entries deleted unexpectedly, id in the latest entry is %d, but expected %d", id, integrityId));
            }
            LOG.warn("id in the last entry is{}, but in the integrityText is {}", (Object)id, (Object)integrityId);
        }
    }

    @Override
    public void init(String conf) throws InvalidConfException {
        int algoId;
        ConfPairs confPairs = new ConfPairs(conf);
        String str = confPairs.value(KEY_SHARD_ID);
        this.shardId = StringUtil.isBlank((String)str) ? 0 : Integer.parseInt(str);
        str = confPairs.value(KEY_ENC_INTERVAL);
        this.encInterval = str == null ? 1 : Integer.parseInt(str);
        String algo = confPairs.value(KEY_ALGO);
        if (algo == null) {
            algo = "HmacSHA256";
            algoId = 1;
        } else if ("HmacSHA256".equalsIgnoreCase(algo.replace("-", ""))) {
            algo = "HmacSHA256";
            algoId = 1;
        } else {
            throw new IllegalArgumentException("unsupported algorithm " + algo);
        }
        this.keyId = confPairs.value(KEY_KEYID);
        if (StringUtil.isBlank((String)this.keyId)) {
            throw new IllegalArgumentException("property keyid not defined");
        }
        this.tagPrefix = "v1:" + algoId + INNER_DELIM + this.keyId + INNER_DELIM;
        this.tagPrefixBytes = this.tagPrefix.getBytes(StandardCharsets.UTF_8);
        String password = confPairs.value(KEY_PASSWORD);
        if (StringUtil.isBlank((String)password)) {
            throw new IllegalArgumentException("property password not defined");
        }
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            char[] passwordChars = password.toCharArray();
            PBEKeySpec spec = new PBEKeySpec(passwordChars, "MAC".getBytes(StandardCharsets.UTF_8), 10000, 256);
            SecretKey macKey = factory.generateSecret(spec);
            spec = new PBEKeySpec(passwordChars, "ENC".getBytes(StandardCharsets.UTF_8), 10000, 256);
            this.encKey = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
            this.mac = Mac.getInstance(algo);
            this.mac.init(macKey);
            this.cipher = Cipher.getInstance("AES/GCM/NoPadding");
        }
        catch (Exception ex) {
            throw new IllegalStateException("could not initialize Mac or Cipher", ex);
        }
        this.rnd = new SecureRandom();
        this.doExtraInit(new ConfPairs(conf));
    }

    @Override
    public void logEvent(AuditEvent event) {
        this.log(1, event.getLevel(), event.toTextMessage());
    }

    @Override
    public void logEvent(PciAuditEvent event) {
        this.log(2, event.getLevel(), event.toTextMessage());
    }

    private synchronized void log(int eventType, AuditLevel level, String message) {
        Instant date = Instant.now();
        long previousId = this.id.get();
        long thisId = this.id.incrementAndGet();
        String levelText = level.getText();
        String payload = this.buildMacPayload(date, thisId, eventType, levelText, previousId, this.previousTag, message);
        this.mac.reset();
        this.mac.update(this.tagPrefixBytes);
        this.mac.update(payload.getBytes(StandardCharsets.UTF_8));
        byte[] tag = this.mac.doFinal();
        String tagWithMeta = this.tagPrefix + Base64.encodeToString((byte[])tag);
        this.previousTag = tagWithMeta;
        this.storeLog(date, thisId, eventType, levelText, previousId, message, tagWithMeta);
        if (this.encInterval <= 1 || thisId % (long)this.encInterval == 0L) {
            String integrityText = this.buildIntegrityText();
            this.storeIntegrity(integrityText);
        }
    }

    private String buildIntegrityText() {
        byte[] cipherText;
        byte[] plaintext = StringUtil.toUtf8Bytes((String)("v1;" + this.shardId + DELIM + this.id.get() + DELIM + this.previousTag));
        byte[] iv = new byte[12];
        this.rnd.nextBytes(iv);
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        try {
            this.cipher.init(1, (Key)this.encKey, spec);
            cipherText = this.cipher.doFinal(plaintext);
        }
        catch (Exception e) {
            throw new IllegalStateException("error encrypting thisId", e);
        }
        return "v1;" + this.keyId + DELIM + Base64.encodeToString((byte[])iv) + DELIM + Base64.encodeToString((byte[])cipherText);
    }

    @Override
    public final void close() throws Exception {
        if (!(this.encInterval <= 1 | this.id.get() % (long)this.encInterval == 0L)) {
            String integrityText = this.buildIntegrityText();
            this.storeIntegrity(integrityText);
        }
        this.doClose();
    }
}

