/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;

public class PermissionConstants {
    public static final String NAME_NONE = "none";
    public static final String NAME_ALL = "all";
    private static final Map<Integer, String> codeTextMap = new HashMap<Integer, String>();
    private static final Map<String, Integer> textCodeMap = new HashMap<String, Integer>();
    private static final List<Integer> permissions;
    public static final int ENROLL_CERT = 1;
    public static final int REVOKE_CERT = 2;
    public static final int UNSUSPEND_CERT = 4;
    public static final int REMOVE_CERT = 8;
    public static final int REENROLL_CERT = 16;
    @Deprecated
    public static final int GEN_CRL = 32;
    public static final int GET_CRL = 64;
    public static final int ENROLL_CROSS = 128;
    public static final int GEN_KEYPAIR = 256;
    public static final int GET_CERT = 512;
    public static final int ALL = 1023;

    private PermissionConstants() {
    }

    public static boolean contains(int permissionA, int permissionB) {
        return (permissionA & permissionB) == permissionB;
    }

    public static Integer getPermissionForText(String text) {
        if (text == null) {
            return null;
        }
        if (NAME_ALL.equalsIgnoreCase(text)) {
            return 1023;
        }
        if (StringUtil.isNumber((String)text)) {
            return Integer.parseInt(text);
        }
        return textCodeMap.get(text.toLowerCase());
    }

    public static String getTextForCode(int code) {
        if (code == 1023) {
            return NAME_ALL;
        }
        String text = codeTextMap.get(code);
        return text == null ? Integer.toString(code) : text;
    }

    public static List<Integer> getPermissions() {
        return permissions;
    }

    public static String permissionToString(int permission) {
        if (permission == 1023) {
            return NAME_ALL;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, String> entry : codeTextMap.entrySet()) {
            Integer code = entry.getKey();
            if ((permission & code) == 0) continue;
            sb.append(entry.getValue()).append("|");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static List<String> permissionToStringList(int permission) {
        ArrayList<String> set = new ArrayList<String>(10);
        if (permission == 1023) {
            set.add(NAME_ALL);
            return set;
        }
        for (Map.Entry<Integer, String> entry : codeTextMap.entrySet()) {
            Integer code = entry.getKey();
            if ((permission & code) == 0) continue;
            set.add(entry.getValue());
        }
        return set;
    }

    public static int toIntPermission(Collection<String> permissions) throws InvalidConfException {
        if (permissions == null) {
            return 0;
        }
        int ret = 0;
        for (String permission : permissions) {
            if (NAME_NONE.equalsIgnoreCase(permission)) continue;
            Integer ii = PermissionConstants.getPermissionForText(permission);
            if (ii == null) {
                throw new InvalidConfException("invalid permission " + permission);
            }
            ret |= ii.intValue();
        }
        return ret;
    }

    static {
        codeTextMap.put(1, "enroll_cert");
        codeTextMap.put(2, "revoke_cert");
        codeTextMap.put(4, "unsuspend_cert");
        codeTextMap.put(8, "remove_cert");
        codeTextMap.put(16, "reenroll_cert");
        codeTextMap.put(32, "gen_crl");
        codeTextMap.put(64, "get_crl");
        codeTextMap.put(128, "enroll_cross");
        codeTextMap.put(256, "gen_keypair");
        codeTextMap.put(512, "get_cert");
        for (Map.Entry<Integer, String> entry : codeTextMap.entrySet()) {
            textCodeMap.put(entry.getValue(), entry.getKey());
        }
        ArrayList<Integer> tmpPermissions = new ArrayList<Integer>(codeTextMap.keySet());
        Collections.sort(tmpPermissions);
        permissions = Collections.unmodifiableList(tmpPermissions);
    }
}

