/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.qualified.BiometricData;
import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.bouncycastle.asn1.x509.qualified.TypeOfBiometricData;
import org.bouncycastle.openssl.PKCS8Generator;
import org.bouncycastle.openssl.jcajce.JcaPKCS8Generator;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8EncryptorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.xipki.security.BadInputException;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DHSigStaticKeyCertPair;
import org.xipki.security.HashAlgo;
import org.xipki.security.KeyUsage;
import org.xipki.security.NoIdleSignerException;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.SignatureAlgoControl;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.shell.SecurityCompleters;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.shell.XiAction;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.ConcurrentBag;
import org.xipki.util.DateUtil;
import org.xipki.util.Hex;
import org.xipki.util.IoUtil;
import org.xipki.util.PemEncoder;
import org.xipki.util.StringUtil;

public class Actions {
    public static final String TEXT_F4 = "0x10001";

    private static byte[] extractCertFromSignedData(byte[] cmsBytes) throws CmdFailure, IOException {
        ContentInfo ci = ContentInfo.getInstance((Object)X509Util.toDerEncoded((byte[])cmsBytes));
        ASN1Set certs = SignedData.getInstance((Object)ci.getContent()).getCertificates();
        if (certs == null || certs.size() == 0) {
            throw new CmdFailure("Found no certificate");
        }
        return certs.getObjectAt(0).toASN1Primitive().getEncoded();
    }

    public static abstract class SecurityAction
    extends XiAction {
        @Reference
        protected SecurityFactory securityFactory;

        protected String toUtcTimeyyyyMMddhhmmssZ(Instant date) {
            return DateUtil.toUtcTimeyyyyMMddhhmmss((Instant)date) + "Z";
        }
    }

    @Command(scope="xi", name="export-keycert-est", description="export key and certificate from the response of EST's serverkeygen")
    @Service
    public static class ExportKeyCertEst
    extends SecurityAction {
        @Option(name="--outform", description="output format of the key and certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        private String outform = "der";
        @Argument(index=0, name="response-file", required=true, description="File containing the response")
        @Completion(value=FileCompleter.class)
        private String estRespFile;
        @Argument(index=1, name="key-file", required=true, description="File to save the private key")
        @Completion(value=FileCompleter.class)
        private String keyFile;
        @Argument(index=2, name="cert-file", required=true, description="File to save the certificate")
        @Completion(value=FileCompleter.class)
        private String certFile;

        protected Object execute0() throws Exception {
            try (BufferedReader reader = new BufferedReader(new FileReader(IoUtil.expandFilepath((String)this.estRespFile)));){
                Object[][] blockInfos;
                String line;
                String boundary = null;
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("--")) continue;
                    boundary = line;
                    break;
                }
                if (boundary == null) {
                    throw new IOException("found no boundary");
                }
                Object[] blockInfo1 = ExportKeyCertEst.readBlock(reader, boundary);
                if (((Boolean)blockInfo1[0]).booleanValue()) {
                    throw new IOException("2 blocks is expected, found only 1");
                }
                Object[] blockInfo2 = ExportKeyCertEst.readBlock(reader, boundary);
                if (!((Boolean)blockInfo2[0]).booleanValue()) {
                    throw new IOException("2 blocks is expected, found more than 2");
                }
                byte[] keyBytes = null;
                byte[] certBytes = null;
                for (Object[] blockInfo : blockInfos = new Object[][]{blockInfo1, blockInfo2}) {
                    String ct = (String)blockInfo[1];
                    byte[] bytes = (byte[])blockInfo[2];
                    if (ct.startsWith("application/pkcs8")) {
                        keyBytes = bytes;
                        continue;
                    }
                    if (!ct.startsWith("application/pkcs7-mime")) continue;
                    certBytes = bytes;
                }
                if (keyBytes == null) {
                    throw new IOException("found no private key block");
                }
                if (certBytes == null) {
                    throw new IOException("found no certificate block");
                }
                this.saveVerbose("private key saved to file", this.keyFile, ExportKeyCertEst.derPemEncode(keyBytes, (String)this.outform, (PemEncoder.PemLabel)PemEncoder.PemLabel.PRIVATE_KEY));
                byte[] rawCertBytes = Actions.extractCertFromSignedData(certBytes);
                this.saveVerbose("certificate saved to file", this.certFile, ExportKeyCertEst.encodeCert((byte[])rawCertBytes, (String)this.outform));
            }
            return null;
        }

        private static Object[] readBlock(BufferedReader reader, String boundary) throws IOException {
            byte[] content;
            String line;
            StringBuilder sb = new StringBuilder();
            String contentType = null;
            String encoding = null;
            boolean isLastBlock = false;
            boolean bodyStarted = false;
            boolean bodyFinished = false;
            while ((line = reader.readLine()) != null) {
                if (bodyStarted) {
                    if (line.equals(boundary)) {
                        bodyFinished = true;
                        break;
                    }
                    if (line.equals(boundary + "--")) {
                        bodyFinished = true;
                        isLastBlock = true;
                        break;
                    }
                    sb.append(line);
                    sb.append("\r\n");
                    continue;
                }
                if (line.isEmpty()) {
                    bodyStarted = true;
                    continue;
                }
                if (StringUtil.startsWithIgnoreCase((String)line, (String)"content-type:")) {
                    contentType = line.substring("content-type:".length()).trim();
                    continue;
                }
                if (!StringUtil.startsWithIgnoreCase((String)line, (String)"content-transfer-encoding:")) continue;
                encoding = line.substring("content-transfer-encoding:".length()).trim();
            }
            if (!bodyStarted || !bodyFinished) {
                throw new IOException("invalid block");
            }
            if ("base64".equalsIgnoreCase(encoding)) {
                content = Base64.decodeFast((String)sb.toString());
            } else if (StringUtil.isBlank(encoding)) {
                content = sb.toString().getBytes(StandardCharsets.UTF_8);
            } else {
                throw new IOException("unknown content-transfer-encoding " + encoding);
            }
            return new Object[]{isLastBlock, contentType, content};
        }
    }

    @Command(scope="xi", name="export-cert-p7m", description="export (the first) certificate from CMS signed data")
    @Service
    public static class ExportCertP7m
    extends SecurityAction {
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        private String outform = "der";
        @Argument(index=0, name="p7m file", required=true, description="File of the CMS signed data")
        @Completion(value=FileCompleter.class)
        private String p7mFile;
        @Argument(index=1, name="cert file", required=true, description="File to save the certificate")
        @Completion(value=FileCompleter.class)
        private String certFile;

        protected Object execute0() throws Exception {
            byte[] encodedCert = Actions.extractCertFromSignedData(IoUtil.read((String)this.p7mFile));
            this.saveVerbose("saved certificate to file", this.certFile, ExportCertP7m.encodeCert((byte[])encodedCert, (String)this.outform));
            return null;
        }
    }

    @Command(scope="xi", name="import-cert", description="import certificates to a keystore")
    @Service
    public static class ImportCert
    extends SecurityAction {
        @Option(name="--keystore", required=true, description="keystore file")
        @Completion(value=FileCompleter.class)
        private String ksFile;
        @Option(name="--type", required=true, description="type of the keystore")
        @Completion(value=SecurityCompleters.KeystoreTypeCompleter.class)
        private String ksType;
        @Option(name="--password", description="password of the keystore, as plaintext or PBE-encrypted.")
        private String ksPwdHint;
        @Option(name="--cert", aliases={"-c"}, required=true, multiValued=true, description="certificate files")
        @Completion(value=FileCompleter.class)
        private List<String> certFiles;

        protected Object execute0() throws Exception {
            File realKsFile = new File(IoUtil.expandFilepath((String)this.ksFile));
            KeyStore ks = KeyUtil.getOutKeyStore((String)this.ksType);
            char[] password = this.readPasswordIfNotSet("Enter the keystore password", this.ksPwdHint);
            HashSet<Object> aliases = new HashSet<Object>(10);
            if (realKsFile.exists()) {
                try (InputStream inStream = Files.newInputStream(realKsFile.toPath(), new OpenOption[0]);){
                    ks.load(inStream, password);
                }
                Enumeration<String> strs = ks.aliases();
                while (strs.hasMoreElements()) {
                    aliases.add((String)strs.nextElement());
                }
            } else {
                ks.load(null);
            }
            for (String certFile : this.certFiles) {
                X509Cert cert = X509Util.parseCert((File)new File(certFile));
                String baseAlias = X509Util.getCommonName((X500Name)cert.getSubject());
                Object alias = baseAlias;
                int idx = 2;
                while (aliases.contains(alias)) {
                    alias = baseAlias + "-" + idx++;
                }
                ks.setCertificateEntry((String)alias, cert.toJceCert());
                aliases.add(alias);
            }
            try (ByteArrayOutputStream bout = new ByteArrayOutputStream(4096);){
                ks.store(bout, password);
                this.saveVerbose("saved keystore to file", realKsFile, bout.toByteArray());
            }
            return null;
        }
    }

    @Command(scope="xi", name="validate-csr", description="validate CSR")
    @Service
    public static class ValidateCsr
    extends SecurityAction {
        @Option(name="--csr", required=true, description="CSR file")
        @Completion(value=FileCompleter.class)
        private String csrFile;
        @Option(name="--keystore", description="peer's keystore file")
        @Completion(value=FileCompleter.class)
        private String peerKeystoreFile;
        @Option(name="--keystore-type", description="type of the keystore")
        @Completion(value=SecurityCompleters.KeystoreTypeCompleter.class)
        private String keystoreType = "PKCS12";
        @Option(name="--keystore-password", description="password of the keystore, as plaintext or PBE-encrypted.")
        private String keystorePasswordHint;

        protected Object execute0() throws Exception {
            CertificationRequest csr = X509Util.parseCsr((byte[])IoUtil.read((String)this.csrFile));
            ASN1ObjectIdentifier algOid = csr.getSignatureAlgorithm().getAlgorithm();
            DHSigStaticKeyCertPair peerKeyAndCert = null;
            if (ObjectIdentifiers.Xipki.id_alg_dhPop_x25519.equals((ASN1Primitive)algOid) || ObjectIdentifiers.Xipki.id_alg_dhPop_x448.equals((ASN1Primitive)algOid)) {
                if (this.peerKeystoreFile == null || this.keystorePasswordHint == null) {
                    System.err.println("could not verify CSR, please specify the peer's keystore");
                    return null;
                }
                String requiredKeyAlg = ObjectIdentifiers.Xipki.id_alg_dhPop_x25519.equals((ASN1Primitive)algOid) ? "X25519" : "X448";
                char[] password = this.readPasswordIfNotSet("Enter the keystore password", this.keystorePasswordHint);
                KeyStore ks = KeyUtil.getInKeyStore((String)this.keystoreType);
                File file = IoUtil.expandFilepath((File)new File(this.peerKeystoreFile));
                try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                    ks.load(is, password);
                    Enumeration<String> aliases = ks.aliases();
                    while (aliases.hasMoreElements()) {
                        PrivateKey key;
                        String alias = aliases.nextElement();
                        if (!ks.isKeyEntry(alias) || !(key = (PrivateKey)ks.getKey(alias, password)).getAlgorithm().equalsIgnoreCase(requiredKeyAlg)) continue;
                        peerKeyAndCert = new DHSigStaticKeyCertPair(key, new X509Cert((X509Certificate)ks.getCertificate(alias)));
                        break;
                    }
                }
                if (peerKeyAndCert == null) {
                    System.err.println("could not find peer key entry to verify the CSR");
                    return null;
                }
            }
            boolean bo = this.securityFactory.verifyPop(csr, null, peerKeyAndCert);
            SignAlgo signAlgo = SignAlgo.getInstance((AlgorithmIdentifier)csr.getSignatureAlgorithm());
            this.println("The POP is " + (bo ? "" : "in") + "valid (signature algorithm " + signAlgo.getJceName() + ").");
            return null;
        }
    }

    public static abstract class BaseCsrGenAction
    extends SecurityAction {
        @Option(name="--subject-alt-name", aliases={"--san"}, multiValued=true, description="subjectAltName, in the form of [tagNo]value or [tagText]value. Valid tagNo/tagText/value:\n '0'/'othername'/OID=[DirectoryStringChoice:]value,\n    valid DirectoryStringChoices are printableString and utf8String,\n    default to utf8Sring '1'/'email'/text,\n '2'/'dns'/text,\n '4'/'dirName'/X500 name e.g. CN=abc,\n '5'/'edi'/key=value,\n '6'/'uri'/text,\n '7'/'ip'/IP address,\n '8'/'rid'/OID")
        protected List<String> subjectAltNames;
        @Option(name="--subject-info-access", aliases={"--sia"}, multiValued=true, description="subjectInfoAccess")
        protected List<String> subjectInfoAccesses;
        @Option(name="--peer-cert", description="Peer certificate file, only for the Diffie-Hellman keys")
        @Completion(value=FileCompleter.class)
        private String peerCertFile;
        @Option(name="--peer-certs", description="Peer certificates file (A PEM file containing certificates, only for the Diffie-Hellman keys")
        @Completion(value=FileCompleter.class)
        private String peerCertsFile;
        @Option(name="--cert", description="Certificate file, from which subject and extensions will be extracted.\nMaximal one of cert and old-cert is allowed.")
        @Completion(value=FileCompleter.class)
        private String certFile;
        @Option(name="--cert-ext-exclude", multiValued=true, description="OIDs of extension types which are not copied from the --cert option to CSR.")
        private List<String> excludeCertExtns;
        @Option(name="--cert-ext-include", multiValued=true, description="OIDs of extension types which are copied from the --cert option to CSR.")
        private List<String> includeCertExtns;
        @Option(name="--old-cert", description="Certificate file to be updated. The subject and subjectAltNames will be copied to the CSR.\nThe subject and subject-alt-name specified here will be specified in the changeSubjectName attribute.\nMaximal one of cert and old-cert is allowed.")
        @Completion(value=FileCompleter.class)
        private String oldCertFile;
        @Option(name="--subject", aliases={"-s"}, description="subject in the CSR, if not set, use the subject in the signer's certificate ")
        private String subject;
        @Option(name="--dateOfBirth", description="Date of birth YYYYMMdd in subject")
        private String dateOfBirth;
        @Option(name="--postalAddress", multiValued=true, description="postal address in subject")
        private List<String> postalAddress;
        @Option(name="--outform", description="output format of the CSR")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="CSR file")
        @Completion(value=FileCompleter.class)
        private String outputFilename;
        @Option(name="--challenge-password", aliases={"-c"}, description="challenge password, as plaintext or PBE-encrypted.")
        private String challengePasswordHint;
        @Option(name="--keyusage", multiValued=true, description="keyusage")
        @Completion(value=Completers.KeyusageCompleter.class)
        private List<String> keyusages;
        @Option(name="--ext-keyusage", multiValued=true, description="extended keyusage (name or OID)")
        @Completion(value=Completers.ExtKeyusageCompleter.class)
        private List<String> extkeyusages;
        @Option(name="--qc-eu-limit", multiValued=true, description="QC EuLimitValue of format <currency>:<amount>:<exponent>")
        private List<String> qcEuLimits;
        @Option(name="--biometric-type", description="Biometric type")
        private String biometricType;
        @Option(name="--biometric-hash", description="Biometric hash algorithm")
        @Completion(value=Completers.HashAlgCompleter.class)
        private String biometricHashAlgo;
        @Option(name="--biometric-file", description="Biometric hash algorithm")
        private String biometricFile;
        @Option(name="--biometric-uri", description="Biometric sourcedata URI")
        @Completion(value=FileCompleter.class)
        private String biometricUri;
        @Option(name="--extensions-file", description="File containing the DER-encoded Extensions.")
        @Completion(value=FileCompleter.class)
        private String extensionsFile;

        protected abstract ConcurrentContentSigner getSigner() throws Exception;

        protected List<X509Cert> getPeerCertificates() throws CertificateException, IOException {
            if (StringUtil.isNotBlank((String)this.peerCertsFile)) {
                return X509Util.parseCerts((File)Paths.get(this.peerCertsFile, new String[0]).toFile());
            }
            if (StringUtil.isNotBlank((String)this.peerCertFile)) {
                X509Cert cert = X509Util.parseCert((File)Paths.get(this.peerCertFile, new String[0]).toFile());
                return Collections.singletonList(cert);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        protected Object execute0() throws Exception {
            void var10_41;
            X500Name subjectDn;
            char[] challengePassword;
            ASN1OctetString extnValue;
            SubjectPublicKeyInfo subjectPublicKeyInfo;
            if (this.certFile != null && this.oldCertFile != null) {
                throw new IllegalCmdParamException("maximal one of cert and old-cert is allowed");
            }
            ConcurrentContentSigner signer = this.getSigner();
            SubjectPublicKeyInfo subjectPublicKeyInfo2 = subjectPublicKeyInfo = signer.getCertificate() == null ? KeyUtil.createSubjectPublicKeyInfo((PublicKey)signer.getPublicKey()) : signer.getCertificate().getSubjectPublicKeyInfo();
            if (this.extkeyusages != null) {
                ArrayList<String> list = new ArrayList<String>(this.extkeyusages.size());
                for (String m : this.extkeyusages) {
                    String id = Completers.ExtKeyusageCompleter.getIdForUsageName((String)m);
                    if (id != null) continue;
                    try {
                        new ASN1ObjectIdentifier(m);
                    }
                    catch (Exception exception) {
                        throw new IllegalCmdParamException("invalid extended key usage " + m);
                    }
                }
                this.extkeyusages = list;
            }
            LinkedList<Extension> extensions = new LinkedList<Extension>();
            ASN1OctetString aSN1OctetString = extnValue = BaseCsrGenAction.isEmpty(this.subjectInfoAccesses) ? null : X509Util.createExtnSubjectInfoAccess(this.subjectInfoAccesses, (boolean)false).getExtnValue();
            if (extnValue != null) {
                extensions.add(new Extension(Extension.subjectInfoAccess, false, extnValue));
            }
            if (BaseCsrGenAction.isNotEmpty(this.keyusages)) {
                HashSet<KeyUsage> usages = new HashSet<KeyUsage>();
                for (String string : this.keyusages) {
                    usages.add(KeyUsage.getKeyUsage((String)string));
                }
                extensions.add(new Extension(Extension.keyUsage, false, X509Util.createKeyUsage(usages).getEncoded()));
            }
            if (BaseCsrGenAction.isNotEmpty(this.extkeyusages)) {
                extensions.add(new Extension(Extension.extendedKeyUsage, false, X509Util.createExtendedUsage(BaseCsrGenAction.textToAsn1ObjectIdentifers(this.extkeyusages)).getEncoded()));
            }
            if (BaseCsrGenAction.isNotEmpty(this.qcEuLimits)) {
                ASN1EncodableVector vec = new ASN1EncodableVector();
                for (String string : this.qcEuLimits) {
                    StringTokenizer st = new StringTokenizer(string, ":");
                    try {
                        Iso4217CurrencyCode currency;
                        String currencyS = st.nextToken();
                        String string2 = st.nextToken();
                        String exponentS = st.nextToken();
                        try {
                            int intValue = Integer.parseInt(currencyS);
                            currency = new Iso4217CurrencyCode(intValue);
                        }
                        catch (NumberFormatException ex) {
                            currency = new Iso4217CurrencyCode(currencyS);
                        }
                        MonetaryValue monterayValue = new MonetaryValue(currency, Integer.parseInt(string2), Integer.parseInt(exponentS));
                        QCStatement statment = new QCStatement(ObjectIdentifiers.Extn.id_etsi_qcs_QcLimitValue, (ASN1Encodable)monterayValue);
                        vec.add((ASN1Encodable)statment);
                    }
                    catch (Exception ex) {
                        throw new Exception("invalid qc-eu-limit '" + string + "'");
                    }
                }
                extensions.add(new Extension(Extension.qCStatements, false, new DERSequence(vec).getEncoded()));
            }
            if (this.biometricType != null && this.biometricHashAlgo != null && this.biometricFile != null) {
                TypeOfBiometricData tmpBiometricType = StringUtil.isNumber((String)this.biometricType) ? new TypeOfBiometricData(Integer.parseInt(this.biometricType)) : new TypeOfBiometricData(new ASN1ObjectIdentifier(this.biometricType));
                HashAlgo ha = HashAlgo.getInstance((String)this.biometricHashAlgo);
                byte[] byArray = ha.hash((byte[][])new byte[][]{IoUtil.read((String)this.biometricFile)});
                DERIA5String tmpSourceDataUri = null;
                if (this.biometricUri != null) {
                    tmpSourceDataUri = new DERIA5String(this.biometricUri);
                }
                BiometricData biometricData = new BiometricData(tmpBiometricType, ha.getAlgorithmIdentifier(), (ASN1OctetString)new DEROctetString(byArray), (ASN1IA5String)tmpSourceDataUri);
                extensions.add(new Extension(Extension.biometricInfo, false, new DERSequence((ASN1Encodable)biometricData).getEncoded()));
            } else if (this.biometricType != null || this.biometricHashAlgo != null || this.biometricFile != null) {
                throw new Exception("either all of biometric triples (type, hash algo, file) must be set or none of them should be set");
            }
            ArrayList<ASN1ObjectIdentifier> addedExtnTypes = new ArrayList<ASN1ObjectIdentifier>(extensions.size());
            for (Extension extension : extensions) {
                addedExtnTypes.add(extension.getExtnId());
            }
            if (this.extensionsFile != null) {
                Extensions extns = Extensions.getInstance((Object)IoUtil.read((String)this.extensionsFile));
                for (ASN1ObjectIdentifier aSN1ObjectIdentifier : extns.getExtensionOIDs()) {
                    if (addedExtnTypes.contains(aSN1ObjectIdentifier)) {
                        throw new Exception("duplicated extension " + aSN1ObjectIdentifier.getId());
                    }
                    Extension extn = extns.getExtension(aSN1ObjectIdentifier);
                    extensions.add(extn);
                    addedExtnTypes.add(aSN1ObjectIdentifier);
                }
            }
            extensions.addAll(this.getAdditionalExtensions());
            char[] cArray = challengePassword = StringUtil.isBlank((String)this.challengePasswordHint) ? null : this.resolvePassword(this.challengePasswordHint);
            if (this.certFile != null) {
                Certificate certificate = Certificate.getInstance((Object)X509Util.toDerEncoded((byte[])IoUtil.read((String)this.certFile)));
                if (!Arrays.equals(subjectPublicKeyInfo.getEncoded(), certificate.getSubjectPublicKeyInfo().getEncoded())) {
                    throw new IllegalCmdParamException("PublicKey extracted from signer is different than in the certificate");
                }
                Extensions certExtns = certificate.getTBSCertificate().getExtensions();
                List<ASN1ObjectIdentifier> stdExcludeOids = Arrays.asList(Extension.authorityKeyIdentifier, Extension.authorityInfoAccess, Extension.certificateIssuer, Extension.certificatePolicies, Extension.cRLDistributionPoints, Extension.freshestCRL, Extension.nameConstraints, Extension.policyMappings, Extension.policyConstraints, Extension.certificatePolicies, Extension.subjectInfoAccess, Extension.subjectDirectoryAttributes);
                for (ASN1ObjectIdentifier certExtnOid : certExtns.getExtensionOIDs()) {
                    boolean add;
                    boolean bl = add = !addedExtnTypes.contains(certExtnOid);
                    if (add) {
                        boolean bl2 = BaseCsrGenAction.isNotEmpty(this.includeCertExtns) ? this.includeCertExtns.contains(certExtnOid.getId()) : (add = !stdExcludeOids.contains(certExtnOid));
                    }
                    if (add && BaseCsrGenAction.isNotEmpty(this.excludeCertExtns)) {
                        boolean bl3 = add = !this.excludeCertExtns.contains(certExtnOid.getId());
                    }
                    if (!add) continue;
                    extensions.add(certExtns.getExtension(certExtnOid));
                }
                PKCS10CertificationRequest pKCS10CertificationRequest = this.generateRequest(signer, subjectPublicKeyInfo, certificate.getSubject(), challengePassword, extensions, new Attribute[0]);
                this.saveVerbose("saved CSR to file", this.outputFilename, BaseCsrGenAction.encodeCsr((byte[])pKCS10CertificationRequest.getEncoded(), (String)this.outform));
                return null;
            }
            boolean bl = this.oldCertFile != null;
            X500Name newSubjectDn = null;
            if (this.subject == null) {
                if (StringUtil.isNotBlank((String)this.dateOfBirth)) {
                    throw new IllegalCmdParamException("dateOfBirth cannot be set if subject is not set");
                }
                if (CollectionUtil.isNotEmpty(this.postalAddress)) {
                    throw new IllegalCmdParamException("postalAddress cannot be set if subject is not set");
                }
                if (!bl) {
                    X509Cert signerCert = signer.getCertificate();
                    if (signerCert == null) {
                        throw new IllegalCmdParamException("subject must be set");
                    }
                    newSubjectDn = signerCert.getSubject();
                }
            } else {
                ASN1ObjectIdentifier aSN1ObjectIdentifier;
                ASN1ObjectIdentifier aSN1ObjectIdentifier2;
                RDN[] rdns;
                newSubjectDn = this.getSubject(this.subject);
                LinkedList<RDN> list = new LinkedList<RDN>();
                if (StringUtil.isNotBlank((String)this.dateOfBirth) && ((rdns = newSubjectDn.getRDNs(aSN1ObjectIdentifier2 = ObjectIdentifiers.DN.dateOfBirth)) == null || rdns.length == 0)) {
                    Instant date = DateUtil.parseUtcTimeyyyyMMdd((String)this.dateOfBirth);
                    date = date.plus(12L, ChronoUnit.HOURS);
                    list.add(new RDN(aSN1ObjectIdentifier2, (ASN1Encodable)new DERGeneralizedTime(DateUtil.toUtcTimeyyyyMMddhhmmss((Instant)date) + "Z")));
                }
                if (CollectionUtil.isNotEmpty(this.postalAddress) && ((rdns = newSubjectDn.getRDNs(aSN1ObjectIdentifier = ObjectIdentifiers.DN.postalAddress)) == null || rdns.length == 0)) {
                    ASN1EncodableVector vec = new ASN1EncodableVector();
                    for (String m : this.postalAddress) {
                        vec.add((ASN1Encodable)new DERUTF8String(m));
                    }
                    if (vec.size() > 0) {
                        list.add(new RDN(aSN1ObjectIdentifier, (ASN1Encodable)new DERSequence(vec)));
                    }
                }
                if (!list.isEmpty()) {
                    Collections.addAll(list, newSubjectDn.getRDNs());
                    newSubjectDn = new X500Name(list.toArray(new RDN[0]));
                }
            }
            extnValue = BaseCsrGenAction.isEmpty(this.subjectAltNames) ? null : X509Util.createExtnSubjectAltName(this.subjectAltNames, (boolean)false).getExtnValue();
            Extension newSubjectAltNames = null;
            if (extnValue != null) {
                newSubjectAltNames = new Extension(Extension.subjectAlternativeName, false, extnValue);
            }
            Object var10_39 = null;
            if (bl) {
                Certificate oldCert = Certificate.getInstance((Object)X509Util.toDerEncoded((byte[])IoUtil.read((String)this.oldCertFile)));
                subjectDn = oldCert.getSubject();
                Extension oldSan = oldCert.getTBSCertificate().getExtensions().getExtension(Extension.subjectAlternativeName);
                if (oldSan != null) {
                    extensions.add(oldSan);
                }
                if (newSubjectDn != null || newSubjectAltNames != null) {
                    ASN1EncodableVector v = new ASN1EncodableVector();
                    v.add((ASN1Encodable)(newSubjectDn == null ? subjectDn : newSubjectDn));
                    GeneralNames subjectAlt = null;
                    if (newSubjectAltNames != null) {
                        subjectAlt = GeneralNames.getInstance((Object)newSubjectAltNames.getExtnValue().getOctets());
                    } else if (oldSan != null) {
                        subjectAlt = GeneralNames.getInstance((Object)oldSan.getParsedValue());
                    }
                    if (subjectAlt != null) {
                        v.add((ASN1Encodable)subjectAlt);
                    }
                    Attribute attribute = new Attribute(ObjectIdentifiers.CMC.id_cmc_changeSubjectName, (ASN1Set)new DERSet((ASN1Encodable)new DERSequence(v)));
                }
            } else {
                subjectDn = newSubjectDn;
                if (newSubjectAltNames != null) {
                    extensions.add(newSubjectAltNames);
                }
            }
            PKCS10CertificationRequest csr = this.generateRequest(signer, subjectPublicKeyInfo, subjectDn, challengePassword, extensions, new Attribute[]{var10_41});
            this.saveVerbose("saved CSR to file", this.outputFilename, BaseCsrGenAction.encodeCsr((byte[])csr.getEncoded(), (String)this.outform));
            return null;
        }

        protected X500Name getSubject(String subjectText) {
            return new X500Name(Args.notBlank((String)subjectText, (String)"subjectText"));
        }

        protected List<String> getAdditionalNeedExtensionTypes() {
            return Collections.emptyList();
        }

        protected List<String> getAdditionalWantExtensionTypes() {
            return Collections.emptyList();
        }

        protected List<Extension> getAdditionalExtensions() throws BadInputException {
            return Collections.emptyList();
        }

        private static List<ASN1ObjectIdentifier> textToAsn1ObjectIdentifers(List<String> oidTexts) {
            if (oidTexts == null) {
                return null;
            }
            ArrayList<ASN1ObjectIdentifier> ret = new ArrayList<ASN1ObjectIdentifier>(oidTexts.size());
            for (String oidText : oidTexts) {
                ASN1ObjectIdentifier oid;
                if (oidText.isEmpty() || ret.contains(oid = new ASN1ObjectIdentifier(oidText))) continue;
                ret.add(oid);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PKCS10CertificationRequest generateRequest(ConcurrentContentSigner signer, SubjectPublicKeyInfo subjectPublicKeyInfo, X500Name subjectDn, char[] challengePassword, List<Extension> extensions, Attribute ... attrs) throws XiSecurityException {
            ConcurrentBag.BagEntry signer0;
            Args.notNull((Object)signer, (String)"signer");
            Args.notNull((Object)subjectPublicKeyInfo, (String)"subjectPublicKeyInfo");
            Args.notNull((Object)subjectDn, (String)"subjectDn");
            HashMap<ASN1ObjectIdentifier, Object> attributes = new HashMap<ASN1ObjectIdentifier, Object>();
            if (BaseCsrGenAction.isNotEmpty(extensions)) {
                attributes.put(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, new Extensions(extensions.toArray(new Extension[0])));
            }
            if (challengePassword != null && challengePassword.length > 0) {
                attributes.put(PKCSObjectIdentifiers.pkcs_9_at_challengePassword, new DERPrintableString(new String(challengePassword)));
            }
            PKCS10CertificationRequestBuilder csrBuilder = new PKCS10CertificationRequestBuilder(subjectDn, subjectPublicKeyInfo);
            if (CollectionUtil.isNotEmpty(attributes)) {
                for (Map.Entry entry : attributes.entrySet()) {
                    csrBuilder.addAttribute((ASN1ObjectIdentifier)entry.getKey(), (ASN1Encodable)entry.getValue());
                }
            }
            if (attrs != null) {
                for (Attribute attr : attrs) {
                    if (attr == null) continue;
                    csrBuilder.addAttribute(attr.getAttrType(), attr.getAttrValues().toArray());
                }
            }
            try {
                signer0 = signer.borrowSigner();
            }
            catch (NoIdleSignerException noIdleSignerException) {
                throw new XiSecurityException(noIdleSignerException.getMessage(), (Throwable)noIdleSignerException);
            }
            try {
                PKCS10CertificationRequest pKCS10CertificationRequest = csrBuilder.build((ContentSigner)signer0.value());
                return pKCS10CertificationRequest;
            }
            finally {
                signer.requiteSigner(signer0);
            }
        }
    }

    public static abstract class CsrGenAction
    extends BaseCsrGenAction {
        @Option(name="--hash", description="hash algorithm name (will be ignored in some keys, e.g. edwards curve based keys)")
        @Completion(value=Completers.HashAlgCompleter.class)
        protected String hashAlgo = "SHA256";
        @Option(name="--rsa-pss", description="whether to use the RSAPSS for the POP computation\n(only applied to RSA key)")
        private Boolean rsaPss = Boolean.FALSE;
        @Option(name="--dsa-plain", description="whether to use the Plain DSA for the POP computation")
        private Boolean dsaPlain = Boolean.FALSE;
        @Option(name="--gm", description="whether to use the chinese GM algorithm for the POP computation\n(only applied to EC key with GM curves)")
        private Boolean gm = Boolean.FALSE;

        protected SignatureAlgoControl getSignatureAlgoControl() {
            this.hashAlgo = this.hashAlgo.trim().toUpperCase();
            if (this.hashAlgo.indexOf(45) != -1) {
                this.hashAlgo = this.hashAlgo.replaceAll("-", "");
            }
            return new SignatureAlgoControl(this.rsaPss.booleanValue(), this.dsaPlain.booleanValue(), this.gm.booleanValue());
        }
    }

    @Command(scope="xi", name="crl-info", description="print CRL information")
    @Service
    public static class CrlInfo
    extends SecurityAction {
        @Option(name="--in", description="CRL file")
        @Completion(value=FileCompleter.class)
        private String inFile;
        @Option(name="--hex", aliases={"-h"}, description="print hex number")
        private Boolean hex = Boolean.FALSE;
        @Option(name="--crlnumber", description="print CRL number")
        private Boolean crlNumber;
        @Option(name="--issuer", description="print issuer")
        private Boolean issuer;
        @Option(name="--this-update", description="print thisUpdate")
        private Boolean thisUpdate;
        @Option(name="--next-update", description="print nextUpdate")
        private Boolean nextUpdate;

        protected Object execute0() throws Exception {
            CertificateList crl = CertificateList.getInstance((Object)X509Util.toDerEncoded((byte[])IoUtil.read((String)this.inFile)));
            if (this.crlNumber != null && this.crlNumber.booleanValue()) {
                ASN1Encodable asn1 = crl.getTBSCertList().getExtensions().getExtensionParsedValue(Extension.cRLNumber);
                if (asn1 == null) {
                    return "null";
                }
                return this.getNumber(ASN1Integer.getInstance((Object)asn1).getPositiveValue());
            }
            if (this.issuer != null && this.issuer.booleanValue()) {
                return crl.getIssuer().toString();
            }
            if (this.thisUpdate != null && this.thisUpdate.booleanValue()) {
                return this.toUtcTimeyyyyMMddhhmmssZ(crl.getThisUpdate().getDate().toInstant());
            }
            if (this.nextUpdate != null && this.nextUpdate.booleanValue()) {
                return crl.getNextUpdate() == null ? "null" : this.toUtcTimeyyyyMMddhhmmssZ(crl.getNextUpdate().getDate().toInstant());
            }
            return null;
        }

        private String getNumber(Number no) {
            if (!this.hex.booleanValue()) {
                return no.toString();
            }
            if (no instanceof Byte) {
                return "0X" + Hex.encode((byte[])new byte[]{(Byte)no});
            }
            if (no instanceof Short) {
                return "0X" + Integer.toHexString(((Short)no).shortValue());
            }
            if (no instanceof Integer) {
                return "0X" + Integer.toHexString((Integer)no);
            }
            if (no instanceof Long) {
                return "0X" + Long.toHexString((Long)no);
            }
            if (no instanceof BigInteger) {
                return "0X" + ((BigInteger)no).toString(16);
            }
            return no.toString();
        }
    }

    @Command(scope="xi", name="convert-keystore", description="Convert keystore")
    @Service
    public static class ConvertKeystore
    extends SecurityAction {
        @Option(name="--in", required=true, description="source keystore file")
        @Completion(value=FileCompleter.class)
        private String inFile;
        @Option(name="--intype", required=true, description="type of the source keystore")
        @Completion(value=SecurityCompleters.KeystoreTypeCompleter.class)
        private String inType;
        @Option(name="--inpwd", description="password of the source keystore, as plaintext or PBE-encrypted.")
        private String inPwdHint;
        @Option(name="--out", required=true, description="destination keystore file")
        @Completion(value=FileCompleter.class)
        private String outFile;
        @Option(name="--outtype", required=true, description="type of the destination keystore")
        @Completion(value=SecurityCompleters.KeystoreTypeWithPEMCompleter.class)
        private String outType;
        @Option(name="--outpwd", description="password of the destination keystore, as plaintext or PBE-encrypted.\nFor PEM, you may use NONE to save the private key unprotected.")
        private String outPwdHint;
        private static final byte[] CRLF = new byte[]{13, 10};

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object execute0() throws Exception {
            byte[] outBytes;
            File realOutFile;
            block28: {
                KeyStore outKs;
                ByteArrayOutputStream outPemKs;
                File realInFile = new File(IoUtil.expandFilepath((String)this.inFile));
                if (CompareUtil.equalsObject((Object)realInFile, (Object)(realOutFile = new File(IoUtil.expandFilepath((String)this.outFile))))) {
                    throw new IllegalCmdParamException("in and out cannot be the same");
                }
                KeyStore inKs = KeyStore.getInstance(this.inType);
                if ("PEM".equalsIgnoreCase(this.outType)) {
                    outPemKs = new ByteArrayOutputStream();
                    outKs = null;
                } else {
                    outPemKs = null;
                    outKs = KeyUtil.getOutKeyStore((String)this.outType);
                    outKs.load(null);
                }
                try {
                    char[] inPassword = this.readPasswordIfNotSet("password of the source keystore", this.inPwdHint);
                    try (InputStream inStream = Files.newInputStream(realInFile.toPath(), new OpenOption[0]);){
                        inKs.load(inStream, inPassword);
                    }
                    char[] outPassword = (char[])("PEM".equalsIgnoreCase(this.outType) && "NONE".equalsIgnoreCase(this.outPwdHint) ? null : this.readPasswordIfNotSet("password of the destination keystore", this.outPwdHint));
                    OutputEncryptor pemOe = null;
                    if ("PEM".equalsIgnoreCase(this.outType) && outPassword != null) {
                        JceOpenSSLPKCS8EncryptorBuilder eb = new JceOpenSSLPKCS8EncryptorBuilder(PKCS8Generator.PBE_SHA1_3DES);
                        eb.setPassword(outPassword);
                        pemOe = eb.build();
                    }
                    Enumeration<String> aliases = inKs.aliases();
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        if (inKs.isKeyEntry(alias)) {
                            java.security.cert.Certificate[] certs = inKs.getCertificateChain(alias);
                            Key key = inKs.getKey(alias, inPassword);
                            if (outKs != null) {
                                outKs.setKeyEntry(alias, key, outPassword, certs);
                                continue;
                            }
                            if (outPassword == null) {
                                outPemKs.write(PemEncoder.encode((byte[])key.getEncoded(), (PemEncoder.PemLabel)PemEncoder.PemLabel.PRIVATE_KEY));
                            } else {
                                JcaPKCS8Generator gen = new JcaPKCS8Generator((PrivateKey)key, pemOe);
                                PemObject po = gen.generate();
                                outPemKs.write(PemEncoder.encode((byte[])po.getContent(), (PemEncoder.PemLabel)PemEncoder.PemLabel.ENCRYPTED_PRIVATE_KEY));
                            }
                            for (java.security.cert.Certificate cert : certs) {
                                ConvertKeystore.writePemCert(outPemKs, cert);
                            }
                            continue;
                        }
                        java.security.cert.Certificate cert = inKs.getCertificate(alias);
                        if (outKs != null) {
                            outKs.setCertificateEntry(alias, cert);
                            continue;
                        }
                        ConvertKeystore.writePemCert(outPemKs, cert);
                    }
                    if (outPemKs == null) {
                        try (ByteArrayOutputStream bout = new ByteArrayOutputStream(4096);){
                            outKs.store(bout, outPassword);
                            outBytes = bout.toByteArray();
                            break block28;
                        }
                    }
                    outBytes = outPemKs.toByteArray();
                }
                finally {
                    if (outPemKs != null) {
                        outPemKs.close();
                    }
                }
            }
            this.saveVerbose("saved destination keystore to file", realOutFile, outBytes);
            return null;
        }

        private static void writePemCert(OutputStream out, java.security.cert.Certificate cert) throws CertificateEncodingException, IOException {
            out.write(PemEncoder.encode((byte[])cert.getEncoded(), (PemEncoder.PemLabel)PemEncoder.PemLabel.CERTIFICATE));
        }
    }

    @Command(scope="xi", name="cert-info", description="print certificate information")
    @Service
    public static class CertInfo
    extends SecurityAction {
        @Option(name="--in", description="certificate file")
        @Completion(value=FileCompleter.class)
        private String inFile;
        @Option(name="--hex", aliases={"-h"}, description="print hex number")
        private Boolean hex = Boolean.FALSE;
        @Option(name="--serial", description="print serial number")
        private Boolean serial;
        @Option(name="--subject", description="print subject")
        private Boolean subject;
        @Option(name="--issuer", description="print issuer")
        private Boolean issuer;
        @Option(name="--not-before", description="print notBefore")
        private Boolean notBefore;
        @Option(name="--not-after", description="print notAfter")
        private Boolean notAfter;
        @Option(name="--fingerprint", description="print fingerprint in hex")
        private Boolean fingerprint;
        @Option(name="--hash", description="hash algorithm name")
        @Completion(value=Completers.HashAlgCompleter.class)
        protected String hashAlgo = "SHA256";

        protected Object execute0() throws Exception {
            X509Cert cert = X509Util.parseCert((byte[])IoUtil.read((String)this.inFile));
            if (this.serial != null && this.serial.booleanValue()) {
                return this.getNumber(cert.getSerialNumber());
            }
            if (this.subject != null && this.subject.booleanValue()) {
                return cert.getSubject().toString();
            }
            if (this.issuer != null && this.issuer.booleanValue()) {
                return cert.getIssuer().toString();
            }
            if (this.notBefore != null && this.notBefore.booleanValue()) {
                return this.toUtcTimeyyyyMMddhhmmssZ(cert.getNotBefore());
            }
            if (this.notAfter != null && this.notAfter.booleanValue()) {
                return this.toUtcTimeyyyyMMddhhmmssZ(cert.getNotAfter());
            }
            if (this.fingerprint != null && this.fingerprint.booleanValue()) {
                byte[] encoded = cert.getEncoded();
                return HashAlgo.getInstance((String)this.hashAlgo).hexHash((byte[][])new byte[][]{encoded});
            }
            return null;
        }

        private String getNumber(Number no) {
            if (!this.hex.booleanValue()) {
                return no.toString();
            }
            if (no instanceof Byte) {
                return "0x" + Hex.encode((byte[])new byte[]{(Byte)no});
            }
            if (no instanceof Short) {
                return "0x" + Integer.toHexString(((Short)no).shortValue());
            }
            if (no instanceof Integer) {
                return "0x" + Integer.toHexString((Integer)no);
            }
            if (no instanceof Long) {
                return "0x" + Long.toHexString((Long)no);
            }
            if (no instanceof BigInteger) {
                return "0x" + ((BigInteger)no).toString(16);
            }
            return no.toString();
        }
    }
}

