-- IGNORE-ERROR
ALTER TABLE CA DROP FOREIGN KEY FK_CA_CRL_SIGNER1;
-- IGNORE-ERROR
ALTER TABLE CAALIAS DROP FOREIGN KEY FK_CAALIAS_CA1;
-- IGNORE-ERROR
ALTER TABLE CA_HAS_REQUESTOR DROP FOREIGN KEY FK_CA_HAS_REQUESTOR_REQUESTOR1;
-- IGNORE-ERROR
ALTER TABLE CA_HAS_REQUESTOR DROP FOREIGN KEY FK_CA_HAS_REQUESTOR_CA1;
-- IGNORE-ERROR
ALTER TABLE CA_HAS_PUBLISHER DROP FOREIGN KEY FK_CA_HAS_PUBLISHER_PUBLISHER1;
-- IGNORE-ERROR
ALTER TABLE CA_HAS_PUBLISHER DROP FOREIGN KEY FK_CA_HAS_PUBLISHER_CA1;
-- IGNORE-ERROR
ALTER TABLE CA_HAS_PROFILE DROP FOREIGN KEY FK_CA_HAS_PROFILE_PROFILE1;
-- IGNORE-ERROR
ALTER TABLE CA_HAS_PROFILE DROP FOREIGN KEY FK_CA_HAS_PROFILE_CA1;
-- IGNORE-ERROR
ALTER TABLE CRL DROP FOREIGN KEY FK_CRL_CA1;
-- IGNORE-ERROR
ALTER TABLE CERT DROP FOREIGN KEY FK_CERT_CA1;
-- IGNORE-ERROR
ALTER TABLE CERT DROP FOREIGN KEY FK_CERT_REQUESTOR1;
-- IGNORE-ERROR
ALTER TABLE CERT DROP FOREIGN KEY FK_CERT_PROFILE1;
-- IGNORE-ERROR
ALTER TABLE PUBLISHQUEUE DROP FOREIGN KEY FK_PUBLISHQUEUE_PUBLISHER1;
-- IGNORE-ERROR
ALTER TABLE PUBLISHQUEUE DROP FOREIGN KEY FK_PUBLISHQUEUE_CERT1;

DROP TABLE IF EXISTS DBSCHEMA;
DROP TABLE IF EXISTS SYSTEM_EVENT;
DROP TABLE IF EXISTS KEYPAIR_GEN;
DROP TABLE IF EXISTS SIGNER;
DROP TABLE IF EXISTS REQUESTOR;
DROP TABLE IF EXISTS PUBLISHER;
DROP TABLE IF EXISTS PROFILE;
DROP TABLE IF EXISTS CA;
DROP TABLE IF EXISTS CAALIAS;
DROP TABLE IF EXISTS CA_HAS_REQUESTOR;
DROP TABLE IF EXISTS CA_HAS_PUBLISHER;
DROP TABLE IF EXISTS CA_HAS_PROFILE;

DROP TABLE IF EXISTS CRL;
DROP TABLE IF EXISTS CERT;
DROP TABLE IF EXISTS PUBLISHQUEUE;

-- changeset xipki:1
CREATE TABLE DBSCHEMA (
    NAME VARCHAR(45) NOT NULL,
    VALUE2 VARCHAR(100) NOT NULL,
    CONSTRAINT PK_DBSCHEMA PRIMARY KEY (NAME)
);

INSERT INTO DBSCHEMA (NAME, VALUE2) VALUES ('VENDOR', 'XIPKI');
INSERT INTO DBSCHEMA (NAME, VALUE2) VALUES ('VERSION', '7');
INSERT INTO DBSCHEMA (NAME, VALUE2) VALUES ('X500NAME_MAXLEN', '350');

CREATE TABLE SYSTEM_EVENT (
    NAME VARCHAR(45) NOT NULL,
    EVENT_TIME BIGINT NOT NULL COMMENT 'seconds since January 1, 1970, 00:00:00 GMT',
    EVENT_TIME2 timestamp NULL,
    EVENT_OWNER VARCHAR(255) NOT NULL,
    CONSTRAINT PK_SYSTEM_EVENT PRIMARY KEY (NAME)
);

CREATE TABLE KEYPAIR_GEN (
    NAME VARCHAR(45) NOT NULL,
    TYPE VARCHAR(100) NOT NULL,
    CONF LONGTEXT NULL,
    CONSTRAINT PK_KEYPAIR_GEN PRIMARY KEY (NAME)
);

INSERT INTO KEYPAIR_GEN (NAME, TYPE) VALUES ('software', 'SOFTWARE');

CREATE TABLE SIGNER (
    NAME VARCHAR(45) NOT NULL,
    TYPE VARCHAR(100) NOT NULL,
    CERT VARCHAR(6000) NULL,
    CONF LONGTEXT NULL,
    CONSTRAINT PK_SIGNER PRIMARY KEY (NAME)
);

CREATE TABLE REQUESTOR (
    ID SMALLINT NOT NULL,
    NAME VARCHAR(45) NOT NULL,
    TYPE VARCHAR(100) NOT NULL,
    CONF LONGTEXT NULL,
    CONSTRAINT PK_REQUESTOR PRIMARY KEY (ID)
);

ALTER TABLE REQUESTOR ADD CONSTRAINT CONST_REQUESTOR_NAME UNIQUE (NAME);

CREATE TABLE PUBLISHER (
    ID SMALLINT NOT NULL,
    NAME VARCHAR(45) NOT NULL COMMENT 'duplication is not permitted',
    TYPE VARCHAR(100) NOT NULL,
    CONF LONGTEXT NULL,
    CONSTRAINT PK_PUBLISHER PRIMARY KEY (ID)
);

ALTER TABLE PUBLISHER ADD CONSTRAINT CONST_PUBLISHER_NAME UNIQUE (NAME);

CREATE TABLE PROFILE (
    ID SMALLINT NOT NULL,
    NAME VARCHAR(45) NOT NULL COMMENT 'duplication is not permitted',
    TYPE VARCHAR(100) NOT NULL,
    CONF LONGTEXT NULL COMMENT 'profile data, depends on the type',
    CONSTRAINT PK_PROFILE PRIMARY KEY (ID)
 );

ALTER TABLE PROFILE ADD CONSTRAINT CONST_PROFILE_NAME UNIQUE (NAME);

CREATE TABLE CA (
    ID SMALLINT NOT NULL,
    NAME VARCHAR(45) NOT NULL COMMENT 'duplication is not permitted',
    STATUS VARCHAR(10) NOT NULL COMMENT 'valid values: active, inactive',
    NEXT_CRLNO BIGINT NULL,
    CRL_SIGNER_NAME VARCHAR(45) NULL,
    SUBJECT VARCHAR(350) NOT NULL,
    REV_INFO VARCHAR(200) NULL COMMENT 'CA revocation information',
    CERT VARCHAR(6000) NOT NULL,
    SIGNER_TYPE VARCHAR(100) NOT NULL,
    SIGNER_CONF LONGTEXT NOT NULL,
    CERTCHAIN LONGTEXT NULL COMMENT 'Certificate chain without CA''s certificate',
    CONF LONGTEXT NOT NULL, CONSTRAINT PK_CA PRIMARY KEY (ID)
);

ALTER TABLE CA ADD CONSTRAINT CONST_CA_NAME UNIQUE (NAME);

CREATE TABLE CAALIAS (
    NAME VARCHAR(45) NOT NULL,
    CA_ID SMALLINT NOT NULL,
    CONSTRAINT PK_CAALIAS PRIMARY KEY (NAME)
);

CREATE TABLE CA_HAS_REQUESTOR (
    CA_ID SMALLINT NOT NULL,
    REQUESTOR_ID SMALLINT NOT NULL,
    PERMISSION INT NULL,
    PROFILES VARCHAR(500) NULL,
    CONSTRAINT PK_CA_HAS_REQUESTOR PRIMARY KEY (CA_ID, REQUESTOR_ID)
);

CREATE TABLE CA_HAS_PUBLISHER (
    CA_ID SMALLINT NOT NULL,
    PUBLISHER_ID SMALLINT NOT NULL,
    CONSTRAINT PK_CA_HAS_PUBLISHER PRIMARY KEY (CA_ID, PUBLISHER_ID)
);

CREATE TABLE CA_HAS_PROFILE (
    CA_ID SMALLINT NOT NULL,
    PROFILE_ID SMALLINT NOT NULL,
    CONSTRAINT PK_CA_HAS_PROFILE PRIMARY KEY (CA_ID, PROFILE_ID)
);

-- changeset xipki:2
CREATE TABLE CRL (
    ID INT NOT NULL,
    CA_ID SMALLINT NOT NULL,
    CRL_SCOPE SMALLINT NOT NULL COMMENT 'CRL scope, reserved for future use',
    CRL_NO BIGINT NOT NULL,
    THISUPDATE BIGINT NOT NULL,
    NEXTUPDATE BIGINT NULL,
    DELTACRL SMALLINT NOT NULL,
    BASECRL_NO BIGINT NULL,
    SHA1 CHAR(28) NOT NULL COMMENT 'base64 encoded SHA1 fingerprint of the CRL',
    CRL LONGTEXT NOT NULL, CONSTRAINT PK_CRL PRIMARY KEY (ID)
 );

ALTER TABLE CRL ADD CONSTRAINT CONST_CA_CRLNO UNIQUE (CA_ID, CRL_NO);

CREATE TABLE CERT (
    ID BIGINT NOT NULL,
    CA_ID SMALLINT NOT NULL COMMENT 'Issuer (CA) id',
    SN VARCHAR(40) NOT NULL COMMENT 'serial number',
    PID SMALLINT NOT NULL COMMENT 'certificate profile id',
    RID SMALLINT NULL COMMENT 'requestor id',
    FP_S BIGINT NOT NULL COMMENT 'first 8 bytes of the SHA1 sum of the subject',
    FP_SAN BIGINT NULL COMMENT 'first 8 bytes of the SHA1 sum of the extension value of SubjectAltNames',
    FP_RS BIGINT NULL COMMENT 'first 8 bytes of the SHA1 sum of the requested subject',
    LUPDATE BIGINT NOT NULL COMMENT 'last update, seconds since January 1, 1970, 00:00:00 GMT',
    NBEFORE BIGINT NOT NULL COMMENT 'notBefore, seconds since January 1, 1970, 00:00:00 GMT',
    NAFTER BIGINT NOT NULL COMMENT 'notAfter, seconds since January 1, 1970, 00:00:00 GMT',
    REV SMALLINT NOT NULL COMMENT 'whether the certificate is revoked',
    RR SMALLINT NULL COMMENT 'revocation reason',
    RT BIGINT NULL COMMENT 'revocation time, seconds since January 1, 1970, 00:00:00 GMT',
    RIT BIGINT NULL COMMENT 'revocation invalidity time, seconds since January 1, 1970, 00:00:00 GMT',
    EE SMALLINT NOT NULL COMMENT 'whether it is an end entity cert',
    SUBJECT VARCHAR(350) NOT NULL,
    TID VARCHAR(43) NULL COMMENT 'base64 encoded transactionId, maximal 256 bit',
    CRL_SCOPE SMALLINT NOT NULL COMMENT 'CRL scope, reserved for future use',
    SHA1 CHAR(28) NOT NULL COMMENT 'base64 encoded SHA1 fingerprint of the certificate',
    REQ_SUBJECT VARCHAR(350) NULL, CERT VARCHAR(6000) NOT NULL COMMENT 'Base64 encoded certificate',
    PRIVATE_KEY VARCHAR(6000) NULL COMMENT 'Base64-encoded encrypted PKCS#8 private key',
    CONSTRAINT PK_CERT PRIMARY KEY (ID)
);

ALTER TABLE CERT ADD CONSTRAINT CONST_CA_SN UNIQUE (CA_ID, SN);

CREATE INDEX IDX_CA_FPS ON CERT(CA_ID, FP_S, FP_SAN);

CREATE TABLE PUBLISHQUEUE (
    CID BIGINT NOT NULL,
    PID SMALLINT NOT NULL,
    CA_ID SMALLINT NOT NULL
);

-- changeset xipki:3
ALTER TABLE CA ADD CONSTRAINT FK_CA_CRL_SIGNER1
    FOREIGN KEY (CRL_SIGNER_NAME) REFERENCES SIGNER (NAME)
    ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE CAALIAS ADD CONSTRAINT FK_CAALIAS_CA1
    FOREIGN KEY (CA_ID) REFERENCES CA (ID)
    ON UPDATE NO ACTION ON DELETE CASCADE;

ALTER TABLE CA_HAS_REQUESTOR ADD CONSTRAINT FK_CA_HAS_REQUESTOR_REQUESTOR1
    FOREIGN KEY (REQUESTOR_ID) REFERENCES REQUESTOR (ID)
    ON UPDATE NO ACTION ON DELETE CASCADE;

ALTER TABLE CA_HAS_REQUESTOR ADD CONSTRAINT FK_CA_HAS_REQUESTOR_CA1
    FOREIGN KEY (CA_ID) REFERENCES CA (ID)
    ON UPDATE NO ACTION ON DELETE CASCADE;

ALTER TABLE CA_HAS_PUBLISHER ADD CONSTRAINT FK_CA_HAS_PUBLISHER_PUBLISHER1
    FOREIGN KEY (PUBLISHER_ID) REFERENCES PUBLISHER (ID)
    ON UPDATE NO ACTION ON DELETE CASCADE;

ALTER TABLE CA_HAS_PUBLISHER ADD CONSTRAINT FK_CA_HAS_PUBLISHER_CA1
    FOREIGN KEY (CA_ID) REFERENCES CA (ID)
    ON UPDATE NO ACTION ON DELETE CASCADE;

ALTER TABLE CA_HAS_PROFILE ADD CONSTRAINT FK_CA_HAS_PROFILE_PROFILE1
    FOREIGN KEY (PROFILE_ID) REFERENCES PROFILE (ID)
    ON UPDATE NO ACTION ON DELETE CASCADE;

ALTER TABLE CA_HAS_PROFILE ADD CONSTRAINT FK_CA_HAS_PROFILE_CA1
    FOREIGN KEY (CA_ID) REFERENCES CA (ID)
    ON UPDATE NO ACTION ON DELETE CASCADE;

-- changeset xipki:4
ALTER TABLE CRL ADD CONSTRAINT FK_CRL_CA1
    FOREIGN KEY (CA_ID) REFERENCES CA (ID)
    ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE CERT ADD CONSTRAINT FK_CERT_CA1
    FOREIGN KEY (CA_ID) REFERENCES CA (ID)
    ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE CERT ADD CONSTRAINT FK_CERT_REQUESTOR1
    FOREIGN KEY (RID) REFERENCES REQUESTOR (ID)
    ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE CERT ADD CONSTRAINT FK_CERT_PROFILE1
    FOREIGN KEY (PID) REFERENCES PROFILE (ID)
    ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE PUBLISHQUEUE ADD CONSTRAINT FK_PUBLISHQUEUE_PUBLISHER1
    FOREIGN KEY (PID) REFERENCES PUBLISHER (ID)
    ON UPDATE NO ACTION ON DELETE CASCADE;

ALTER TABLE PUBLISHQUEUE ADD CONSTRAINT FK_PUBLISHQUEUE_CERT1
    FOREIGN KEY (CID) REFERENCES CERT (ID)
    ON UPDATE NO ACTION ON DELETE CASCADE;

