/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.certprofile.xijson;

import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.qualified.TypeOfBiometricData;
import org.xipki.ca.certprofile.xijson.conf.Describable;
import org.xipki.ca.certprofile.xijson.conf.extn.BiometricInfo;
import org.xipki.security.HashAlgo;
import org.xipki.util.Args;
import org.xipki.util.TripleState;

public class BiometricInfoOption {
    private final Set<Integer> predefinedTypes;
    private final Set<ASN1ObjectIdentifier> idTypes;
    private final Set<HashAlgo> hashAlgorithms;
    private final TripleState sourceDataUriOccurrence;

    public BiometricInfoOption(BiometricInfo value) throws NoSuchAlgorithmException {
        Args.notNull((Object)((Object)value), (String)"value");
        this.sourceDataUriOccurrence = value.getIncludeSourceDataUri();
        this.hashAlgorithms = new HashSet<HashAlgo>();
        for (Describable.DescribableOid doid : value.getHashAlgorithms()) {
            this.hashAlgorithms.add(HashAlgo.getInstance((String)doid.getOid()));
        }
        this.predefinedTypes = new HashSet<Integer>();
        this.idTypes = new HashSet<ASN1ObjectIdentifier>();
        for (BiometricInfo.BiometricTypeType m : value.getTypes()) {
            if (m.getPredefined() != null) {
                this.predefinedTypes.add(m.getPredefined().getValue());
                continue;
            }
            if (m.getOid() != null) {
                this.idTypes.add(new ASN1ObjectIdentifier(m.getOid().getOid()));
                continue;
            }
            throw new IllegalStateException("should not reach here, invalid biometricType");
        }
    }

    public boolean isTypePermitted(TypeOfBiometricData type) {
        return ((TypeOfBiometricData)Args.notNull((Object)type, (String)"type")).isPredefined() ? this.predefinedTypes.contains(type.getPredefinedBiometricType()) : this.idTypes.contains(type.getBiometricDataOid());
    }

    public boolean isHashAlgorithmPermitted(HashAlgo hashAlgorithm) {
        return this.hashAlgorithms.contains(Args.notNull((Object)hashAlgorithm, (String)"hashAlgorithm"));
    }

    public TripleState getSourceDataUriOccurrence() {
        return this.sourceDataUriOccurrence;
    }
}

