/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.certprofile.xijson.conf;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.certprofile.xijson.conf.Describable;
import org.xipki.util.StringUtil;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;

public class GeneralNameType
extends ValidableConf {
    private List<String> modes;

    public List<String> getModes() {
        if (this.modes == null) {
            this.modes = new LinkedList<String>();
        }
        return this.modes;
    }

    public void setModes(List<String> modes) {
        this.modes = modes;
    }

    public Set<Certprofile.GeneralNameMode> toGeneralNameModes() throws CertprofileException {
        if (this.modes == null || this.modes.isEmpty()) {
            throw new CertprofileException("GeneralNameType may not be empty");
        }
        HashSet<Certprofile.GeneralNameMode> ret = new HashSet<Certprofile.GeneralNameMode>();
        for (String m : this.modes) {
            if (StringUtil.startsWithIgnoreCase((String)m, (String)"otherName:")) {
                String[] oids = m.substring("otherName:".length()).split(",");
                HashSet<ASN1ObjectIdentifier> set = new HashSet<ASN1ObjectIdentifier>();
                for (String oid : oids) {
                    set.add(new ASN1ObjectIdentifier(oid));
                }
                ret.add(new Certprofile.GeneralNameMode(Certprofile.GeneralNameTag.otherName, set));
                continue;
            }
            for (Certprofile.GeneralNameTag tag : Certprofile.GeneralNameTag.values()) {
                if (tag == Certprofile.GeneralNameTag.otherName || !tag.name().equalsIgnoreCase(m)) continue;
                ret.add(new Certprofile.GeneralNameMode(tag));
            }
        }
        if (ret.isEmpty()) {
            throw new CertprofileException("GeneralNameType may not be empty");
        }
        return ret;
    }

    public void addTags(Certprofile.GeneralNameTag ... tags) {
        for (Certprofile.GeneralNameTag tag : tags) {
            if (tag != Certprofile.GeneralNameTag.otherName) continue;
            throw new IllegalArgumentException("tag otherName  is not allowed");
        }
        for (Certprofile.GeneralNameTag tag : tags) {
            this.getModes().add(tag.name());
        }
    }

    public void addOtherNames(Describable.DescribableOid ... oids) {
        StringBuilder sb = new StringBuilder("otherName:");
        for (int i = 0; i < oids.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(oids[i].getOid());
        }
        this.getModes().add(sb.toString());
    }

    public void validate() throws InvalidConfException {
        GeneralNameType.notEmpty(this.modes, (String)"modes");
    }
}

