/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.certprofile.xijson.conf.extn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyQualifierId;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.bouncycastle.asn1.x509.UserNotice;
import org.xipki.ca.certprofile.xijson.CertificatePolicyInformation;
import org.xipki.ca.certprofile.xijson.CertificatePolicyQualifier;
import org.xipki.ca.certprofile.xijson.conf.Describable;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;

public class CertificatePolicies
extends ValidableConf {
    private List<CertificatePolicyInformationType> certificatePolicyInformations;

    public List<CertificatePolicyInformationType> getCertificatePolicyInformations() {
        if (this.certificatePolicyInformations == null) {
            this.certificatePolicyInformations = new LinkedList<CertificatePolicyInformationType>();
        }
        return this.certificatePolicyInformations;
    }

    public void setCertificatePolicyInformations(List<CertificatePolicyInformationType> certificatePolicyInformations) {
        this.certificatePolicyInformations = certificatePolicyInformations;
    }

    public void validate() throws InvalidConfException {
        CertificatePolicies.notEmpty(this.certificatePolicyInformations, (String)"certificatePolicyInformations");
        CertificatePolicies.validate(this.certificatePolicyInformations, (Collection[])new Collection[0]);
    }

    public org.bouncycastle.asn1.x509.CertificatePolicies toXiCertificatePolicies() {
        List<CertificatePolicyInformationType> policyPairs = this.getCertificatePolicyInformations();
        ArrayList<CertificatePolicyInformation> policyInfos = new ArrayList<CertificatePolicyInformation>(policyPairs.size());
        for (CertificatePolicyInformationType policyPair : policyPairs) {
            ArrayList<CertificatePolicyQualifier> qualifiers = null;
            List<PolicyQualifier> policyQualifiers = policyPair.getPolicyQualifiers();
            if (!policyQualifiers.isEmpty()) {
                qualifiers = new ArrayList<CertificatePolicyQualifier>(policyQualifiers.size());
                for (PolicyQualifier m : policyQualifiers) {
                    CertificatePolicyQualifier qualifier = m.getType() == PolicyQualfierType.cpsUri ? CertificatePolicyQualifier.getInstanceForCpsUri(m.getValue()) : CertificatePolicyQualifier.getInstanceForUserNotice(m.getValue());
                    qualifiers.add(qualifier);
                }
            }
            policyInfos.add(new CertificatePolicyInformation(policyPair.getPolicyIdentifier().getOid(), qualifiers));
        }
        int size = policyInfos.size();
        PolicyInformation[] infos = new PolicyInformation[size];
        int idx = 0;
        for (CertificatePolicyInformation policyInfo : policyInfos) {
            List<CertificatePolicyQualifier> qualifiers = policyInfo.getQualifiers();
            ASN1Sequence policyQualifiers = CollectionUtil.isEmpty(qualifiers) ? null : CertificatePolicies.createPolicyQualifiers(qualifiers);
            ASN1ObjectIdentifier policyOid = new ASN1ObjectIdentifier(policyInfo.getCertPolicyId());
            infos[idx++] = policyQualifiers == null ? new PolicyInformation(policyOid) : new PolicyInformation(policyOid, policyQualifiers);
        }
        return new org.bouncycastle.asn1.x509.CertificatePolicies(infos);
    }

    private static ASN1Sequence createPolicyQualifiers(List<CertificatePolicyQualifier> qualifiers) {
        Args.notNull(qualifiers, (String)"qualifiers");
        ASN1EncodableVector qualifierInfos = new ASN1EncodableVector();
        for (CertificatePolicyQualifier qualifier : qualifiers) {
            PolicyQualifierInfo qualifierInfo;
            if (qualifier.getCpsUri() != null) {
                qualifierInfo = new PolicyQualifierInfo(qualifier.getCpsUri());
            } else if (qualifier.getUserNotice() != null) {
                UserNotice userNotice = new UserNotice(null, qualifier.getUserNotice());
                qualifierInfo = new PolicyQualifierInfo((ASN1ObjectIdentifier)PolicyQualifierId.id_qt_unotice, (ASN1Encodable)userNotice);
            } else {
                qualifierInfo = null;
            }
            if (qualifierInfo == null) continue;
            qualifierInfos.add((ASN1Encodable)qualifierInfo);
        }
        return new DERSequence(qualifierInfos);
    }

    public static class CertificatePolicyInformationType
    extends ValidableConf {
        private Describable.DescribableOid policyIdentifier;
        private List<PolicyQualifier> policyQualifiers;

        public Describable.DescribableOid getPolicyIdentifier() {
            return this.policyIdentifier;
        }

        public void setPolicyIdentifier(Describable.DescribableOid policyIdentifier) {
            this.policyIdentifier = policyIdentifier;
        }

        public List<PolicyQualifier> getPolicyQualifiers() {
            if (this.policyQualifiers == null) {
                this.policyQualifiers = new LinkedList<PolicyQualifier>();
            }
            return this.policyQualifiers;
        }

        public void setPolicyQualifiers(List<PolicyQualifier> policyQualifiers) {
            this.policyQualifiers = policyQualifiers;
        }

        public void validate() throws InvalidConfException {
            CertificatePolicyInformationType.notNull((Object)((Object)this.policyIdentifier), (String)"policyIdentifier");
            CertificatePolicyInformationType.validate((ValidableConf)this.policyIdentifier, (ValidableConf[])new ValidableConf[0]);
            CertificatePolicyInformationType.validate(this.policyQualifiers, (Collection[])new Collection[0]);
        }
    }

    public static class PolicyQualifier
    extends ValidableConf {
        private PolicyQualfierType type;
        private String value;

        public PolicyQualfierType getType() {
            return this.type;
        }

        public void setType(PolicyQualfierType type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void validate() throws InvalidConfException {
            PolicyQualifier.notNull((Object)((Object)this.type), (String)"type");
            PolicyQualifier.notBlank((String)this.value, (String)"value");
        }
    }

    public static enum PolicyQualfierType {
        cpsUri,
        userNotice;

    }
}

