/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.certprofile.xijson.conf.extn;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.certprofile.xijson.conf.Describable;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;

public class ExtendedKeyUsage
extends ValidableConf {
    private List<Usage> usages;

    public List<Usage> getUsages() {
        if (this.usages == null) {
            this.usages = new LinkedList<Usage>();
        }
        return this.usages;
    }

    public void setUsages(List<Usage> usages) {
        this.usages = usages;
    }

    public void validate() throws InvalidConfException {
        ExtendedKeyUsage.notEmpty(this.usages, (String)"usages");
        ExtendedKeyUsage.validate(this.usages, (Collection[])new Collection[0]);
    }

    public Set<Certprofile.ExtKeyUsageControl> toXiExtKeyUsageOptions() {
        List<Usage> usages = this.getUsages();
        HashSet<Certprofile.ExtKeyUsageControl> controls = new HashSet<Certprofile.ExtKeyUsageControl>();
        for (Usage m : usages) {
            controls.add(new Certprofile.ExtKeyUsageControl(new ASN1ObjectIdentifier(m.getOid()), m.isRequired()));
        }
        return Collections.unmodifiableSet(controls);
    }

    public static class Usage
    extends Describable.DescribableOid {
        private boolean required;

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }
    }
}

