/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.certprofile.xijson.conf.extn;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.xipki.ca.certprofile.xijson.conf.Describable;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;

public class QcStatements
extends ValidableConf {
    private List<QcStatementType> qcStatements;

    public List<QcStatementType> getQcStatements() {
        if (this.qcStatements == null) {
            this.qcStatements = new LinkedList<QcStatementType>();
        }
        return this.qcStatements;
    }

    public void setQcStatements(List<QcStatementType> qcStatements) {
        this.qcStatements = qcStatements;
    }

    public void validate() throws InvalidConfException {
        QcStatements.notEmpty(this.qcStatements, (String)"qcStatements");
        QcStatements.validate(this.qcStatements, (Collection[])new Collection[0]);
    }

    public static class QcStatementType
    extends ValidableConf {
        private Describable.DescribableOid statementId;
        private QcStatementValueType statementValue;

        public Describable.DescribableOid getStatementId() {
            return this.statementId;
        }

        public void setStatementId(Describable.DescribableOid statementId) {
            this.statementId = statementId;
        }

        public QcStatementValueType getStatementValue() {
            return this.statementValue;
        }

        public void setStatementValue(QcStatementValueType statementValue) {
            this.statementValue = statementValue;
        }

        public void validate() throws InvalidConfException {
            QcStatementType.notNull((Object)((Object)this.statementId), (String)"statementId");
            QcStatementType.validate((ValidableConf)this.statementId, (ValidableConf[])new ValidableConf[]{this.statementValue});
        }
    }

    public static class QcStatementValueType
    extends ValidableConf {
        private Describable.DescribableBinary constant;
        private Integer qcRetentionPeriod;
        private QcEuLimitValueType qcEuLimitValue;
        private List<PdsLocationType> pdsLocations;

        public Describable.DescribableBinary getConstant() {
            return this.constant;
        }

        public void setConstant(Describable.DescribableBinary constant) {
            this.constant = constant;
        }

        public Integer getQcRetentionPeriod() {
            return this.qcRetentionPeriod;
        }

        public void setQcRetentionPeriod(Integer qcRetentionPeriod) {
            this.qcRetentionPeriod = qcRetentionPeriod;
        }

        public QcEuLimitValueType getQcEuLimitValue() {
            return this.qcEuLimitValue;
        }

        public void setQcEuLimitValue(QcEuLimitValueType qcEuLimitValue) {
            this.qcEuLimitValue = qcEuLimitValue;
        }

        public List<PdsLocationType> getPdsLocations() {
            return this.pdsLocations;
        }

        public void setPdsLocations(List<PdsLocationType> pdsLocations) {
            this.pdsLocations = pdsLocations;
        }

        public void validate() throws InvalidConfException {
            int num = 0;
            if (this.constant != null) {
                ++num;
            }
            if (this.qcRetentionPeriod != null) {
                ++num;
            }
            if (this.qcEuLimitValue != null) {
                ++num;
            }
            if (CollectionUtil.isNotEmpty(this.pdsLocations)) {
                ++num;
            }
            if (num != 1) {
                throw new InvalidConfException("Not exactly one of constant, qcRetentionPeriod, qcEuLimitValue, pdsLocations is set");
            }
            QcStatementValueType.validate((ValidableConf)this.constant, (ValidableConf[])new ValidableConf[]{this.qcEuLimitValue});
            QcStatementValueType.validate(this.pdsLocations, (Collection[])new Collection[0]);
        }
    }

    public static class PdsLocationType
    extends ValidableConf {
        private String url;
        private String language;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public void validate() throws InvalidConfException {
            PdsLocationType.notBlank((String)this.url, (String)"url");
            PdsLocationType.notBlank((String)this.language, (String)"language");
        }
    }

    public static class QcEuLimitValueType
    extends ValidableConf {
        private String currency;
        private Range2Type amount;
        private Range2Type exponent;

        public String getCurrency() {
            return this.currency;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }

        public Range2Type getAmount() {
            return this.amount;
        }

        public void setAmount(Range2Type amount) {
            this.amount = amount;
        }

        public Range2Type getExponent() {
            return this.exponent;
        }

        public void setExponent(Range2Type exponent) {
            this.exponent = exponent;
        }

        public void validate() throws InvalidConfException {
            QcEuLimitValueType.notBlank((String)this.currency, (String)"currency");
            QcEuLimitValueType.notNull((Object)((Object)this.amount), (String)"amount");
            QcEuLimitValueType.notNull((Object)((Object)this.exponent), (String)"exponent");
            QcEuLimitValueType.validate((ValidableConf)this.amount, (ValidableConf[])new ValidableConf[]{this.exponent});
        }
    }

    public static class Range2Type
    extends ValidableConf {
        private int min;
        private int max;

        public int getMin() {
            return this.min;
        }

        public void setMin(int min) {
            this.min = min;
        }

        public int getMax() {
            return this.max;
        }

        public void setMax(int max) {
            this.max = max;
        }

        public void validate() throws InvalidConfException {
        }
    }
}

