/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xipki.ca.gateway.acme.AcmeChallenge;
import org.xipki.ca.gateway.acme.AcmeIdentifier;
import org.xipki.ca.gateway.acme.AcmeOrder;
import org.xipki.ca.gateway.acme.AcmeUtils;
import org.xipki.ca.gateway.acme.AuthzId;
import org.xipki.ca.gateway.acme.msg.AuthzResponse;
import org.xipki.ca.gateway.acme.msg.ChallengeResponse;
import org.xipki.ca.gateway.acme.type.AuthzStatus;
import org.xipki.util.Args;
import org.xipki.util.CompareUtil;
import org.xipki.util.JSON;

public class AcmeAuthz {
    private final int subId;
    private final AcmeIdentifier identifier;
    private AuthzStatus status;
    private Instant expires;
    private List<AcmeChallenge> challenges;
    private AcmeOrder order;

    public AcmeAuthz(int subId, AcmeIdentifier identifier) {
        this.subId = (Integer)Args.notNull((Object)subId, (String)"subId");
        this.identifier = (AcmeIdentifier)Args.notNull((Object)identifier, (String)"identifier");
    }

    public Map<String, Object> encode() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("subId", this.subId);
        map.put("identifier", this.identifier.encode());
        if (this.status != null) {
            map.put("status", this.status.name());
        }
        if (this.expires != null) {
            map.put("expires", this.expires.getEpochSecond());
        }
        if (this.challenges != null) {
            ArrayList<Map<String, Object>> challMaps = new ArrayList<Map<String, Object>>(this.challenges.size());
            for (AcmeChallenge m : this.challenges) {
                challMaps.add(m.encode());
            }
            map.put("challenges", challMaps);
        }
        return map;
    }

    public static AcmeAuthz decode(Map<String, Object> encoded) {
        int subId = AcmeUtils.getInt(encoded, "subId");
        AcmeIdentifier identifier = AcmeIdentifier.decode((Map)encoded.get("identifier"));
        String str = (String)encoded.get("status");
        AuthzStatus status = str == null ? null : AuthzStatus.valueOf(str);
        Long l = AcmeUtils.getLong(encoded, "expires");
        Instant expires = l == null ? null : Instant.ofEpochSecond(l);
        List challMaps = (List)encoded.get("challenges");
        AcmeAuthz authz = new AcmeAuthz(subId, identifier);
        ArrayList<AcmeChallenge> challenges = null;
        if (challMaps != null) {
            challenges = new ArrayList<AcmeChallenge>(challMaps.size());
            for (Map m : challMaps) {
                AcmeChallenge chall = AcmeChallenge.decode(m);
                chall.setAuthz(authz);
                challenges.add(chall);
            }
        }
        authz.status = status;
        authz.expires = expires;
        authz.challenges = challenges;
        return authz;
    }

    public AcmeOrder getOrder() {
        return this.order;
    }

    public void setOrder(AcmeOrder order) {
        this.order = order;
    }

    public int getSubId() {
        return this.subId;
    }

    public AuthzStatus getStatus() {
        return this.status;
    }

    public void setStatus(AuthzStatus status) {
        this.markOrder();
        this.status = status;
    }

    public Instant getExpires() {
        return this.expires;
    }

    public void setExpires(Instant expires) {
        this.markOrder();
        this.expires = expires;
    }

    public AcmeIdentifier getIdentifier() {
        return this.identifier;
    }

    public List<AcmeChallenge> getChallenges() {
        return this.challenges;
    }

    public void setChallenges(List<AcmeChallenge> challenges) {
        this.markOrder();
        this.challenges = challenges;
        if (challenges != null) {
            for (AcmeChallenge chall : challenges) {
                chall.setAuthz(this);
            }
        }
    }

    void markOrder() {
        if (this.order != null) {
            this.order.markMe();
        }
    }

    public AuthzResponse toResponse(String baseUrl, long orderId) {
        AuthzResponse resp = new AuthzResponse();
        resp.setExpires(this.expires.toString());
        resp.setStatus(this.status);
        resp.setIdentifier(this.identifier.toIdentifier());
        ArrayList<ChallengeResponse> challResps = new ArrayList<ChallengeResponse>(this.challenges.size());
        resp.setChallenges(challResps);
        for (AcmeChallenge chall : this.challenges) {
            challResps.add(chall.toChallengeResponse(baseUrl, orderId, this.subId));
        }
        return resp;
    }

    public String getUrl(String baseUrl) {
        AuthzId authzId = new AuthzId(this.order.getId(), this.subId);
        return baseUrl + "authz/" + authzId.toIdText();
    }

    public boolean equals(Object other) {
        if (!(other instanceof AcmeAuthz)) {
            return false;
        }
        AcmeAuthz b = (AcmeAuthz)other;
        return this.status == b.status && this.subId == b.subId && CompareUtil.equalsObject((Object)this.expires, (Object)b.expires) && CompareUtil.equalsObject((Object)this.identifier, (Object)b.identifier) && CompareUtil.equalsObject(this.challenges, b.challenges);
    }

    public AcmeAuthz copy() {
        AcmeAuthz copy = new AcmeAuthz(this.subId, this.identifier);
        copy.status = this.status;
        copy.expires = this.expires;
        if (this.challenges != null) {
            copy.challenges = new ArrayList<AcmeChallenge>(this.challenges.size());
            for (AcmeChallenge chall : this.challenges) {
                copy.challenges.add(chall.copy());
            }
        }
        return copy;
    }

    public static String encodeAuthzs(List<AcmeAuthz> authzs) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(authzs.size());
        for (AcmeAuthz m : authzs) {
            maps.add(m.encode());
        }
        return JSON.toJson(maps);
    }

    public static List<AcmeAuthz> decodeAuthzs(String encoded) {
        List list = (List)JSON.parseObject((String)encoded, List.class);
        ArrayList<AcmeAuthz> ret = new ArrayList<AcmeAuthz>(list.size());
        for (Map map : list) {
            ret.add(AcmeAuthz.decode(map));
        }
        return ret;
    }
}

