/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.est;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditStatus;
import org.xipki.ca.gateway.GatewayUtil;
import org.xipki.ca.gateway.PopControl;
import org.xipki.ca.gateway.Requestor;
import org.xipki.ca.gateway.RequestorAuthenticator;
import org.xipki.ca.gateway.conf.CaProfileConf;
import org.xipki.ca.gateway.conf.CaProfilesControl;
import org.xipki.ca.sdk.CertprofileInfoResponse;
import org.xipki.ca.sdk.CertsMode;
import org.xipki.ca.sdk.EnrollCertsRequest;
import org.xipki.ca.sdk.EnrollOrPollCertsResponse;
import org.xipki.ca.sdk.KeyType;
import org.xipki.ca.sdk.OldCertInfo;
import org.xipki.ca.sdk.SdkClient;
import org.xipki.ca.sdk.SdkErrorResponseException;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.pki.ErrorCode;
import org.xipki.pki.OperationException;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SecurityFactory;
import org.xipki.security.X509Cert;
import org.xipki.security.util.TlsHelper;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.PemEncoder;
import org.xipki.util.StringUtil;
import org.xipki.util.http.HttpRespContent;
import org.xipki.util.http.HttpResponse;
import org.xipki.util.http.XiHttpRequest;

public class EstResponder {
    private static final byte[] NEWLINE = new byte[]{13, 10};
    private static final byte[] __NEWLINE = new byte[]{45, 45, 13, 10};
    private static final String CMD_cacerts = "cacerts";
    private static final String CMD_simpleenroll = "simpleenroll";
    private static final String CMD_simplereenroll = "simplereenroll";
    private static final String CMD_serverkeygen = "serverkeygen";
    private static final String CMD_ucacert = "ucacert";
    private static final String CMD_ucacerts = "ucacerts";
    private static final String CMD_ucrl = "ucrl";
    private static final String CMD_usimpleenroll = "usimpleenroll";
    private static final String CMD_usimplereenroll = "usimplereenroll";
    private static final String CMD_userverkeygen = "userverkeygen";
    private static final String CMD_csrattrs = "csrattrs";
    private static final String CMD_fullcmc = "fullcmc";
    private static final String CT_pkix_cert = "application/pkix-cert";
    private static final String CT_pkix_crl = "application/pkix-crl";
    private static final String CT_pkcs8 = "application/pkcs8";
    private static final String CT_pkcs10 = "application/pkcs10";
    private static final String CT_csrattrs = "application/csrattrs";
    private static final String CT_pkcs7_mime = "application/pkcs7-mime";
    private static final String CT_multipart_mixed = "multipart/mixed";
    private static final String CT_pkcs7_mime_certyonly = "application/pkcs7-mime; smime-type=certs-only";
    private static final String CT_pem_file = "application/x-pem-file";
    private static final Logger LOG = LoggerFactory.getLogger(EstResponder.class);
    private final String reverseProxyMode;
    private final SdkClient sdk;
    private final SecurityFactory securityFactory;
    private final CaProfilesControl caProfilesControl;
    private final PopControl popControl;
    private final RequestorAuthenticator authenticator;
    private final Random random = new Random();
    private static final Set<String> knownCommands;

    public EstResponder(SdkClient sdk, SecurityFactory securityFactory, RequestorAuthenticator authenticator, PopControl popControl, CaProfilesControl caProfiles, String reverseProxyMode) {
        this.sdk = (SdkClient)Args.notNull((Object)sdk, (String)"sdk");
        this.securityFactory = (SecurityFactory)Args.notNull((Object)securityFactory, (String)"securityFactory");
        this.authenticator = (RequestorAuthenticator)Args.notNull((Object)authenticator, (String)"authenticator");
        this.popControl = (PopControl)Args.notNull((Object)popControl, (String)"popControl");
        this.caProfilesControl = (CaProfilesControl)Args.notNull((Object)caProfiles, (String)"caProfiles");
        this.reverseProxyMode = reverseProxyMode;
    }

    private Requestor.PasswordRequestor getRequestor(String user) {
        return this.authenticator.getPasswordRequestorByUser(user);
    }

    private Requestor.CertRequestor getRequestor(X509Cert cert) {
        return this.authenticator.getCertRequestor(cert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse service(String path, byte[] request, XiHttpRequest httpRequest, AuditEvent event) {
        HttpResponse httpResponse;
        AuditLevel auditLevel = AuditLevel.INFO;
        AuditStatus auditStatus = AuditStatus.SUCCESSFUL;
        Object auditMessage = null;
        try {
            Requestor requestor;
            Object message;
            String profile;
            String caName;
            String coreUri = path.substring(1);
            String[] tokens = StringUtil.splitAsArray((String)coreUri, (String)"/");
            if (tokens.length == 1 || tokens.length == 2) {
                String alias = tokens.length == 1 ? "default" : tokens[0].trim();
                CaProfileConf caProfileConf = this.caProfilesControl.getCaProfile(alias);
                if (caProfileConf == null) {
                    String message2 = "unknown alias " + alias;
                    LOG.warn(message2);
                    throw new HttpRespAuditException(404, message2, AuditLevel.INFO, AuditStatus.FAILED);
                }
                caName = caProfileConf.getCa();
                profile = caProfileConf.getCertprofile();
            } else if (tokens.length == 3) {
                caName = tokens[0].toLowerCase(Locale.ROOT);
                profile = tokens[1].toLowerCase(Locale.ROOT);
            } else {
                String message3 = "invalid path " + path;
                LOG.error(message3);
                throw new HttpRespAuditException(404, message3, AuditLevel.ERROR, AuditStatus.FAILED);
            }
            String command = tokens[tokens.length - 1].toLowerCase(Locale.ROOT);
            if (StringUtil.isBlank((String)caName)) {
                message = "CA is not specified";
                LOG.warn((String)message);
                throw new HttpRespAuditException(404, (String)message, AuditLevel.INFO, AuditStatus.FAILED);
            }
            if (StringUtil.isBlank((String)profile)) {
                message = "profile is not specified";
                LOG.warn((String)message);
                throw new HttpRespAuditException(404, (String)message, AuditLevel.INFO, AuditStatus.FAILED);
            }
            if (StringUtil.isBlank((String)command)) {
                message = "command is not specified";
                LOG.warn((String)message);
                throw new HttpRespAuditException(404, (String)message, AuditLevel.INFO, AuditStatus.FAILED);
            }
            event.addEventData("ca", (Object)caName);
            event.addEventType(command);
            if (!knownCommands.contains(command)) {
                message = "invalid command '" + command + "'";
                LOG.error((String)message);
                throw new HttpRespAuditException(404, (String)message, AuditLevel.INFO, AuditStatus.FAILED);
            }
            switch (command) {
                case "cacerts": {
                    byte[][] certsBytes = this.sdk.cacerts(caName);
                    HttpResponse httpResponse2 = this.toHttpResponse(HttpRespContent.ofOk((String)CT_pkcs7_mime, (boolean)true, (byte[])EstResponder.buildCertsOnly(certsBytes)));
                    return httpResponse2;
                }
                case "ucacerts": {
                    byte[][] certsBytes = this.sdk.cacerts(caName);
                    HttpResponse httpResponse3 = this.toHttpResponse(HttpRespContent.ofOk((String)CT_pem_file, (byte[])StringUtil.toUtf8Bytes((String)X509Util.encodeCertificates((byte[][])certsBytes))));
                    return httpResponse3;
                }
                case "ucacert": {
                    byte[] certBytes = this.sdk.cacert(caName);
                    HttpResponse httpResponse4 = this.toHttpResponse(HttpRespContent.ofOk((String)CT_pkix_cert, (boolean)true, (byte[])certBytes));
                    return httpResponse4;
                }
                case "ucrl": {
                    byte[] crlBytes = this.sdk.currentCrl(caName);
                    if (crlBytes == null) {
                        String message4 = "could not get CRL";
                        LOG.warn(message4);
                        throw new HttpRespAuditException(500, message4, AuditLevel.INFO, AuditStatus.FAILED);
                    }
                    HttpResponse message4 = this.toHttpResponse(HttpRespContent.ofOk((String)CT_pkix_crl, (boolean)true, (byte[])crlBytes));
                    return message4;
                }
                case "csrattrs": {
                    HttpResponse crlBytes = this.toHttpResponse(this.getCsrAttrs(caName, profile));
                    return crlBytes;
                }
                case "fullcmc": {
                    String message5 = "supported command '" + command + "'";
                    LOG.error(message5);
                    throw new HttpRespAuditException(404, message5, AuditLevel.INFO, AuditStatus.FAILED);
                }
            }
            String hdrValue = httpRequest.getHeader("Authorization");
            if (hdrValue != null && hdrValue.startsWith("Basic ")) {
                boolean authorized;
                String user = null;
                byte[] password = null;
                if (hdrValue.length() > 6) {
                    String b64 = hdrValue.substring(6);
                    byte[] userPwd = Base64.decodeFast((String)b64);
                    int idx = -1;
                    for (int i = 0; i < userPwd.length; ++i) {
                        if (userPwd[i] != 58) continue;
                        idx = i;
                        break;
                    }
                    if (idx != -1 && idx < userPwd.length - 1) {
                        user = StringUtil.toUtf8String((byte[])Arrays.copyOfRange((byte[])userPwd, (int)0, (int)idx));
                        password = Arrays.copyOfRange((byte[])userPwd, (int)(idx + 1), (int)userPwd.length);
                    }
                }
                if (user == null) {
                    throw new HttpRespAuditException(401, "invalid Authorization information", AuditLevel.INFO, AuditStatus.FAILED);
                }
                Requestor.PasswordRequestor requestor0 = this.getRequestor(user);
                requestor = requestor0;
                boolean bl = authorized = requestor0 != null && requestor0.authenticate(password);
                if (!authorized) {
                    throw new HttpRespAuditException(401, "could not authenticate user " + user, AuditLevel.INFO, AuditStatus.FAILED);
                }
            } else {
                X509Cert clientCert = Optional.ofNullable(TlsHelper.getTlsClientCert((XiHttpRequest)httpRequest, (String)this.reverseProxyMode)).orElseThrow(() -> new HttpRespAuditException(401, "no client certificate", AuditLevel.INFO, AuditStatus.FAILED));
                requestor = (Requestor)Optional.ofNullable(this.getRequestor(clientCert)).orElseThrow(() -> new OperationException(ErrorCode.NOT_PERMITTED, "no requestor specified"));
            }
            event.addEventData("requestor", (Object)requestor.getName());
            String ct = httpRequest.getHeader("Content-Type");
            if (!CT_pkcs10.equalsIgnoreCase(ct)) {
                String message6 = "unsupported media type " + ct;
                throw new HttpRespAuditException(415, message6, AuditLevel.INFO, AuditStatus.FAILED);
            }
            if (!requestor.isPermitted(Requestor.Permission.ENROLL_CERT)) {
                throw new OperationException(ErrorCode.NOT_PERMITTED, "ENROLL_CERT is not allowed");
            }
            if (!requestor.isCertprofilePermitted(caName, profile)) {
                throw new OperationException(ErrorCode.NOT_PERMITTED, "certprofile " + profile + " is not allowed");
            }
            CertificationRequest csr = GatewayUtil.parseCsrInRequest((byte[])request);
            if (!CMD_serverkeygen.equals(command) && !GatewayUtil.verifyCsr((CertificationRequest)csr, (SecurityFactory)this.securityFactory, (PopControl)this.popControl)) {
                throw new OperationException(ErrorCode.BAD_POP);
            }
            HttpRespContent respContent = CMD_simplereenroll.equals(command) || CMD_usimplereenroll.equals(command) ? this.reenrollCert(command, caName, profile, csr, event) : this.enrollCert(command, caName, profile, csr, event);
            HttpResponse httpResponse5 = this.toHttpResponse(respContent);
            return httpResponse5;
        }
        catch (OperationException ex) {
            int sc;
            ErrorCode code = ex.getErrorCode();
            if (LOG.isWarnEnabled()) {
                String msg = StringUtil.concat((String)"generate certificate, OperationException: code=", (String[])new String[]{code.name(), ", message=", ex.getErrorMessage()});
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)msg);
            }
            switch (code) {
                case ALREADY_ISSUED: 
                case BAD_REQUEST: 
                case INVALID_EXTENSION: 
                case UNKNOWN_CERT_PROFILE: 
                case CERT_UNREVOKED: 
                case BAD_CERT_TEMPLATE: 
                case UNKNOWN_CERT: 
                case BAD_POP: {
                    sc = 400;
                    break;
                }
                case CERT_REVOKED: {
                    sc = 409;
                    break;
                }
                case NOT_PERMITTED: 
                case UNAUTHORIZED: {
                    sc = 401;
                    break;
                }
                case SYSTEM_UNAVAILABLE: {
                    sc = 503;
                    break;
                }
                case PATH_NOT_FOUND: {
                    sc = 404;
                    break;
                }
                default: {
                    sc = 500;
                }
            }
            event.setStatus(AuditStatus.FAILED);
            event.addEventData("message", (Object)code.name());
            auditMessage = code == ErrorCode.DATABASE_FAILURE || code == ErrorCode.SYSTEM_FAILURE ? code.name() : code.name() + ": " + ex.getErrorMessage();
            HttpResponse httpResponse6 = new HttpResponse(sc);
            return httpResponse6;
        }
        catch (HttpRespAuditException ex) {
            auditStatus = ex.getAuditStatus();
            auditLevel = ex.getAuditLevel();
            auditMessage = ex.getAuditMessage();
            httpResponse = new HttpResponse(ex.getHttpStatus());
            return httpResponse;
        }
        catch (Throwable th) {
            if (th instanceof EOFException) {
                LogUtil.warn((Logger)LOG, (Throwable)th, (String)"connection reset by peer");
            } else {
                LOG.error("Throwable thrown, this should not happen!", th);
            }
            auditLevel = AuditLevel.ERROR;
            auditStatus = AuditStatus.FAILED;
            auditMessage = "internal error";
            httpResponse = new HttpResponse(500);
            return httpResponse;
        }
        finally {
            event.setStatus(auditStatus);
            event.setLevel(auditLevel);
            if (auditMessage != null) {
                event.addEventData("message", auditMessage);
            }
        }
    }

    private HttpResponse toHttpResponse(HttpRespContent respContent) {
        return respContent == null ? new HttpResponse(200) : new HttpResponse(200, respContent.getContentType(), null, respContent.isBase64(), respContent.getContent());
    }

    private HttpRespContent enrollCert(String command, String caName, String profile, CertificationRequest csr, AuditEvent event) throws HttpRespAuditException, IOException, SdkErrorResponseException {
        boolean caGenKeyPair = CMD_serverkeygen.equals(command) || CMD_userverkeygen.equals(command);
        CertificationRequestInfo certTemp = csr.getCertificationRequestInfo();
        X500Name subject = certTemp.getSubject();
        BigInteger reqId = BigInteger.ONE;
        EnrollCertsRequest.Entry template = new EnrollCertsRequest.Entry();
        template.setCertReqId(reqId);
        template.setCertprofile(profile);
        template.setSubject(new X500NameType(subject));
        event.addEventData("certprofile", (Object)profile);
        event.addEventData("req_subject", (Object)("\"" + X509Util.x500NameText((X500Name)subject) + "\""));
        Extensions extensions = X509Util.getExtensions((CertificationRequestInfo)certTemp);
        try {
            template.extensions(extensions);
        }
        catch (IOException e) {
            throw new HttpRespAuditException(400, "could not encode extensions", AuditLevel.INFO, AuditStatus.FAILED);
        }
        if (!caGenKeyPair) {
            try {
                template.subjectPublicKey(certTemp.getSubjectPublicKeyInfo());
            }
            catch (IOException e) {
                throw new HttpRespAuditException(400, "could not encode SubjectPublicKeyInfo", AuditLevel.INFO, AuditStatus.FAILED);
            }
        }
        EnrollCertsRequest.Entry[] templates = new EnrollCertsRequest.Entry[]{template};
        EnrollCertsRequest sdkReq = new EnrollCertsRequest();
        sdkReq.setEntries(templates);
        sdkReq.setExplicitConfirm(Boolean.valueOf(false));
        sdkReq.setCaCertMode(CertsMode.NONE);
        EnrollOrPollCertsResponse sdkResp = this.sdk.enrollCerts(caName, sdkReq);
        EstResponder.checkResponse(1, sdkResp);
        EnrollOrPollCertsResponse.Entry entry = EstResponder.getEntry(sdkResp.getEntries(), reqId);
        if (!caGenKeyPair) {
            if (CMD_usimpleenroll.equals(command)) {
                return HttpRespContent.ofOk((String)CT_pkix_cert, (boolean)true, (byte[])entry.getCert());
            }
            return HttpRespContent.ofOk((String)CT_pkcs7_mime_certyonly, (boolean)true, (byte[])EstResponder.buildCertsOnly(new byte[][]{entry.getCert()}));
        }
        if (CMD_userverkeygen.equals(command)) {
            try (ByteArrayOutputStream bo = new ByteArrayOutputStream();){
                bo.write(PemEncoder.encode((byte[])entry.getPrivateKey(), (PemEncoder.PemLabel)PemEncoder.PemLabel.PRIVATE_KEY));
                bo.write(PemEncoder.encode((byte[])entry.getCert(), (PemEncoder.PemLabel)PemEncoder.PemLabel.CERTIFICATE));
                bo.flush();
                HttpRespContent httpRespContent = HttpRespContent.ofOk((String)CT_pem_file, (byte[])bo.toByteArray());
                return httpRespContent;
            }
        }
        byte[] t = new byte[9];
        this.random.nextBytes(t);
        String boundary = "estBounary_" + Base64.encodeToString((byte[])t);
        byte[] boundaryBytes = StringUtil.toUtf8Bytes((String)("--" + boundary));
        try (ByteArrayOutputStream bo = new ByteArrayOutputStream();){
            EstResponder.writeLine(bo, "XiPKI EST server");
            EstResponder.writeMultipartEntry(bo, boundaryBytes, CT_pkcs8, entry.getPrivateKey());
            byte[] certBytes = EstResponder.buildCertsOnly(new byte[][]{entry.getCert()});
            EstResponder.writeMultipartEntry(bo, boundaryBytes, CT_pkcs7_mime_certyonly, certBytes);
            bo.write(boundaryBytes);
            bo.write(__NEWLINE);
            bo.flush();
            HttpRespContent httpRespContent = HttpRespContent.ofOk((String)("multipart/mixed; boundary=" + boundary), (boolean)false, (byte[])bo.toByteArray());
            return httpRespContent;
        }
    }

    private static void writeMultipartEntry(OutputStream os, byte[] boundaryBytes, String ct, byte[] data) throws IOException {
        os.write(boundaryBytes);
        os.write(NEWLINE);
        EstResponder.writeLine(os, "Content-Type: " + ct);
        EstResponder.writeLine(os, "Content-Transfer-Encoding: base64");
        os.write(NEWLINE);
        os.write(Base64.encodeToByte((byte[])data, (boolean)true));
        os.write(NEWLINE);
    }

    private HttpRespContent reenrollCert(String command, String caName, String profile, CertificationRequest csr, AuditEvent event) throws HttpRespAuditException, IOException, SdkErrorResponseException {
        CertificationRequestInfo certTemp = csr.getCertificationRequestInfo();
        event.addEventData("certprofile", (Object)profile);
        X500Name oldSubject = certTemp.getSubject();
        BigInteger reqId = BigInteger.ONE;
        EnrollCertsRequest.Entry template = new EnrollCertsRequest.Entry();
        template.setCertReqId(reqId);
        template.setCertprofile(profile);
        try {
            template.subjectPublicKey(certTemp.getSubjectPublicKeyInfo());
        }
        catch (IOException e) {
            throw new HttpRespAuditException(400, "could not encode SubjectPublicKeyInfo", AuditLevel.INFO, AuditStatus.FAILED);
        }
        Extensions csrExtns = X509Util.getExtensions((CertificationRequestInfo)certTemp);
        byte[] extnValue = X509Util.getCoreExtValue((Extensions)csrExtns, (ASN1ObjectIdentifier)Extension.subjectAlternativeName);
        OldCertInfo.BySubject oldCertInfo = new OldCertInfo.BySubject(false, oldSubject.getEncoded(), extnValue);
        template.setOldCertSubject(oldCertInfo);
        Attribute attr = X509Util.getAttribute((CertificationRequestInfo)certTemp, (ASN1ObjectIdentifier)ObjectIdentifiers.CMC.id_cmc_changeSubjectName);
        Extensions requestedExtns = csrExtns;
        X500Name requestedSubject = oldSubject;
        if (attr != null) {
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)attr.getAttributeValues()[0]);
            int size = seq.size();
            X500Name newSubject = null;
            GeneralNames newSubjectAlt = null;
            if (size == 2) {
                newSubject = X500Name.getInstance((Object)seq.getObjectAt(0));
                newSubjectAlt = GeneralNames.getInstance((Object)seq.getObjectAt(1));
            } else if (size == 1) {
                ASN1Encodable obj = seq.getObjectAt(0);
                try {
                    newSubject = X500Name.getInstance((Object)obj);
                }
                catch (Exception e) {
                    newSubjectAlt = GeneralNames.getInstance((Object)obj);
                }
            } else {
                throw new HttpRespAuditException(400, "invalid ChangeSubjectName", AuditLevel.INFO, AuditStatus.FAILED);
            }
            if (newSubject != null) {
                requestedSubject = newSubject;
            }
            if (newSubjectAlt != null) {
                LinkedList<Extension> v = new LinkedList<Extension>();
                ASN1ObjectIdentifier sanOid = Extension.subjectAlternativeName;
                Extension sanExtn = null;
                if (csrExtns != null) {
                    ASN1ObjectIdentifier[] csrExtnOids;
                    sanExtn = csrExtns.getExtension(sanOid);
                    for (ASN1ObjectIdentifier oid : csrExtnOids = csrExtns.getExtensionOIDs()) {
                        if (sanOid.equals((ASN1Primitive)oid)) continue;
                        v.add(csrExtns.getExtension(oid));
                    }
                }
                boolean critical = sanExtn != null && sanExtn.isCritical();
                v.add(new Extension(sanOid, critical, newSubjectAlt.getEncoded()));
                requestedExtns = new Extensions(v.toArray(new Extension[0]));
            }
        }
        template.setSubject(new X500NameType(requestedSubject));
        event.addEventData("req_subject", (Object)("\"" + X509Util.x500NameText((X500Name)requestedSubject) + "\""));
        try {
            template.extensions(requestedExtns);
        }
        catch (IOException e) {
            String message = "could not encode extensions";
            throw new HttpRespAuditException(400, message, AuditLevel.INFO, AuditStatus.FAILED);
        }
        EnrollCertsRequest.Entry[] templates = new EnrollCertsRequest.Entry[]{template};
        EnrollCertsRequest sdkReq = new EnrollCertsRequest();
        sdkReq.setEntries(templates);
        sdkReq.setExplicitConfirm(Boolean.valueOf(false));
        sdkReq.setCaCertMode(CertsMode.NONE);
        EnrollOrPollCertsResponse sdkResp = this.sdk.reenrollCerts(caName, sdkReq);
        EstResponder.checkResponse(1, sdkResp);
        EnrollOrPollCertsResponse.Entry entry = EstResponder.getEntry(sdkResp.getEntries(), reqId);
        if (CMD_simplereenroll.equals(command)) {
            return HttpRespContent.ofOk((String)CT_pkcs7_mime_certyonly, (boolean)true, (byte[])EstResponder.buildCertsOnly(new byte[][]{entry.getCert()}));
        }
        return HttpRespContent.ofOk((String)CT_pkix_cert, (boolean)true, (byte[])entry.getCert());
    }

    private HttpRespContent getCsrAttrs(String caName, String profile) throws IOException, SdkErrorResponseException {
        KeyType[] keyTypes;
        CertprofileInfoResponse sdkResp = this.sdk.profileInfo(caName, profile);
        ASN1EncodableVector csrAttrs = new ASN1EncodableVector();
        String[] extnTypes = sdkResp.getRequiredExtensionTypes();
        if (extnTypes != null && extnTypes.length != 0) {
            ASN1EncodableVector asn1ExtnTypes = new ASN1EncodableVector();
            for (String string : extnTypes) {
                asn1ExtnTypes.add((ASN1Encodable)new ASN1ObjectIdentifier(string));
            }
            csrAttrs.add((ASN1Encodable)new Attribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Set)new DERSet(asn1ExtnTypes)));
        }
        if ((keyTypes = sdkResp.getKeyTypes()) != null) {
            for (KeyType keyType : keyTypes) {
                ASN1ObjectIdentifier typeOid = new ASN1ObjectIdentifier(keyType.getKeyType());
                String[] ecCurves = keyType.getEcCurves();
                if (ecCurves == null || ecCurves.length == 0) {
                    csrAttrs.add((ASN1Encodable)typeOid);
                    continue;
                }
                for (String ecCurve : ecCurves) {
                    csrAttrs.add((ASN1Encodable)new Attribute(typeOid, (ASN1Set)new DERSet((ASN1Encodable)new ASN1ObjectIdentifier(ecCurve))));
                }
            }
        }
        DERSequence dERSequence = new DERSequence(csrAttrs);
        return HttpRespContent.ofOk((String)CT_csrattrs, (boolean)true, (byte[])dERSequence.getEncoded("DER"));
    }

    private static void checkResponse(int expectedSize, EnrollOrPollCertsResponse resp) throws HttpRespAuditException {
        int n;
        EnrollOrPollCertsResponse.Entry[] entries = resp.getEntries();
        if (entries != null) {
            for (EnrollOrPollCertsResponse.Entry entry : entries) {
                if (entry.getError() == null) continue;
                throw new HttpRespAuditException(500, entry.getError().toString(), AuditLevel.INFO, AuditStatus.FAILED);
            }
        }
        int n2 = n = entries == null ? 0 : entries.length;
        if (n != expectedSize) {
            throw new HttpRespAuditException(500, "expected " + expectedSize + " cert, but received " + n, AuditLevel.INFO, AuditStatus.FAILED);
        }
    }

    private static EnrollOrPollCertsResponse.Entry getEntry(EnrollOrPollCertsResponse.Entry[] entries, BigInteger certReqId) throws HttpRespAuditException {
        for (EnrollOrPollCertsResponse.Entry m : entries) {
            if (!certReqId.equals(m.getId())) continue;
            return m;
        }
        throw new HttpRespAuditException(500, "found no response entry with certReqId " + certReqId, AuditLevel.INFO, AuditStatus.FAILED);
    }

    private static byte[] buildCertsOnly(byte[] ... certsBytes) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (byte[] certBytes : certsBytes) {
            v.add((ASN1Encodable)Certificate.getInstance((Object)certBytes));
        }
        DERSet certs = new DERSet(v);
        SignedData sd = new SignedData((ASN1Set)new DERSet(), new ContentInfo(CMSObjectIdentifiers.data, null), (ASN1Set)certs, (ASN1Set)new DERSet(), (ASN1Set)new DERSet());
        ContentInfo ci = new ContentInfo(CMSObjectIdentifiers.signedData, (ASN1Encodable)sd);
        return ci.getEncoded("DER");
    }

    private static void writeLine(OutputStream os, String line) throws IOException {
        os.write(StringUtil.toUtf8Bytes((String)line));
        os.write(NEWLINE);
    }

    static {
        LOG.info("XiPKI EST-Gateway version {}", (Object)StringUtil.getBundleVersion(EstResponder.class));
        knownCommands = CollectionUtil.asUnmodifiableSet((Object[])new String[]{CMD_cacerts, CMD_simpleenroll, CMD_simplereenroll, CMD_serverkeygen, CMD_cacerts, CMD_csrattrs, CMD_fullcmc, CMD_ucacerts, CMD_ucacert, CMD_ucrl, CMD_usimpleenroll, CMD_usimplereenroll, CMD_userverkeygen});
    }

    private static class HttpRespAuditException
    extends Exception {
        private final int httpStatus;
        private final String auditMessage;
        private final AuditLevel auditLevel;
        private final AuditStatus auditStatus;

        public HttpRespAuditException(int httpStatus, String auditMessage, AuditLevel auditLevel, AuditStatus auditStatus) {
            this.httpStatus = httpStatus;
            this.auditMessage = Args.notBlank((String)auditMessage, (String)"auditMessage");
            this.auditLevel = (AuditLevel)Args.notNull((Object)auditLevel, (String)"auditLevel");
            this.auditStatus = (AuditStatus)Args.notNull((Object)auditStatus, (String)"auditStatus");
        }

        public int getHttpStatus() {
            return this.httpStatus;
        }

        public String getAuditMessage() {
            return this.auditMessage;
        }

        public AuditLevel getAuditLevel() {
            return this.auditLevel;
        }

        public AuditStatus getAuditStatus() {
            return this.auditStatus;
        }
    }
}

