/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.util.encoders.Hex;
import org.xipki.ca.sdk.SdkRequest;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.security.util.X509Util;
import org.xipki.util.cbor.ByteArrayCborDecoder;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncodable;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class CaIdentifierRequest
extends SdkRequest {
    private final byte[] issuerCertSha1Fp;
    private final X500NameType issuer;
    private final byte[] authorityKeyIdentifier;

    protected CaIdentifierRequest(byte[] issuerCertSha1Fp, X500NameType issuer, byte[] authorityKeyIdentifier) {
        this.issuerCertSha1Fp = issuerCertSha1Fp;
        this.issuer = issuer;
        this.authorityKeyIdentifier = authorityKeyIdentifier;
    }

    public byte[] getIssuerCertSha1Fp() {
        return this.issuerCertSha1Fp;
    }

    public X500NameType getIssuer() {
        return this.issuer;
    }

    public byte[] getAuthorityKeyIdentifier() {
        return this.authorityKeyIdentifier;
    }

    public String idText() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (this.issuer != null) {
            sb.append("subject=");
            try {
                sb.append(X509Util.x500NameText((X500Name)this.issuer.toX500Name()));
            }
            catch (IOException ex) {
                sb.append("<ERROR>");
            }
            sb.append(",");
        }
        if (this.issuerCertSha1Fp != null) {
            sb.append("SHA1(cert)=").append(Hex.toHexString((byte[])this.issuerCertSha1Fp)).append(",");
        }
        if (this.authorityKeyIdentifier != null) {
            sb.append("AKI=").append(Hex.toHexString((byte[])this.authorityKeyIdentifier)).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    @Override
    protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
        this.encode0(encoder, 0);
    }

    protected void encode0(CborEncoder encoder, int subClassFieldSize) throws IOException, EncodeException {
        encoder.writeArrayStart(3 + subClassFieldSize);
        encoder.writeByteString(this.issuerCertSha1Fp);
        encoder.writeObject((CborEncodable)this.issuer);
        encoder.writeByteString(this.authorityKeyIdentifier);
    }

    public static CaIdentifierRequest decode(byte[] encoded) throws DecodeException {
        CaIdentifierRequest caIdentifierRequest;
        ByteArrayCborDecoder decoder = new ByteArrayCborDecoder(encoded);
        try {
            CaIdentifierRequest.assertArrayStart("CaIdentifierRequest", (CborDecoder)decoder, 3);
            caIdentifierRequest = new CaIdentifierRequest(decoder.readByteString(), X500NameType.decode((CborDecoder)decoder), decoder.readByteString());
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(CaIdentifierRequest.buildDecodeErrMessage(ex, CaIdentifierRequest.class), (Throwable)ex);
            }
        }
        decoder.close();
        return caIdentifierRequest;
    }
}

