/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import java.math.BigInteger;
import java.time.Instant;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.xipki.ca.sdk.OldCertInfoByIssuerAndSerial;
import org.xipki.ca.sdk.OldCertInfoBySubject;
import org.xipki.ca.sdk.SdkEncodable;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncodable;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class EnrollCertRequestEntry
extends SdkEncodable {
    private BigInteger certReqId;
    private String certprofile;
    private byte[] p10req;
    private X500NameType subject;
    private byte[] subjectPublicKey;
    private byte[] extensions;
    private Instant notBefore;
    private Instant notAfter;
    private OldCertInfoByIssuerAndSerial oldCertIsn;
    private OldCertInfoBySubject oldCertSubject;

    public BigInteger getCertReqId() {
        return this.certReqId;
    }

    public void setCertReqId(BigInteger certReqId) {
        this.certReqId = certReqId;
    }

    public String getCertprofile() {
        return this.certprofile;
    }

    public void setCertprofile(String certprofile) {
        this.certprofile = certprofile;
    }

    public byte[] getSubjectPublicKey() {
        return this.subjectPublicKey;
    }

    public void setSubjectPublicKey(byte[] subjectPublicKey) {
        this.subjectPublicKey = subjectPublicKey;
    }

    public void subjectPublicKey(SubjectPublicKeyInfo subjectPublicKey) throws IOException {
        this.subjectPublicKey = subjectPublicKey == null ? null : subjectPublicKey.getEncoded();
    }

    public X500NameType getSubject() {
        return this.subject;
    }

    public void setSubject(X500NameType subject) {
        this.subject = subject;
    }

    public byte[] getExtensions() {
        return this.extensions;
    }

    public void setExtensions(byte[] extensions) {
        this.extensions = extensions;
    }

    public void extensions(Extensions extensions) throws IOException {
        this.extensions = extensions == null ? null : extensions.getEncoded();
    }

    public byte[] getP10req() {
        return this.p10req;
    }

    public void setP10req(byte[] p10req) {
        this.p10req = p10req;
    }

    public Instant getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Instant notBefore) {
        this.notBefore = notBefore;
    }

    public void notBefore(Instant notBefore) {
        this.notBefore = notBefore;
    }

    public Instant getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(Instant notAfter) {
        this.notAfter = notAfter;
    }

    public void notAfter(Instant notAfter) {
        this.notAfter = notAfter;
    }

    public OldCertInfoByIssuerAndSerial getOldCertIsn() {
        return this.oldCertIsn;
    }

    public void setOldCertIsn(OldCertInfoByIssuerAndSerial oldCertIsn) {
        this.oldCertIsn = oldCertIsn;
    }

    public OldCertInfoBySubject getOldCertSubject() {
        return this.oldCertSubject;
    }

    public void setOldCertSubject(OldCertInfoBySubject oldCertSubject) {
        this.oldCertSubject = oldCertSubject;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
        encoder.writeArrayStart(10);
        encoder.writeBigInt(this.certReqId);
        encoder.writeTextString(this.certprofile);
        encoder.writeByteString(this.p10req);
        encoder.writeObject((CborEncodable)this.subject);
        encoder.writeByteString(this.subjectPublicKey);
        encoder.writeByteString(this.extensions);
        encoder.writeInstant(this.notBefore);
        encoder.writeInstant(this.notAfter);
        encoder.writeObject((CborEncodable)this.oldCertIsn);
        encoder.writeObject((CborEncodable)this.oldCertSubject);
    }

    public static EnrollCertRequestEntry decode(CborDecoder decoder) throws DecodeException {
        try {
            if (decoder.readNullOrArrayLength(10)) {
                return null;
            }
            EnrollCertRequestEntry ret = new EnrollCertRequestEntry();
            ret.setCertReqId(decoder.readBigInt());
            ret.setCertprofile(decoder.readTextString());
            ret.setP10req(decoder.readByteString());
            ret.setSubject(X500NameType.decode(decoder));
            ret.setSubjectPublicKey(decoder.readByteString());
            ret.setExtensions(decoder.readByteString());
            ret.setNotBefore(decoder.readInstant());
            ret.setNotAfter(decoder.readInstant());
            ret.setOldCertIsn(OldCertInfoByIssuerAndSerial.decode(decoder));
            ret.setOldCertSubject(OldCertInfoBySubject.decode(decoder));
            return ret;
        }
        catch (IOException | RuntimeException ex) {
            throw new DecodeException(EnrollCertRequestEntry.buildDecodeErrMessage(ex, EnrollCertRequestEntry.class), (Throwable)ex);
        }
    }

    public static EnrollCertRequestEntry[] decodeArray(CborDecoder decoder) throws DecodeException {
        Integer arrayLen = decoder.readNullOrArrayLength(EnrollCertRequestEntry[].class);
        if (arrayLen == null) {
            return null;
        }
        EnrollCertRequestEntry[] entries = new EnrollCertRequestEntry[arrayLen.intValue()];
        for (int i = 0; i < arrayLen; ++i) {
            entries[i] = EnrollCertRequestEntry.decode(decoder);
        }
        return entries;
    }
}

