/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import org.xipki.ca.sdk.CertsMode;
import org.xipki.ca.sdk.EnrollCertRequestEntry;
import org.xipki.ca.sdk.SdkRequest;
import org.xipki.util.cbor.ByteArrayCborDecoder;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncodable;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class EnrollCertsRequest
extends SdkRequest {
    private String transactionId;
    private Boolean groupEnroll;
    private Boolean explicitConfirm;
    private Integer confirmWaitTimeMs;
    private CertsMode caCertMode;
    private EnrollCertRequestEntry[] entries;

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public Boolean getGroupEnroll() {
        return this.groupEnroll;
    }

    public void setGroupEnroll(Boolean groupEnroll) {
        this.groupEnroll = groupEnroll;
    }

    public Boolean getExplicitConfirm() {
        return this.explicitConfirm;
    }

    public void setExplicitConfirm(Boolean explicitConfirm) {
        this.explicitConfirm = explicitConfirm;
    }

    public Integer getConfirmWaitTimeMs() {
        return this.confirmWaitTimeMs;
    }

    public void setConfirmWaitTimeMs(Integer confirmWaitTimeMs) {
        this.confirmWaitTimeMs = confirmWaitTimeMs;
    }

    public CertsMode getCaCertMode() {
        return this.caCertMode;
    }

    public void setCaCertMode(CertsMode caCertMode) {
        this.caCertMode = caCertMode;
    }

    public EnrollCertRequestEntry[] getEntries() {
        return this.entries;
    }

    public void setEntries(EnrollCertRequestEntry[] entries) {
        this.entries = entries;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
        encoder.writeArrayStart(6);
        encoder.writeTextString(this.transactionId);
        encoder.writeBooleanObj(this.groupEnroll);
        encoder.writeBooleanObj(this.explicitConfirm);
        encoder.writeIntObj(this.confirmWaitTimeMs);
        encoder.writeEnumObj((Enum)this.caCertMode);
        encoder.writeObjects((CborEncodable[])this.entries);
    }

    public static EnrollCertsRequest decode(byte[] encoded) throws DecodeException {
        EnrollCertsRequest enrollCertsRequest;
        ByteArrayCborDecoder decoder = new ByteArrayCborDecoder(encoded);
        try {
            EnrollCertsRequest.assertArrayStart("EnrollCertsRequest", (CborDecoder)decoder, 6);
            EnrollCertsRequest ret = new EnrollCertsRequest();
            ret.setTransactionId(decoder.readTextString());
            ret.setGroupEnroll(decoder.readBooleanObj());
            ret.setExplicitConfirm(decoder.readBooleanObj());
            ret.setConfirmWaitTimeMs(decoder.readIntObj());
            String str = decoder.readTextString();
            if (str != null) {
                ret.setCaCertMode(CertsMode.valueOf(str));
            }
            ret.setEntries(EnrollCertRequestEntry.decodeArray((CborDecoder)decoder));
            enrollCertsRequest = ret;
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(EnrollCertsRequest.buildDecodeErrMessage(ex, EnrollCertsRequest.class), (Throwable)ex);
            }
        }
        decoder.close();
        return enrollCertsRequest;
    }
}

