/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import java.math.BigInteger;
import org.xipki.ca.sdk.ErrorEntry;
import org.xipki.ca.sdk.SdkEncodable;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncodable;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class EnrollOrPullCertResponseEntry
extends SdkEncodable {
    private final BigInteger id;
    private final ErrorEntry error;
    private final byte[] cert;
    private final byte[] privateKey;

    public EnrollOrPullCertResponseEntry(BigInteger id, ErrorEntry error, byte[] cert, byte[] privateKey) {
        this.id = id;
        this.error = error;
        this.cert = cert;
        this.privateKey = privateKey;
    }

    public BigInteger getId() {
        return this.id;
    }

    public ErrorEntry getError() {
        return this.error;
    }

    public byte[] getCert() {
        return this.cert;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
        encoder.writeArrayStart(4);
        encoder.writeBigInt(this.id);
        encoder.writeObject((CborEncodable)this.error);
        encoder.writeByteString(this.cert);
        encoder.writeByteString(this.privateKey);
    }

    public static EnrollOrPullCertResponseEntry decode(CborDecoder decoder) throws DecodeException {
        try {
            if (decoder.readNullOrArrayLength(4)) {
                return null;
            }
            return new EnrollOrPullCertResponseEntry(decoder.readBigInt(), ErrorEntry.decode(decoder), decoder.readByteString(), decoder.readByteString());
        }
        catch (IOException | RuntimeException ex) {
            throw new DecodeException(EnrollOrPullCertResponseEntry.buildDecodeErrMessage(ex, EnrollOrPullCertResponseEntry.class), (Throwable)ex);
        }
    }

    public static EnrollOrPullCertResponseEntry[] decodeArray(CborDecoder decoder) throws DecodeException {
        Integer arrayLen = decoder.readNullOrArrayLength(EnrollOrPullCertResponseEntry[].class);
        if (arrayLen == null) {
            return null;
        }
        EnrollOrPullCertResponseEntry[] entries = new EnrollOrPullCertResponseEntry[arrayLen.intValue()];
        for (int i = 0; i < arrayLen; ++i) {
            entries[i] = EnrollOrPullCertResponseEntry.decode(decoder);
        }
        return entries;
    }
}

