/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import java.math.BigInteger;
import org.xipki.ca.sdk.SdkRequest;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.util.cbor.ByteArrayCborDecoder;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncodable;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class GetCertRequest
extends SdkRequest {
    private final BigInteger serialNumber;
    private final X500NameType issuer;

    public GetCertRequest(BigInteger serialNumber, X500NameType issuer) {
        this.serialNumber = serialNumber;
        this.issuer = issuer;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public X500NameType getIssuer() {
        return this.issuer;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
        encoder.writeArrayStart(2);
        encoder.writeBigInt(this.serialNumber);
        encoder.writeObject((CborEncodable)this.issuer);
    }

    public static GetCertRequest decode(byte[] encoded) throws DecodeException {
        GetCertRequest getCertRequest;
        ByteArrayCborDecoder decoder = new ByteArrayCborDecoder(encoded);
        try {
            GetCertRequest.assertArrayStart("GetCertRequest", (CborDecoder)decoder, 2);
            getCertRequest = new GetCertRequest(decoder.readBigInt(), X500NameType.decode((CborDecoder)decoder));
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(GetCertRequest.buildDecodeErrMessage(ex, GetCertRequest.class), (Throwable)ex);
            }
        }
        decoder.close();
        return getCertRequest;
    }
}

