/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import org.xipki.ca.sdk.SdkEncodable;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class KeyType
extends SdkEncodable {
    private final String keyType;
    private final String[] ecCurves;

    public KeyType(String keyType, String[] ecCurves) {
        this.keyType = keyType;
        this.ecCurves = ecCurves;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String[] getEcCurves() {
        return this.ecCurves;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
        encoder.writeArrayStart(2);
        encoder.writeTextString(this.keyType);
        encoder.writeTextStrings(this.ecCurves);
    }

    public static KeyType decode(CborDecoder decoder) throws DecodeException {
        try {
            if (decoder.readNullOrArrayLength(2)) {
                return null;
            }
            return new KeyType(decoder.readTextString(), decoder.readTextStrings());
        }
        catch (IOException | RuntimeException ex) {
            throw new DecodeException(KeyType.buildDecodeErrMessage(ex, KeyType.class), (Throwable)ex);
        }
    }

    public static KeyType[] decodeArray(CborDecoder decoder) throws DecodeException {
        Integer arrayLen = decoder.readNullOrArrayLength(KeyType[].class);
        if (arrayLen == null) {
            return null;
        }
        KeyType[] entries = new KeyType[arrayLen.intValue()];
        for (int i = 0; i < arrayLen; ++i) {
            entries[i] = KeyType.decode(decoder);
        }
        return entries;
    }
}

