/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import java.math.BigInteger;
import org.xipki.ca.sdk.OldCertInfo;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncodable;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class OldCertInfoByIssuerAndSerial
extends OldCertInfo {
    private final X500NameType issuer;
    private final BigInteger serialNumber;

    public OldCertInfoByIssuerAndSerial(boolean reusePublicKey, X500NameType issuer, BigInteger serialNumber) {
        super(reusePublicKey);
        this.issuer = issuer;
        this.serialNumber = serialNumber;
    }

    public X500NameType getIssuer() {
        return this.issuer;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
        encoder.writeArrayStart(3);
        encoder.writeBoolean(this.isReusePublicKey());
        encoder.writeObject((CborEncodable)this.issuer);
        encoder.writeBigInt(this.serialNumber);
    }

    public static OldCertInfoByIssuerAndSerial decode(CborDecoder decoder) throws DecodeException {
        try {
            if (decoder.readNullOrArrayLength(3)) {
                return null;
            }
            return new OldCertInfoByIssuerAndSerial(decoder.readBoolean(), X500NameType.decode(decoder), decoder.readBigInt());
        }
        catch (IOException | RuntimeException ex) {
            throw new DecodeException(OldCertInfoByIssuerAndSerial.buildDecodeErrMessage(ex, OldCertInfoByIssuerAndSerial.class), (Throwable)ex);
        }
    }
}

