/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import org.xipki.ca.sdk.CaIdentifierRequest;
import org.xipki.ca.sdk.PollCertRequestEntry;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.util.cbor.ByteArrayCborDecoder;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncodable;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class PollCertRequest
extends CaIdentifierRequest {
    private final String transactionId;
    private final PollCertRequestEntry[] entries;

    public PollCertRequest(byte[] issuerCertSha1Fp, X500NameType issuer, byte[] authorityKeyIdentifier, String transactionId, PollCertRequestEntry[] entries) {
        super(issuerCertSha1Fp, issuer, authorityKeyIdentifier);
        this.transactionId = transactionId;
        this.entries = entries;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public PollCertRequestEntry[] getEntries() {
        return this.entries;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
        super.encode0(encoder, 2);
        encoder.writeTextString(this.transactionId);
        encoder.writeObjects((CborEncodable[])this.entries);
    }

    public static PollCertRequest decode(byte[] encoded) throws DecodeException {
        PollCertRequest pollCertRequest;
        ByteArrayCborDecoder decoder = new ByteArrayCborDecoder(encoded);
        try {
            PollCertRequest.assertArrayStart("PollCertRequest", (CborDecoder)decoder, 5);
            pollCertRequest = new PollCertRequest(decoder.readByteString(), X500NameType.decode((CborDecoder)decoder), decoder.readByteString(), decoder.readTextString(), PollCertRequestEntry.decodeArray((CborDecoder)decoder));
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(PollCertRequest.buildDecodeErrMessage(ex, PollCertRequest.class), (Throwable)ex);
            }
        }
        decoder.close();
        return pollCertRequest;
    }
}

