/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import java.math.BigInteger;
import org.xipki.ca.sdk.SdkEncodable;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncodable;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class PollCertRequestEntry
extends SdkEncodable {
    private final BigInteger id;
    private final X500NameType subject;

    public PollCertRequestEntry(BigInteger id, X500NameType subject) {
        this.id = id;
        this.subject = subject;
    }

    public BigInteger getId() {
        return this.id;
    }

    public X500NameType getSubject() {
        return this.subject;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
        encoder.writeArrayStart(2);
        encoder.writeBigInt(this.id);
        encoder.writeObject((CborEncodable)this.subject);
    }

    public static PollCertRequestEntry decode(CborDecoder decoder) throws DecodeException {
        try {
            if (decoder.readNullOrArrayLength(2)) {
                return null;
            }
            return new PollCertRequestEntry(decoder.readBigInt(), X500NameType.decode(decoder));
        }
        catch (IOException | RuntimeException ex) {
            throw new DecodeException(PollCertRequestEntry.buildDecodeErrMessage(ex, PollCertRequestEntry.class), (Throwable)ex);
        }
    }

    public static PollCertRequestEntry[] decodeArray(CborDecoder decoder) throws DecodeException {
        Integer arrayLen = decoder.readNullOrArrayLength(PollCertRequestEntry[].class);
        if (arrayLen == null) {
            return null;
        }
        PollCertRequestEntry[] entries = new PollCertRequestEntry[arrayLen.intValue()];
        for (int i = 0; i < arrayLen; ++i) {
            entries[i] = PollCertRequestEntry.decode(decoder);
        }
        return entries;
    }
}

